/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities.power_ups;

import java.util.Iterator;
import java.util.List;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

public class BasePowerUpEntity
extends PathfinderMob {
    public BasePowerUpEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    public void tick() {
        super.tick();
        this.checkForCollision();
    }

    public boolean isPushable() {
        return false;
    }

    public void jumpInFluid(FluidType type) {
        this.jumpInLiquidInternal(() -> super.jumpInFluid(type));
    }

    private void jumpInLiquidInternal(Runnable onSuper) {
        if (this.getNavigation().canFloat()) {
            onSuper.run();
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.0, 0.0));
        }
    }

    public void travel(Vec3 vec3) {
        if (this.isControlledByLocalInstance()) {
            double d9 = this.getY();
            double d0 = this.getGravity();
            boolean flag = this.getDeltaMovement().y <= 0.0;
            FluidState fluidstate = this.level().getFluidState(this.blockPosition());
            if (flag && this.hasEffect(MobEffects.SLOW_FALLING)) {
                d0 = Math.min(d0, 0.01);
            }
            if ((this.isInWaterOrBubble() || this.isInFluidType(fluidstate) && fluidstate.getFluidType() != NeoForgeMod.LAVA_TYPE.value()) && this.isAffectedByFluids() && !this.canStandOnFluid(fluidstate)) {
                if (this.isInWaterOrBubble() || this.isInFluidType(fluidstate) && !this.moveInFluid(fluidstate, vec3, d0)) {
                    float f4 = this.isSprinting() ? 0.9f : this.getWaterSlowDown();
                    float f5 = 0.02f;
                    float f6 = (float)this.getAttributeValue(Attributes.WATER_MOVEMENT_EFFICIENCY);
                    if (!this.onGround()) {
                        f6 *= 1.0f;
                    }
                    if (f6 > 0.0f) {
                        f4 += (0.54600006f - f4) * f6;
                        f5 += (this.getSpeed() - f5) * f6;
                    }
                    if (this.hasEffect(MobEffects.DOLPHINS_GRACE)) {
                        f4 = 0.96f;
                    }
                    this.moveRelative(f5 *= (float)this.getAttributeValue(NeoForgeMod.SWIM_SPEED), vec3);
                    this.move(MoverType.SELF, this.getDeltaMovement());
                    Vec3 vec36 = this.getDeltaMovement();
                    if (this.horizontalCollision && this.onClimbable()) {
                        vec36 = new Vec3(vec36.x, 0.5, vec36.z);
                    }
                    this.setDeltaMovement(vec36.multiply((double)f4, (double)0.7f, (double)f4));
                    Vec3 vec32 = this.getFluidFallingAdjustedMovement(d0, flag, this.getDeltaMovement());
                    this.setDeltaMovement(vec32);
                    if (this.horizontalCollision && this.isFree(vec32.x, vec32.y + (double)0.6f - this.getY() + d9, vec32.z)) {
                        this.setDeltaMovement(vec32.x, 0.5, vec32.z);
                    }
                }
            } else {
                super.travel(vec3);
            }
        }
    }

    public boolean isMoving() {
        return this.getDeltaMovement().lengthSqr() > 0.01;
    }

    public void checkForCollision() {
        block1: {
            Iterator iterator;
            AABB boundingBox = this.getBoundingBox().inflate(0.15);
            List entities = this.level().getEntities((Entity)this, boundingBox, entity -> entity != this);
            if (entities.isEmpty() || !(iterator = entities.iterator()).hasNext()) break block1;
            Entity entity2 = (Entity)iterator.next();
            if (!entity2.level().isClientSide) {
                this.collideWithEntity(entity2);
            }
        }
    }

    public void collideWithEntity(Entity entity) {
    }
}

