/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities.power_ups;

import com.wenxin2.marioverse.entities.power_ups.MushroomEntity;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredItem;
import software.bernie.geckolib.animatable.GeoEntity;

public class OneUpMushroomEntity
extends MushroomEntity
implements GeoEntity {
    private long lastCollisionTime = 0L;

    public OneUpMushroomEntity(EntityType<? extends OneUpMushroomEntity> entityType, Level world) {
        super((EntityType<? extends MushroomEntity>)entityType, world);
    }

    public static void consecutiveReward(LivingEntity attackingEntity, LivingEntity damagedEntity, int consecutiveBounces) {
        int oneUpsRewarded = (Integer)attackingEntity.getData(DataAttachmentRegistry.ONE_UPS_REWARDED);
        attackingEntity.setData(DataAttachmentRegistry.CONSECUTIVE_BOUNCES, (Object)(consecutiveBounces + 1));
        if (consecutiveBounces == 0) {
            if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                Level level = damagedEntity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.GOOD.get(), serverWorld, (Entity)damagedEntity, 1.0);
                }
            } else if (attackingEntity instanceof Player) {
                Player player = (Player)attackingEntity;
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.good"), Boolean.TRUE.booleanValue());
            }
        } else if (consecutiveBounces == 1) {
            if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                Level level = damagedEntity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.GREAT.get(), serverWorld, (Entity)damagedEntity, 1.0);
                }
            } else if (attackingEntity instanceof Player) {
                Player player = (Player)attackingEntity;
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.great"), Boolean.TRUE.booleanValue());
            }
        } else if (consecutiveBounces == 2) {
            if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                Level level = damagedEntity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.SUPER.get(), serverWorld, (Entity)damagedEntity, 1.0);
                }
            } else if (attackingEntity instanceof Player) {
                Player player = (Player)attackingEntity;
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.super"), Boolean.TRUE.booleanValue());
            }
        } else if (consecutiveBounces == 3) {
            if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                Level level = damagedEntity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.FANTASTIC.get(), serverWorld, (Entity)damagedEntity, 1.0);
                }
            } else if (attackingEntity instanceof Player) {
                Player player = (Player)attackingEntity;
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.fantastic"), Boolean.TRUE.booleanValue());
            }
        } else if (consecutiveBounces == 4) {
            if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                Level level = damagedEntity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.EXCELLENT.get(), serverWorld, (Entity)damagedEntity, 1.0);
                }
            } else if (attackingEntity instanceof Player) {
                Player player = (Player)attackingEntity;
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.excellent"), Boolean.TRUE.booleanValue());
            }
        } else if (consecutiveBounces == 5) {
            if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                Level level = damagedEntity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.INCREDIBLE.get(), serverWorld, (Entity)damagedEntity, 1.0);
                }
            } else if (attackingEntity instanceof Player) {
                Player player = (Player)attackingEntity;
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.incredible"), Boolean.TRUE.booleanValue());
            }
        } else if (consecutiveBounces == 6) {
            if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                Level level = damagedEntity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.WONDERFUL.get(), serverWorld, (Entity)damagedEntity, 1.0);
                }
            } else if (attackingEntity instanceof Player) {
                Player player = (Player)attackingEntity;
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.wonderful"), Boolean.TRUE.booleanValue());
            }
        } else if (consecutiveBounces >= 7 && (Integer)ConfigRegistry.MAX_ONE_UP_BOUNCE_REWARD.get() > oneUpsRewarded && !attackingEntity.getType().is(TagRegistry.CANNOT_REWARD_ONE_UPS)) {
            attackingEntity.setData(DataAttachmentRegistry.ONE_UPS_REWARDED, (Object)(oneUpsRewarded + 1));
            attackingEntity.setData(DataAttachmentRegistry.ONE_UPS_COOLDOWN, (Object)((Integer)ConfigRegistry.ONE_UP_COOLDOWN.get()));
            OneUpMushroomEntity.bounceReward(attackingEntity);
            if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                Level level = damagedEntity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.ONE_UP.get(), serverWorld, (Entity)damagedEntity, 1.0);
                }
            } else if (attackingEntity instanceof Player) {
                Player player = (Player)attackingEntity;
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.one_up"), Boolean.TRUE.booleanValue());
            }
        }
    }

    public static void bounceReward(LivingEntity entity) {
        DeferredItem<Item> item = ItemRegistry.ONE_UP_MUSHROOM;
        if (!entity.isSpectator() && (((Boolean)ConfigRegistry.ONE_UP_HEALS_ALL_MOBS.get()).booleanValue() || entity.getType().is(TagRegistry.CAN_CONSUME_ONE_UPS))) {
            AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)entity);
            ItemStack offhandStack = entity.getOffhandItem();
            if (capability != null && !capability.isEquipped((Item)ItemRegistry.ONE_UP_MUSHROOM.get())) {
                capability.attemptToEquipAccessory(new ItemStack((ItemLike)ItemRegistry.ONE_UP_MUSHROOM.get()));
            } else if (offhandStack.isEmpty()) {
                entity.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack(item));
            } else if (offhandStack.getCount() >= 1 && entity instanceof Player) {
                Player player = (Player)entity;
                player.addItem(new ItemStack((ItemLike)ItemRegistry.ONE_UP_MUSHROOM.get()));
            }
            entity.level().playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.ONE_UP_COLLECTED.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public void collideWithEntity(Entity entity) {
        if (!this.level().isClientSide) {
            DeferredItem<Item> item = ItemRegistry.ONE_UP_MUSHROOM;
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastCollisionTime < 500L) {
                return;
            }
            this.lastCollisionTime = currentTime;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (entity instanceof AbilitiesHandler) {
                    AbilitiesHandler handler = (AbilitiesHandler)entity;
                    handler.applyOneUpMushroomPowerUp(this.level(), new ItemStack(item), livingEntity, this);
                }
            }
        }
    }
}

