/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities.power_ups;

import com.wenxin2.marioverse.entities.ai.controls.BounceMoveControl;
import com.wenxin2.marioverse.entities.ai.goals.ContinuousJumpGoal;
import com.wenxin2.marioverse.entities.power_ups.BasePowerUpEntity;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidType;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SuperStarEntity
extends BasePowerUpEntity
implements GeoEntity {
    protected static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.super_star.idle");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SuperStarEntity(EntityType<? extends SuperStarEntity> entityType, Level world) {
        super(entityType, world);
        this.moveControl = new BounceMoveControl((Mob)this, 1, this.getJumpSound(), 1.0f, 1.0f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new ContinuousJumpGoal((Mob)this));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Walk", 0, this::walkAnimation));
    }

    protected <E extends GeoAnimatable> PlayState walkAnimation(AnimationState<E> event) {
        if (this.isMoving()) {
            event.setAndContinue(WALK);
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected SoundEvent getJumpSound() {
        return (SoundEvent)SoundRegistry.SUPER_STAR_BOUNCE.get();
    }

    @Override
    public void tick() {
        super.tick();
        RandomSource rand = RandomSource.create();
        if (this.level().getRandom().nextBoolean()) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level;
                ServerParticleUtils.spawnSingleParticleOnEntityRandomly((ParticleOptions)ParticleRegistry.COIN_GLINT.get(), serverWorld, (Entity)this);
            }
            ServerParticleUtils.spawnClientParticleTrail((ParticleOptions)ParticleRegistry.COIN_GLINT.get(), (Entity)this, true, 5, rand.nextDouble() * (double)this.getBbHeight(), 0.1);
        }
    }

    @Override
    public void jumpInFluid(FluidType type) {
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, this.getAttributeValue(Attributes.JUMP_STRENGTH), 0.0));
        }
    }

    @Override
    public void collideWithEntity(Entity entity) {
        Level world = this.level();
        Entity vehicle = entity.getVehicle();
        if (!world.isClientSide && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity instanceof AbilitiesHandler) {
                AbilitiesHandler handler = (AbilitiesHandler)entity;
                handler.applySuperStarPowerUp(world, livingEntity, this);
                while (vehicle instanceof AbilitiesHandler) {
                    AbilitiesHandler vehicleHandler = (AbilitiesHandler)vehicle;
                    if (!(vehicle instanceof LivingEntity)) break;
                    LivingEntity livingVehicle = (LivingEntity)vehicle;
                    vehicleHandler.applySuperStarPowerUp(world, livingVehicle, this);
                    vehicle = vehicle.getVehicle();
                }
                for (Entity passenger : entity.getPassengers()) {
                    this.applyToRiders(world, passenger);
                }
            }
        }
    }

    private void applyToRiders(Level world, Entity firstEntity) {
        Entity currentEntity = firstEntity;
        while (currentEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)currentEntity;
            if (currentEntity instanceof AbilitiesHandler) {
                AbilitiesHandler riderHandler = (AbilitiesHandler)currentEntity;
                riderHandler.applySuperStarPowerUp(world, livingEntity, this);
            }
            currentEntity = currentEntity.getFirstPassenger();
        }
    }
}

