/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.event_handlers;

import com.mojang.brigadier.CommandDispatcher;
import com.wenxin2.marioverse.accessories.PlasticBucketAccessory;
import com.wenxin2.marioverse.blocks.WarpDoorBlock;
import com.wenxin2.marioverse.blocks.WarpTrapDoorBlock;
import com.wenxin2.marioverse.blocks.behaviors.DispenserBehaviors;
import com.wenxin2.marioverse.commands.PowerUpCommand;
import com.wenxin2.marioverse.datagen.AdvancementDataGen;
import com.wenxin2.marioverse.datagen.BannerPatternTagsGen;
import com.wenxin2.marioverse.datagen.BiomeTagsGen;
import com.wenxin2.marioverse.datagen.BlockLootTableGen;
import com.wenxin2.marioverse.datagen.BlockStateGen;
import com.wenxin2.marioverse.datagen.BlockTagsGen;
import com.wenxin2.marioverse.datagen.DamageTypeTagsGen;
import com.wenxin2.marioverse.datagen.DataMapGen;
import com.wenxin2.marioverse.datagen.EnchantmentTagsGen;
import com.wenxin2.marioverse.datagen.EntityTypeTagsGen;
import com.wenxin2.marioverse.datagen.FluidTagsGen;
import com.wenxin2.marioverse.datagen.ItemModelGen;
import com.wenxin2.marioverse.datagen.ItemTagsGen;
import com.wenxin2.marioverse.datagen.RecipeGen;
import com.wenxin2.marioverse.dynamic_pack.DynamicServerResources;
import com.wenxin2.marioverse.integration.CompatRegistry;
import com.wenxin2.marioverse.items.WarpDoorBlockItem;
import com.wenxin2.marioverse.items.WarpTrapDoorBlockItem;
import com.wenxin2.marioverse.items.fluids.PlasticBucketWrapper;
import com.wenxin2.marioverse.registries.BannerPatternRegistry;
import com.wenxin2.marioverse.registries.BlockRegistry;
import com.wenxin2.marioverse.registries.DamageTypeRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.Accessory;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(modid="marioverse")
public class RegistryEventHandlers {
    public static final Map<Block, Block> WARP_DOORS = new IdentityHashMap<Block, Block>();
    public static final Map<Block, Block> WARP_TRAPDOORS = new IdentityHashMap<Block, Block>();
    private static final Set<String> DOOR_STATES = Set.of("facing", "half", "hinge", "open", "powered");
    private static final Set<String> TRAPDOOR_STATES = Set.of("facing", "half", "open", "powered");
    private static final String WATERLOGGED = "waterlogged";

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        PowerUpCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRegisterBlocks(RegisterEvent event) {
        event.register(Registries.BLOCK, helper -> {
            for (Block block : BuiltInRegistries.BLOCK) {
                boolean hasStates;
                if (!(block instanceof DoorBlock)) continue;
                DoorBlock source = (DoorBlock)block;
                if (block instanceof WarpDoorBlock) continue;
                StateDefinition stateDefinition = source.getStateDefinition();
                Set propertyNames = stateDefinition.getProperties().stream().map(Property::getName).collect(Collectors.toSet());
                boolean bl = hasStates = propertyNames.equals(DOOR_STATES) || propertyNames.equals(Stream.concat(DOOR_STATES.stream(), Stream.of(WATERLOGGED)).collect(Collectors.toSet()));
                if (!hasStates) continue;
                ResourceLocation sourceID = BuiltInRegistries.BLOCK.getKey((Object)source);
                ResourceLocation warpID = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)(sourceID.getNamespace() + "_warp_" + sourceID.getPath()));
                WarpDoorBlock warpDoor = new WarpDoorBlock(source);
                helper.register(warpID, (Object)warpDoor);
                WARP_DOORS.put((Block)source, (Block)warpDoor);
            }
        });
        event.register(Registries.BLOCK, helper -> {
            for (Block block : BuiltInRegistries.BLOCK) {
                boolean hasStates;
                if (!(block instanceof TrapDoorBlock)) continue;
                TrapDoorBlock source = (TrapDoorBlock)block;
                if (block instanceof WarpTrapDoorBlock || block.defaultBlockState().is(CompatRegistry.COPYCATS_IRON_TRAPDOOR.get()) || block.defaultBlockState().is(CompatRegistry.COPYCATS_TRAPDOOR.get())) continue;
                StateDefinition stateDefinition = source.getStateDefinition();
                Set propertyNames = stateDefinition.getProperties().stream().map(Property::getName).collect(Collectors.toSet());
                boolean bl = hasStates = propertyNames.equals(TRAPDOOR_STATES) || propertyNames.equals(Stream.concat(TRAPDOOR_STATES.stream(), Stream.of(WATERLOGGED)).collect(Collectors.toSet()));
                if (!hasStates) continue;
                ResourceLocation sourceID = BuiltInRegistries.BLOCK.getKey((Object)source);
                ResourceLocation warpID = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)(sourceID.getNamespace() + "_warp_" + sourceID.getPath()));
                WarpTrapDoorBlock warpTrapDoor = new WarpTrapDoorBlock(source);
                helper.register(warpID, (Object)warpTrapDoor);
                WARP_TRAPDOORS.put((Block)source, (Block)warpTrapDoor);
            }
        });
        event.register(Registries.ITEM, helper -> {
            for (Map.Entry<Block, Block> block : WARP_DOORS.entrySet()) {
                Block source = block.getKey();
                Block warp = block.getValue();
                ResourceLocation warpID = BuiltInRegistries.BLOCK.getKey((Object)warp);
                helper.register(warpID, (Object)new WarpDoorBlockItem(warp, source, new Item.Properties()));
            }
        });
        event.register(Registries.ITEM, helper -> {
            for (Map.Entry<Block, Block> block : WARP_TRAPDOORS.entrySet()) {
                Block source = block.getKey();
                Block warp = block.getValue();
                ResourceLocation warpID = BuiltInRegistries.BLOCK.getKey((Object)warp);
                helper.register(warpID, (Object)new WarpTrapDoorBlockItem(warp, source, new Item.Properties()));
            }
        });
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(DispenserBehaviors::register);
        event.enqueueWork(() -> AccessoriesAPI.registerAccessory((Item)((Item)ItemRegistry.PLASTIC_BUCKET.get()), (Accessory)new PlasticBucketAccessory()));
    }

    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        BlockTagsGen blockTags = new BlockTagsGen(output, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStateGen(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGen(output, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new AdvancementDataGen(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DataMapGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(output, lookupProvider, new RegistrySetBuilder().add(Registries.BANNER_PATTERN, BannerPatternRegistry::bootstrap).add(Registries.DAMAGE_TYPE, DamageTypeRegistry::bootstrap), Set.of("marioverse")));
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new BannerPatternTagsGen(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new BiomeTagsGen(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new BlockLootTableGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new DamageTypeTagsGen(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new EnchantmentTagsGen(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new EntityTypeTagsGen(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new FluidTagsGen(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagsGen(output, lookupProvider, blockTags.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeGen(output, lookupProvider));
    }

    public static void addPackFinder(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            ResourceLocation packLocation = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"dynamic_resources");
            MutableComponent packNameDisplay = Component.translatable((String)"datapack.marioverse.dynamic_resources");
            PackLocationInfo packLocationInfo = new PackLocationInfo("marioverse:dynamic_resources", (Component)packNameDisplay, PackSource.BUILT_IN, Optional.of(new KnownPack("marioverse", "mod/" + String.valueOf(packLocation), "22")));
            event.addRepositorySource(consumer -> consumer.accept(Pack.readMetaAndCreate((PackLocationInfo)packLocationInfo, (Pack.ResourcesSupplier)new Pack.ResourcesSupplier(){

                public PackResources openPrimary(PackLocationInfo info) {
                    return new DynamicServerResources(info);
                }

                public PackResources openFull(PackLocationInfo info, Pack.Metadata metadata) {
                    return new DynamicServerResources(info);
                }
            }, (PackType)PackType.SERVER_DATA, (PackSelectionConfig)new PackSelectionConfig(true, Pack.Position.TOP, false))));
        }
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, contex) -> new PlasticBucketWrapper((ItemStack)stack), new ItemLike[]{ItemRegistry.PLASTIC_BUCKET});
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, contex) -> new PlasticBucketWrapper((ItemStack)stack), new ItemLike[]{ItemRegistry.PLASTIC_WATER_BUCKET});
    }

    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        Int2ObjectMap trades = event.getTrades();
        if (event.getType() == VillagerProfession.CARTOGRAPHER) {
            for (Map.Entry<DyeColor, DeferredBlock<Block>> entry : BlockRegistry.GOAL_POLES.entrySet()) {
                ((List)trades.get(3)).add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)entry.getValue(), 1), 15, 16, 0.05f));
            }
            for (Map.Entry<DyeColor, DeferredBlock<Block>> entry : BlockRegistry.CHECKPOINT_FLAGS.entrySet()) {
                ((List)trades.get(3)).add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)entry.getValue(), 1), 15, 16, 0.05f));
            }
            ((List)trades.get(5)).add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack(BlockRegistry.CLASSIC_GOAL_POLE, 1), 10, 30, 0.05f));
            ((List)trades.get(5)).add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 10), new ItemStack(BlockRegistry.CLASSIC_CHECKPOINT_FLAG, 1), 10, 30, 0.05f));
        }
        if (event.getType() == VillagerProfession.CLERIC) {
            ((List)trades.get(1)).add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ItemRegistry.DASH_MUSHROOM.get(), 3), 5, 8, 0.05f));
            ((List)trades.get(3)).add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 8), new ItemStack((ItemLike)ItemRegistry.MINI_MUSHROOM.get(), 1), 3, 25, 0.2f));
            ((List)trades.get(1)).add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 8), new ItemStack((ItemLike)ItemRegistry.SUPER_MUSHROOM.get(), 1), 5, 16, 0.05f));
            ((List)trades.get(4)).add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 25), new ItemStack((ItemLike)ItemRegistry.ONE_UP_MUSHROOM.get(), 1), 1, 30, 0.1f));
        }
        if (event.getType() == VillagerProfession.WEAPONSMITH) {
            ((List)trades.get(2)).add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)ItemRegistry.GREEN_KOOPA_SHELL.get(), 1), 9, 16, 0.1f));
            ((List)trades.get(2)).add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 9), new ItemStack((ItemLike)ItemRegistry.GREEN_KOOPA_SHELL.get(), 3), 3, 16, 0.15f));
            ((List)trades.get(3)).add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 16), new ItemStack((ItemLike)ItemRegistry.RED_KOOPA_SHELL.get(), 1), 9, 24, 0.2f));
            ((List)trades.get(3)).add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 16), new ItemStack((ItemLike)ItemRegistry.RED_KOOPA_SHELL.get(), 3), 3, 24, 0.25f));
            ((List)trades.get(4)).add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 32), new ItemStack((ItemLike)ItemRegistry.GOLD_KOOPA_SHELL.get(), 1), 3, 30, 0.25f));
        }
    }

    @SubscribeEvent
    public static void addWandererTrades(WandererTradesEvent event) {
        List genericTrades = event.getGenericTrades();
        List rareTrades = event.getRareTrades();
        genericTrades.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 8), new ItemStack((ItemLike)ItemRegistry.FIRE_FLOWER.get(), 1), 8, 16, 0.1f));
        genericTrades.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 8), new ItemStack((ItemLike)ItemRegistry.ICE_FLOWER.get(), 1), 8, 16, 0.1f));
        genericTrades.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ItemRegistry.DASH_MUSHROOM.get(), 3), 15, 10, 0.1f));
        genericTrades.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 8), new ItemStack((ItemLike)ItemRegistry.MINI_MUSHROOM.get(), 1), 3, 16, 0.2f));
        genericTrades.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 8), new ItemStack((ItemLike)ItemRegistry.SUPER_MUSHROOM.get(), 1), 8, 16, 0.2f));
        genericTrades.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack(BlockRegistry.COIN, 9), 8, 10, 0.2f));
        genericTrades.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack(BlockRegistry.STAR_COIN, 1), 8, 10, 0.2f));
        rareTrades.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack(BlockRegistry.CLASSIC_GOAL_POLE, 1), 8, 10, 0.2f));
        rareTrades.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 10), new ItemStack(BlockRegistry.CLASSIC_CHECKPOINT_FLAG, 1), 8, 10, 0.2f));
        rareTrades.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 25), new ItemStack((ItemLike)ItemRegistry.ONE_UP_MUSHROOM.get(), 1), 1, 30, 0.1f));
        rareTrades.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 32), new ItemStack((ItemLike)ItemRegistry.MEGA_MUSHROOM.get(), 1), 1, 30, 0.2f));
        rareTrades.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 32), new ItemStack((ItemLike)ItemRegistry.SUPER_STAR.get(), 1), 1, 30, 0.2f));
    }
}

