/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.event_handlers;

import com.wenxin2.marioverse.Marioverse;
import com.wenxin2.marioverse.registries.AttributesRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DamageSourceRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.spongepowered.asm.mixin.Unique;

@EventBusSubscriber(modid="marioverse")
public class TickEventHandlers {
    private static double currentEyeHeightScale = 1.0;
    private static double currentHeightScale = 1.0;
    private static double currentWidthScale = 1.0;

    @SubscribeEvent
    public static void preEntityTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        Level level = entity.level();
        double deltaY = entity.getDeltaMovement().y;
        if ((entity.onGround() || entity.isInWaterOrBubble()) && deltaY <= 0.0 && ((Boolean)entity.getData(DataAttachmentRegistry.HAS_HIT_BLOCK.get())).booleanValue()) {
            entity.setData(DataAttachmentRegistry.HAS_HIT_BLOCK.get(), (Object)false);
        }
        if (((Boolean)ConfigRegistry.ENABLE_STOMPABLE_ENEMIES.get()).booleanValue() && (entity.getType().is(TagRegistry.CAN_STOMP_ENEMIES) || ((Boolean)ConfigRegistry.ALL_MOBS_CAN_STOMP.get()).booleanValue() || level.getGameRules().getBoolean(Marioverse.ALL_MOBS_CAN_STOMP)) && (entity.onGround() || entity.isInWaterOrBubble()) && (Integer)entity.getData(DataAttachmentRegistry.CONSECUTIVE_BOUNCES) > 0 && !((Boolean)entity.getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue()) {
            entity.setData(DataAttachmentRegistry.CONSECUTIVE_BOUNCES, (Object)0);
        }
        if (!level.isClientSide && !entity.isSpectator() && !entity.isShiftKeyDown() && ((Boolean)entity.getData(DataAttachmentRegistry.HAS_MEGA_MUSHROOM)).booleanValue()) {
            if (((Boolean)ConfigRegistry.MEGA_MUSHROOM_BREAKS_BLOCKS.get()).booleanValue() && (((Boolean)ConfigRegistry.MEGA_MOBS_BREAK_BLOCKS.get()).booleanValue() || entity.getType().is(TagRegistry.CAN_BREAK_BLOCKS_AS_MEGA)) && (level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) || entity instanceof Player && entity.getType().is(TagRegistry.CAN_BREAK_BLOCKS_AS_MEGA))) {
                TickEventHandlers.breakBlocks(entity);
            }
            TickEventHandlers.collideWithEntity(entity);
        }
        if (entity.hasData(DataAttachmentRegistry.ATTACK_COOLDOWN) && (Integer)entity.getData(DataAttachmentRegistry.ATTACK_COOLDOWN) > 0) {
            entity.setData(DataAttachmentRegistry.ATTACK_COOLDOWN, (Object)((Integer)entity.getData(DataAttachmentRegistry.ATTACK_COOLDOWN) - 1));
        }
        if (entity.hasData(DataAttachmentRegistry.CHECKPOINT_FLAG_COOLDOWN) && (Integer)entity.getData(DataAttachmentRegistry.CHECKPOINT_FLAG_COOLDOWN) > 0) {
            entity.setData(DataAttachmentRegistry.CHECKPOINT_FLAG_COOLDOWN, (Object)((Integer)entity.getData(DataAttachmentRegistry.CHECKPOINT_FLAG_COOLDOWN) - 1));
        }
        if (entity.hasData(DataAttachmentRegistry.FIREBALL_COOLDOWN) && (Integer)entity.getData(DataAttachmentRegistry.FIREBALL_COOLDOWN) > 0) {
            entity.setData(DataAttachmentRegistry.FIREBALL_COOLDOWN, (Object)((Integer)entity.getData(DataAttachmentRegistry.FIREBALL_COOLDOWN) - 1));
        }
        if (entity.hasData(DataAttachmentRegistry.FREEZE_IMMUNITY_DURATION) && (Integer)entity.getData(DataAttachmentRegistry.FREEZE_IMMUNITY_DURATION) > 0) {
            entity.setData(DataAttachmentRegistry.FREEZE_IMMUNITY_DURATION, (Object)((Integer)entity.getData(DataAttachmentRegistry.FREEZE_IMMUNITY_DURATION) - 1));
        }
        if (entity.hasData(DataAttachmentRegistry.FROZEN_DURATION) && (Integer)entity.getData(DataAttachmentRegistry.FROZEN_DURATION) > 0) {
            entity.setData(DataAttachmentRegistry.FROZEN_DURATION, (Object)((Integer)entity.getData(DataAttachmentRegistry.FROZEN_DURATION) - 1));
        }
        if (entity.hasData(DataAttachmentRegistry.ICE_BALL_COOLDOWN) && (Integer)entity.getData(DataAttachmentRegistry.ICE_BALL_COOLDOWN) > 0) {
            entity.setData(DataAttachmentRegistry.ICE_BALL_COOLDOWN, (Object)((Integer)entity.getData(DataAttachmentRegistry.ICE_BALL_COOLDOWN) - 1));
        }
        if (entity.hasData(DataAttachmentRegistry.MEGA_MUSHROOM_DURATION) && (Integer)entity.getData(DataAttachmentRegistry.MEGA_MUSHROOM_DURATION) > 0) {
            entity.setData(DataAttachmentRegistry.MEGA_MUSHROOM_DURATION, (Object)((Integer)entity.getData(DataAttachmentRegistry.MEGA_MUSHROOM_DURATION) - 1));
        }
        if (entity.hasData(DataAttachmentRegistry.ONE_UPS_COOLDOWN) && (Integer)entity.getData(DataAttachmentRegistry.ONE_UPS_COOLDOWN) > 0) {
            entity.setData(DataAttachmentRegistry.ONE_UPS_COOLDOWN, (Object)((Integer)entity.getData(DataAttachmentRegistry.ONE_UPS_COOLDOWN) - 1));
        }
        if (entity.hasData(DataAttachmentRegistry.SUPER_STAR_DURATION) && (Integer)entity.getData(DataAttachmentRegistry.SUPER_STAR_DURATION) > 0) {
            entity.setData(DataAttachmentRegistry.SUPER_STAR_DURATION, (Object)((Integer)entity.getData(DataAttachmentRegistry.SUPER_STAR_DURATION) - 1));
        }
        if (entity.hasData(DataAttachmentRegistry.WARP_COOLDOWN) && (Integer)entity.getData(DataAttachmentRegistry.WARP_COOLDOWN) > 0) {
            entity.setData(DataAttachmentRegistry.WARP_COOLDOWN, (Object)((Integer)entity.getData(DataAttachmentRegistry.WARP_COOLDOWN) - 1));
        }
        if (entity.hasData(DataAttachmentRegistry.PREVENT_WARP_COOLDOWN)) {
            int preventWarpCooldown = (Integer)entity.getData(DataAttachmentRegistry.PREVENT_WARP_COOLDOWN);
            if (preventWarpCooldown > 0) {
                entity.setData(DataAttachmentRegistry.PREVENT_WARP_COOLDOWN, (Object)(preventWarpCooldown - 1));
            }
            if (preventWarpCooldown == 0 && ((Boolean)entity.getData(DataAttachmentRegistry.PREVENT_WARP)).booleanValue()) {
                entity.setData(DataAttachmentRegistry.PREVENT_WARP, (Object)false);
            }
        }
        if ((Integer)entity.getData(DataAttachmentRegistry.MEGA_MUSHROOM_DURATION) == 0 && ((Boolean)entity.getData(DataAttachmentRegistry.HAS_MEGA_MUSHROOM)).booleanValue() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            AttributeInstance healthAttribute = livingEntity.getAttribute(Attributes.MAX_HEALTH);
            AttributeInstance stepAttribute = livingEntity.getAttribute(Attributes.STEP_HEIGHT);
            entity.setData(DataAttachmentRegistry.HAS_MEGA_MUSHROOM, (Object)false);
            entity.setData(DataAttachmentRegistry.PLAYED_MEGA_MUSHROOM_THEME, (Object)false);
            AttributesRegistry.updateAttributeModifiers(stepAttribute, AttributesRegistry.AUTO_STEP_HEIGHT, (Double)ConfigRegistry.MEGA_MUSHROOM_AUTO_STEP.get(), false, true);
            AttributesRegistry.updateAttributeModifiers(healthAttribute, AttributesRegistry.MAX_HEATH, (Double)ConfigRegistry.MEGA_MUSHROOM_HEALTH.get(), false, (Boolean)entity.getData(DataAttachmentRegistry.HAS_MINI_MUSHROOM) == false);
        }
        if ((Integer)entity.getData(DataAttachmentRegistry.SUPER_STAR_DURATION) == 0 && ((Boolean)entity.getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue()) {
            entity.setData(DataAttachmentRegistry.HAS_SUPER_STAR, (Object)false);
            entity.setData(DataAttachmentRegistry.PLAYED_SUPER_STAR_THEME, (Object)false);
        }
    }

    @SubscribeEvent
    public static void postEntityTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        Level level = entity.level();
        BlockPos pos = entity.blockPosition();
        Vec3 motion = entity.getDeltaMovement();
        int spinningTicks = entity.getPersistentData().getInt("marioverse:spinning_ticks");
        if (!level.isClientSide && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            TickEventHandlers.megaMushroomScale(livingEntity);
            TickEventHandlers.miniMushroomScale(livingEntity);
            TickEventHandlers.superMushroomScale(livingEntity);
        }
        if (entity.isVehicle() && spinningTicks > 0) {
            entity.setYRot(entity.getYRot() + 30.0f);
            entity.getPersistentData().putInt("marioverse:spinning_ticks", spinningTicks - 1);
            for (Entity rider : entity.getPassengers()) {
                rider.setYHeadRot(rider.getYHeadRot() + 30.0f);
            }
        }
        if (((Boolean)entity.getData(DataAttachmentRegistry.HAS_MINI_MUSHROOM)).booleanValue() && (entity.isSprinting() || entity.getDeltaMovement().horizontalDistance() >= 0.25) && level.getFluidState(pos).is(FluidTags.WATER) && !level.getFluidState(pos.above()).is(FluidTags.WATER)) {
            if (motion.y <= 0.0) {
                entity.setDeltaMovement(motion.x, 0.0, motion.z);
            }
            entity.setOnGround(true);
            entity.fallDistance = 0.0f;
        }
    }

    public static void collideWithEntity(Entity attackingEntity) {
        AABB boundingBox = attackingEntity.getBoundingBox().inflate(0.15);
        List entities = attackingEntity.level().getEntities(attackingEntity, boundingBox, entityList -> entityList != attackingEntity);
        if (!entities.isEmpty()) {
            for (Entity collidedEntity : entities) {
                Entity vehicle;
                if (collidedEntity.level().isClientSide) break;
                if (!(attackingEntity instanceof LivingEntity)) {
                    return;
                }
                LivingEntity livingEntity = (LivingEntity)attackingEntity;
                if (!(collidedEntity instanceof LivingEntity)) continue;
                LivingEntity collidedLivingEntity = (LivingEntity)collidedEntity;
                if ((Integer)attackingEntity.getData(DataAttachmentRegistry.ATTACK_COOLDOWN) > 0) {
                    return;
                }
                if (attackingEntity.isSpectator() || !collidedEntity.isAlive() || collidedEntity.getType().is(TagRegistry.MEGA_MUSHROOM_CANNOT_DAMAGE) || attackingEntity.getVehicle() == collidedEntity || collidedEntity.getVehicle() == attackingEntity || attackingEntity.isPassengerOfSameVehicle(collidedEntity)) continue;
                if (attackingEntity.isPassenger() && (vehicle = attackingEntity.getVehicle()) != null) {
                    Vec3 ridingPos = vehicle.getPassengerRidingPosition(attackingEntity);
                    if (collidedLivingEntity.getBoundingBox().maxY <= ridingPos.y) continue;
                }
                boolean hasNoArmor = true;
                for (ItemStack armorSlot : collidedLivingEntity.getArmorSlots()) {
                    if (armorSlot.isEmpty()) continue;
                    hasNoArmor = false;
                    break;
                }
                if (((Boolean)ConfigRegistry.MEGA_MOBS_DO_DAMAGE.get()).booleanValue() || attackingEntity.getType().is(TagRegistry.CAN_DO_DAMAGE_AS_MEGA)) {
                    if (hasNoArmor && attackingEntity.getType().is(TagRegistry.MEGA_MUSHROOM_CAN_INSTAKILL)) {
                        collidedEntity.hurt(DamageSourceRegistry.megaMushroom((Entity)collidedLivingEntity, attackingEntity), collidedLivingEntity.getHealth());
                    } else {
                        collidedEntity.hurt(DamageSourceRegistry.megaMushroom((Entity)collidedLivingEntity, attackingEntity), ((Double)ConfigRegistry.MEGA_MUSHROOM_DAMAGE.get()).floatValue());
                    }
                }
                if (attackingEntity instanceof NeutralMob) {
                    NeutralMob neutralMob = (NeutralMob)attackingEntity;
                    neutralMob.isAngryAt(livingEntity);
                    neutralMob.setTarget(livingEntity);
                    neutralMob.setPersistentAngerTarget(attackingEntity.getUUID());
                }
                double knockbackStrength = 3.0;
                Vec3 knockbackDirection = collidedEntity.position().subtract(attackingEntity.position()).normalize();
                Vec3 knockbackVelocity = knockbackDirection.scale(knockbackStrength).add(0.0, 1.0, 0.0);
                collidedEntity.setDeltaMovement(knockbackVelocity);
                attackingEntity.setData(DataAttachmentRegistry.ATTACK_COOLDOWN, (Object)1);
                break;
            }
        }
    }

    private static void breakBlocks(Entity entity) {
        Mob mob;
        Level level = entity.level();
        AABB box = entity.getBoundingBox();
        Vec3 motion = entity.getDeltaMovement();
        double moveX = entity.getX() - entity.xOld;
        double moveZ = entity.getZ() - entity.zOld;
        Direction facing = Direction.getNearest((double)moveX, (double)0.0, (double)moveZ);
        double dx = facing.getStepX();
        double dz = facing.getStepZ();
        if (facing.getAxis().isVertical()) {
            return;
        }
        if (entity instanceof Mob && (mob = (Mob)entity).isNoAi()) {
            return;
        }
        if (entity.isSpectator()) {
            return;
        }
        AABB forwardBox = box.move(dx * 0.5, 0.0, dz * 0.5).inflate(Math.max(Math.abs(dx) * 1.15, 0.25), 0.0, Math.max(Math.abs(dz) * 1.15, 0.25));
        TickEventHandlers.breakIntersectingBlocks(level, entity, forwardBox, false, false);
        if (motion.y > 0.0) {
            AABB aboveBox = box.move(0.0, 1.0, 0.0).inflate(0.0, 0.0, 0.0);
            TickEventHandlers.breakIntersectingBlocks(level, entity, aboveBox, true, false);
        }
        if (motion.y < -0.25) {
            AABB belowBox = box.move(0.0, -1.0, 0.0).inflate(0.0, 0.0, 0.0);
            TickEventHandlers.breakIntersectingBlocks(level, entity, belowBox, false, true);
        }
    }

    private static void breakIntersectingBlocks(Level level, Entity entity, AABB box, boolean isJumping, boolean isFalling) {
        BlockPos min = BlockPos.containing((double)box.minX, (double)box.minY, (double)box.minZ);
        BlockPos max = BlockPos.containing((double)box.maxX, (double)box.maxY, (double)box.maxZ);
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)min, (BlockPos)max)) {
            Player player;
            Player player2;
            Player player3;
            BlockState state = level.getBlockState(pos);
            if (isFalling) {
                if (!state.is(TagRegistry.MEGA_MUSHROOM_CAN_BREAK_WHEN_FALLING)) {
                    continue;
                }
            } else {
                Entity vehicle;
                if (!state.is(TagRegistry.MEGA_MUSHROOM_CAN_BREAK)) continue;
                if (entity.isPassenger() && (vehicle = entity.getVehicle()) != null) {
                    Vec3 ridingPos = vehicle.getPassengerRidingPosition(entity);
                    if ((double)pos.getY() <= ridingPos.y) continue;
                }
            }
            if (entity instanceof Player && !level.mayInteract(player3 = (Player)entity, pos) || entity instanceof Player && !(player3 = (Player)entity).mayBuild()) continue;
            TagKey<Block> breakTag = TagRegistry.MEGA_MUSHROOM_CAN_BREAK;
            if (entity instanceof Player && (player2 = (Player)entity).blockActionRestricted(level, pos, GameType.ADVENTURE)) {
                breakTag = TagRegistry.MEGA_MUSHROOM_CAN_BREAK_IN_ADVENTURE_MODE;
            }
            if (!state.isAir() && state.is(breakTag)) {
                if (entity instanceof Player && (player2 = (Player)entity).isCreative() || !((Boolean)ConfigRegistry.MEGA_MOBS_DROP_ITEMS.get()).booleanValue()) {
                    level.removeBlock(pos, true);
                } else {
                    level.destroyBlock(pos, true, entity);
                }
            }
            if (isJumping) {
                Player player4;
                BlockPos posAbove = pos.above();
                BlockState stateAbove = level.getBlockState(posAbove);
                if (stateAbove.isAir() || !stateAbove.is(breakTag) || stateAbove.getCollisionShape((BlockGetter)level, posAbove).isEmpty()) continue;
                if (entity instanceof Player && (player4 = (Player)entity).isCreative() || !((Boolean)ConfigRegistry.MEGA_MOBS_DROP_ITEMS.get()).booleanValue()) {
                    level.removeBlock(posAbove, true);
                    continue;
                }
                level.destroyBlock(posAbove, true, entity);
                continue;
            }
            if (!isFalling) continue;
            BlockPos posBelow = pos.below();
            BlockState stateBelow = level.getBlockState(posBelow);
            TagKey<Block> fallingBreakTag = TagRegistry.MEGA_MUSHROOM_CAN_BREAK_WHEN_FALLING;
            if (entity instanceof Player && (player = (Player)entity).blockActionRestricted(level, pos, GameType.ADVENTURE)) {
                fallingBreakTag = TagRegistry.MEGA_MUSHROOM_CAN_BREAK_IN_ADVENTURE_MODE;
            }
            if (stateBelow.isAir() || !stateBelow.is(fallingBreakTag)) continue;
            if (entity instanceof Player && (player = (Player)entity).isCreative() || !((Boolean)ConfigRegistry.MEGA_MOBS_DROP_ITEMS.get()).booleanValue()) {
                level.removeBlock(posBelow, true);
                continue;
            }
            level.destroyBlock(posBelow, true, entity);
        }
    }

    public static void megaMushroomScale(LivingEntity entity) {
        AttributeInstance eyeHeightScale = entity.getAttribute(AttributesRegistry.EYE_HEIGHT_SCALE);
        AttributeInstance heightScale = entity.getAttribute(AttributesRegistry.HEIGHT_SCALE);
        AttributeInstance widthScale = entity.getAttribute(AttributesRegistry.WIDTH_SCALE);
        boolean hasMegaMushroom = (Boolean)entity.getData(DataAttachmentRegistry.HAS_MEGA_MUSHROOM);
        boolean hasMiniMushroom = (Boolean)entity.getData(DataAttachmentRegistry.HAS_MINI_MUSHROOM);
        boolean hasSuperMushroom = (Boolean)entity.getData(DataAttachmentRegistry.HAS_SUPER_MUSHROOM);
        float scalingSpeed = 0.1f;
        double targetEyeHeightScale = hasMegaMushroom ? (Double)ConfigRegistry.MEGA_MUSHROOM_HEIGHT_SCALE.get() : 1.0;
        double targetHeightScale = hasMegaMushroom ? (Double)ConfigRegistry.MEGA_MUSHROOM_HEIGHT_SCALE.get() : 1.0;
        double targetWidthScale = hasMegaMushroom ? (Double)ConfigRegistry.MEGA_MUSHROOM_WIDTH_SCALE.get() : 1.0;
        boolean shouldScale = hasMegaMushroom;
        boolean shouldReset = !hasMegaMushroom && !hasMiniMushroom && hasSuperMushroom;
        TickEventHandlers.updateScale(entity, shouldScale, targetHeightScale, targetWidthScale, eyeHeightScale, targetEyeHeightScale, scalingSpeed, heightScale, widthScale, shouldReset);
    }

    public static void miniMushroomScale(LivingEntity entity) {
        double targetHeightScale;
        double targetEyeHeightScale;
        AttributeInstance eyeHeightScale = entity.getAttribute(AttributesRegistry.EYE_HEIGHT_SCALE);
        AttributeInstance heightScale = entity.getAttribute(AttributesRegistry.HEIGHT_SCALE);
        AttributeInstance widthScale = entity.getAttribute(AttributesRegistry.WIDTH_SCALE);
        boolean hasMiniMushroom = (Boolean)entity.getData(DataAttachmentRegistry.HAS_MINI_MUSHROOM);
        boolean hasSuperMushroom = (Boolean)entity.getData(DataAttachmentRegistry.HAS_SUPER_MUSHROOM);
        float scalingSpeed = 0.1f;
        double d = hasMiniMushroom ? (Double)ConfigRegistry.MINI_MUSHROOM_HEIGHT_SCALE.get() : (targetEyeHeightScale = hasSuperMushroom ? 1.0 : (Double)ConfigRegistry.SHRINK_HEIGHT_SCALE.get());
        double d2 = hasMiniMushroom ? (Double)ConfigRegistry.MINI_MUSHROOM_HEIGHT_SCALE.get() : (targetHeightScale = hasSuperMushroom ? 1.0 : (Double)ConfigRegistry.SHRINK_HEIGHT_SCALE.get());
        double targetWidthScale = hasMiniMushroom ? (Double)ConfigRegistry.MINI_MUSHROOM_WIDTH_SCALE.get() : (hasSuperMushroom ? 1.0 : (Double)ConfigRegistry.SHRINK_WIDTH_SCALE.get());
        boolean shouldScale = !hasSuperMushroom && hasMiniMushroom;
        boolean shouldReset = hasSuperMushroom && !hasMiniMushroom;
        TickEventHandlers.updateScale(entity, shouldScale, targetHeightScale, targetWidthScale, eyeHeightScale, targetEyeHeightScale, scalingSpeed, heightScale, widthScale, shouldReset);
    }

    public static void superMushroomScale(LivingEntity entity) {
        Level world = entity.level();
        AttributeInstance eyeHeightScale = entity.getAttribute(AttributesRegistry.EYE_HEIGHT_SCALE);
        AttributeInstance heightScale = entity.getAttribute(AttributesRegistry.HEIGHT_SCALE);
        AttributeInstance widthScale = entity.getAttribute(AttributesRegistry.WIDTH_SCALE);
        boolean hasMegaMushroom = (Boolean)entity.getData(DataAttachmentRegistry.HAS_MEGA_MUSHROOM);
        boolean hasMiniMushroom = (Boolean)entity.getData(DataAttachmentRegistry.HAS_MINI_MUSHROOM);
        boolean hasSuperMushroom = (Boolean)entity.getData(DataAttachmentRegistry.HAS_SUPER_MUSHROOM);
        float health = entity.getHealth();
        float scalingSpeed = 0.1f;
        double targetEyeHeightScale = hasSuperMushroom ? 1.0 : (Double)ConfigRegistry.SHRINK_HEIGHT_SCALE.get();
        double targetHeightScale = hasSuperMushroom ? 1.0 : (Double)ConfigRegistry.SHRINK_HEIGHT_SCALE.get();
        double targetWidthScale = hasSuperMushroom ? 1.0 : (Double)ConfigRegistry.SHRINK_WIDTH_SCALE.get();
        boolean isPlayer = entity instanceof Player;
        boolean shouldScale = !hasSuperMushroom && !hasMegaMushroom && !hasMiniMushroom && !entity.getType().is(TagRegistry.DAMAGE_CANNOT_SHRINK) && (isPlayer && (Boolean)entity.getData(DataAttachmentRegistry.HAS_SUPER_MUSHROOM_OVERRIDE) != false || isPlayer && (double)health <= (Double)ConfigRegistry.SHRINK_PLAYERS_AT_HEALTH.get() && world.getGameRules().getBoolean(Marioverse.DAMAGE_SHRINKS_PLAYERS) || !isPlayer && (Boolean)entity.getData(DataAttachmentRegistry.HAS_SUPER_MUSHROOM_OVERRIDE) != false || !isPlayer && (double)health <= (double)entity.getMaxHealth() * (Double)ConfigRegistry.SHRINK_MOBS_AT_HEALTH.get() && world.getGameRules().getBoolean(Marioverse.DAMAGE_SHRINKS_ALL_MOBS));
        boolean shouldReset = hasSuperMushroom && !hasMegaMushroom && !hasMiniMushroom && (isPlayer && (Boolean)entity.getData(DataAttachmentRegistry.HAS_SUPER_MUSHROOM_OVERRIDE) != false || isPlayer && (double)health > (Double)ConfigRegistry.SHRINK_PLAYERS_AT_HEALTH.get() && world.getGameRules().getBoolean(Marioverse.DAMAGE_SHRINKS_PLAYERS) || !isPlayer && (Boolean)entity.getData(DataAttachmentRegistry.HAS_SUPER_MUSHROOM_OVERRIDE) != false || !isPlayer && (double)health > (double)entity.getMaxHealth() * (Double)ConfigRegistry.SHRINK_MOBS_AT_HEALTH.get() && world.getGameRules().getBoolean(Marioverse.DAMAGE_SHRINKS_ALL_MOBS));
        TickEventHandlers.updateScale(entity, shouldScale, targetHeightScale, targetWidthScale, eyeHeightScale, targetEyeHeightScale, scalingSpeed, heightScale, widthScale, shouldReset);
    }

    private static void updateScale(LivingEntity entity, boolean shouldScale, double targetHeightScale, double targetWidthScale, AttributeInstance eyeHeightScale, double targetEyeHeightScale, float scalingSpeed, AttributeInstance heightScale, AttributeInstance widthScale, boolean shouldReset) {
        if (shouldScale && currentHeightScale != targetHeightScale && currentWidthScale != targetWidthScale) {
            if (entity.getLastDamageSource() != null && entity.isDamageSourceBlocked(entity.getLastDamageSource())) {
                return;
            }
            TickEventHandlers.scale(eyeHeightScale, targetEyeHeightScale, scalingSpeed, v -> {
                currentEyeHeightScale = v;
            });
            TickEventHandlers.scale(heightScale, targetHeightScale, scalingSpeed, v -> {
                currentHeightScale = v;
            });
            TickEventHandlers.scale(widthScale, targetWidthScale, scalingSpeed, v -> {
                currentWidthScale = v;
            });
        }
        if (shouldReset && currentHeightScale != targetHeightScale && currentWidthScale != targetWidthScale) {
            if (eyeHeightScale != null && eyeHeightScale.getValue() != 1.0) {
                TickEventHandlers.scale(eyeHeightScale, targetEyeHeightScale, scalingSpeed, v -> {
                    currentEyeHeightScale = v;
                });
            }
            if (heightScale != null && heightScale.getValue() != 1.0) {
                TickEventHandlers.scale(heightScale, targetHeightScale, scalingSpeed, v -> {
                    currentHeightScale = v;
                });
            }
            if (widthScale != null && widthScale.getValue() != 1.0) {
                TickEventHandlers.scale(widthScale, targetWidthScale, scalingSpeed, v -> {
                    currentWidthScale = v;
                });
            }
        }
    }

    @Unique
    private static void scale(AttributeInstance scaleAttribute, double targetScale, float scalingSpeed, Consumer<Double> setter) {
        ResourceLocation modifier = AttributesRegistry.DAMAGED_SCALE;
        if (scaleAttribute != null) {
            double actualScale = scaleAttribute.getValue();
            double lerpedScale = Mth.lerp((double)scalingSpeed, (double)actualScale, (double)targetScale);
            double modifierAmount = lerpedScale - 1.0;
            if (Math.abs(actualScale - targetScale) < 1.0E-4) {
                lerpedScale = targetScale;
            }
            if (scaleAttribute.hasModifier(modifier) && (Math.abs(modifierAmount) < 0.001 || targetScale == 1.0)) {
                scaleAttribute.removeModifier(modifier);
            }
            if (lerpedScale != targetScale) {
                scaleAttribute.removeModifier(modifier);
                scaleAttribute.addPermanentModifier(new AttributeModifier(modifier, modifierAmount, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
                if (Math.abs(actualScale - targetScale) < 0.01) {
                    setter.accept(targetScale);
                } else {
                    setter.accept(lerpedScale);
                }
            }
        }
    }
}

