/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.items;

import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.KeybindRegistry;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import org.jetbrains.annotations.NotNull;

public class BasePowerUpItem
extends DeferredSpawnEggItem {
    int tooltipLineAmt = 0;

    public BasePowerUpItem(Supplier<? extends EntityType<? extends Mob>> entityType, int primaryColor, int secondaryColor, Item.Properties properties) {
        super(entityType, primaryColor, secondaryColor, properties);
    }

    public BasePowerUpItem(int tooltipLineAmt, Supplier<? extends EntityType<? extends Mob>> entityType, int primaryColor, int secondaryColor, Item.Properties properties) {
        super(entityType, primaryColor, secondaryColor, properties);
        this.tooltipLineAmt = tooltipLineAmt;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltip) {
        if (Screen.hasShiftDown() && this.tooltipLineAmt > 0) {
            list.add((Component)Component.literal((String)""));
            for (int lineAmt = 1; lineAmt <= this.tooltipLineAmt; ++lineAmt) {
                MutableComponent abilityText = Component.translatable((String)(this.getDescriptionId() + ".tooltip.line" + lineAmt));
                if (stack.is(ItemRegistry.FIRE_FLOWER) && lineAmt == 2) {
                    abilityText = abilityText.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.line" + lineAmt + ".keybind"), (Object[])new Object[]{KeybindRegistry.ACTIVATE_POWER_UP.getKey().getDisplayName()}).withStyle(ChatFormatting.GREEN));
                }
                if (stack.is(ItemRegistry.ICE_FLOWER) && lineAmt == 2) {
                    abilityText = abilityText.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.line" + lineAmt + ".keybind"), (Object[])new Object[]{KeybindRegistry.ACTIVATE_POWER_UP.getKey().getDisplayName()}).withStyle(ChatFormatting.GREEN));
                }
                if (stack.is(ItemRegistry.MEGA_MUSHROOM) && lineAmt == 3) {
                    abilityText = abilityText.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.line" + lineAmt + ".hearts"), (Object[])new Object[]{(Double)ConfigRegistry.MEGA_MUSHROOM_HEALTH.get() / 2.0}).withStyle(ChatFormatting.RED));
                }
                if (stack.is(ItemRegistry.MINI_MUSHROOM) && lineAmt == 3) {
                    abilityText = abilityText.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.line" + lineAmt + ".hearts"), (Object[])new Object[]{(Double)ConfigRegistry.MINI_MUSHROOM_HEALTH.get() / 2.0}).withStyle(ChatFormatting.RED));
                }
                if (stack.is(ItemRegistry.ONE_UP_MUSHROOM) && lineAmt == 4) {
                    abilityText = abilityText.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.line" + lineAmt + ".hearts"), (Object[])new Object[]{Float.valueOf(((Double)ConfigRegistry.ONE_UP_HEALTH_HEALED.get()).floatValue() / 2.0f)}).withStyle(ChatFormatting.GREEN));
                }
                if (stack.is(ItemRegistry.SUPER_MUSHROOM) && lineAmt == 2) {
                    abilityText = abilityText.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.line" + lineAmt + ".hearts"), (Object[])new Object[]{Float.valueOf(((Double)ConfigRegistry.SUPER_MUSHROOM_HEALTH_HEALED.get()).floatValue())}).withStyle(ChatFormatting.RED));
                }
                if (stack.is(ItemRegistry.SUPER_STAR) && lineAmt == 2) {
                    abilityText = abilityText.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.line" + lineAmt + ".instakill"), (Object[])new Object[]{Float.valueOf((float)Math.round((float)((Integer)ConfigRegistry.SUPER_STAR_DURATION.get()).intValue() / 20.0f * 10.0f) / 10.0f)}).withStyle(ChatFormatting.GRAY));
                }
                if (stack.is(ItemRegistry.SUPER_STAR) && lineAmt == 3) {
                    abilityText = abilityText.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.line" + lineAmt + ".speed"), (Object[])new Object[]{Float.valueOf((float)Math.round((float)((Integer)ConfigRegistry.SUPER_STAR_SPEED_DURATION.get()).intValue() / 20.0f * 10.0f) / 10.0f)})).withStyle(ChatFormatting.GRAY);
                }
                list.add((Component)abilityText);
            }
            list.add((Component)Component.literal((String)""));
        } else if (this.tooltipLineAmt > 0) {
            list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip")));
        }
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockEntity entityType;
        Level world = context.getLevel();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockState state = world.getBlockState(pos);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof Spawner) {
            Spawner spawner = (Spawner)blockEntity;
            if (context.getPlayer() != null && context.getPlayer().isCreative() && !context.getPlayer().isShiftKeyDown()) {
                entityType = this.getType(stack);
                spawner.setEntityId((EntityType)entityType, world.getRandom());
                world.sendBlockUpdated(pos, state, state, 3);
                world.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.BLOCK_CHANGE, pos);
                stack.shrink(1);
                return InteractionResult.CONSUME;
            }
        }
        if ((entityType = world.getBlockEntity(pos)) instanceof Spawner) {
            Spawner spawner = (Spawner)entityType;
            if (context.getPlayer() == null) {
                entityType = this.getType(stack);
                spawner.setEntityId((EntityType)entityType, world.getRandom());
                world.sendBlockUpdated(pos, state, state, 3);
                world.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.BLOCK_CHANGE, pos);
                stack.shrink(1);
                return InteractionResult.CONSUME;
            }
        }
        BlockPos pos1 = state.getCollisionShape((BlockGetter)world, pos).isEmpty() ? pos : pos.relative(direction);
        EntityType entitytype = this.getType(stack);
        if (entitytype.spawn((ServerLevel)world, stack, context.getPlayer(), pos1, MobSpawnType.SPAWN_EGG, true, !Objects.equals(pos, pos1) && direction == Direction.UP) != null) {
            stack.shrink(1);
            world.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, pos);
        }
        return InteractionResult.CONSUME;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult blockhitresult = BasePowerUpItem.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockhitresult.getType() != HitResult.Type.BLOCK) {
            ItemStack stack = player.getItemInHand(hand);
            FoodProperties foodproperties = stack.getFoodProperties((LivingEntity)player);
            if (foodproperties != null) {
                if (player.canEat(foodproperties.canAlwaysEat())) {
                    player.startUsingItem(hand);
                    return InteractionResultHolder.consume((Object)stack);
                }
                return InteractionResultHolder.fail((Object)stack);
            }
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        if (!(world instanceof ServerLevel)) {
            return InteractionResultHolder.success((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.getBlockPos();
        if (!(world.getBlockState(blockpos).getBlock() instanceof LiquidBlock)) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (world.mayInteract(player, blockpos) && player.mayUseItemAt(blockpos, blockhitresult.getDirection(), itemstack)) {
            EntityType entitytype = this.getType(itemstack);
            Entity entity = entitytype.spawn((ServerLevel)world, itemstack, player, blockpos, MobSpawnType.SPAWN_EGG, false, false);
            if (entity == null) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            itemstack.consume(1, (LivingEntity)player);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            world.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, entity.position());
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }
}

