/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.items;

import com.wenxin2.marioverse.entities.PiranhaPlantEntity;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;

public class BetterSpawnEggItem
extends DeferredSpawnEggItem {
    int tooltipLineAmt = 0;

    public BetterSpawnEggItem(Supplier<? extends EntityType<? extends Mob>> entityType, int primaryColor, int secondaryColor, Item.Properties properties) {
        super(entityType, primaryColor, secondaryColor, properties);
    }

    public BetterSpawnEggItem(int tooltipLineAmt, Supplier<? extends EntityType<? extends Mob>> entityType, int primaryColor, int secondaryColor, Item.Properties properties) {
        super(entityType, primaryColor, secondaryColor, properties);
        this.tooltipLineAmt = tooltipLineAmt;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltip) {
        if (Screen.hasShiftDown() && this.tooltipLineAmt > 0) {
            list.add((Component)Component.literal((String)""));
            for (int lineAmt = 1; lineAmt <= this.tooltipLineAmt; ++lineAmt) {
                list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.line" + lineAmt)));
            }
            list.add((Component)Component.literal((String)""));
        } else if (this.tooltipLineAmt > 0) {
            list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip")));
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        EntityType entityType;
        BlockEntity entityType1;
        Level world = context.getLevel();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockState state = world.getBlockState(pos);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof Spawner) {
            Spawner spawner = (Spawner)blockEntity;
            if (context.getPlayer() != null && !context.getPlayer().isShiftKeyDown()) {
                entityType1 = this.getType(stack);
                spawner.setEntityId((EntityType)entityType1, world.getRandom());
                world.sendBlockUpdated(pos, state, state, 3);
                world.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.BLOCK_CHANGE, pos);
                stack.shrink(1);
                return InteractionResult.CONSUME;
            }
        }
        if ((entityType1 = world.getBlockEntity(pos)) instanceof Spawner) {
            Spawner spawner = (Spawner)entityType1;
            if (context.getPlayer() == null) {
                entityType = this.getType(stack);
                spawner.setEntityId(entityType, world.getRandom());
                world.sendBlockUpdated(pos, state, state, 3);
                world.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.BLOCK_CHANGE, pos);
                stack.shrink(1);
                return InteractionResult.CONSUME;
            }
        }
        entityType = this.getType(stack);
        BlockPos spawnPos = pos.relative(context.getClickedFace());
        Entity entity = entityType.spawn((ServerLevel)world, stack, context.getPlayer(), spawnPos, MobSpawnType.SPAWN_EGG, true, direction == Direction.UP);
        if (entity != null) {
            stack.shrink(1);
            world.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, pos);
            if (entity instanceof PiranhaPlantEntity) {
                PiranhaPlantEntity piranhaPlant = (PiranhaPlantEntity)entity;
                BlockPos newPos = piranhaPlant.findValidBlockPos();
                piranhaPlant.attachToBlock(newPos, context.getClickedFace().getOpposite());
            }
        }
        return InteractionResult.CONSUME;
    }
}

