/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.items;

import com.wenxin2.marioverse.entities.projectiles.LargeSnowballProjectile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class LargeSnowballItem
extends Item
implements ProjectileItem {
    public LargeSnowballItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        HitResult hit = player.pick(5.0, 0.0f, false);
        if (hit.getType() == HitResult.Type.BLOCK && player.isShiftKeyDown()) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (!world.isClientSide) {
            LargeSnowballProjectile snowball = new LargeSnowballProjectile(world, (LivingEntity)player);
            snowball.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 0.5f, 1.0f);
            world.addFreshEntity((Entity)snowball);
        }
        world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        stack.consume(1, (LivingEntity)player);
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos().relative(context.getClickedFace());
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        if (player != null && player.isShiftKeyDown()) {
            world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            stack.consume(1, (LivingEntity)player);
            if (!world.isClientSide) {
                LargeSnowballProjectile snowball = new LargeSnowballProjectile(world, (LivingEntity)player);
                snowball.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
                world.addFreshEntity((Entity)snowball);
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(context);
    }

    public Projectile asProjectile(Level world, Position position, ItemStack stack, Direction direction) {
        return new LargeSnowballProjectile(world, position.x(), position.y(), position.z());
    }
}

