/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.items;

import com.wenxin2.marioverse.registries.ItemRegistry;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class SolidPlasticBucketItem
extends SolidBucketItem
implements DispensibleContainerItem {
    int tooltipLineAmt = 0;

    public SolidPlasticBucketItem(Block block, SoundEvent soundEvent, Item.Properties properties) {
        super(block, soundEvent, properties);
    }

    public SolidPlasticBucketItem(int tooltipLineAmt, Block block, SoundEvent soundEvent, Item.Properties properties) {
        super(block, soundEvent, properties);
        this.tooltipLineAmt = tooltipLineAmt;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltip) {
        if (Screen.hasShiftDown() && this.tooltipLineAmt > 0) {
            list.add((Component)Component.literal((String)""));
            for (int lineAmt = 1; lineAmt <= this.tooltipLineAmt; ++lineAmt) {
                list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.line" + lineAmt)));
            }
            list.add((Component)Component.literal((String)""));
        } else if (this.tooltipLineAmt > 0) {
            list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip")));
        }
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        if (player != null) {
            ItemStack newStack = new ItemStack((ItemLike)ItemRegistry.PLASTIC_BUCKET.get());
            newStack.applyComponents(stack.getComponents());
            if (!player.isCreative()) {
                player.setItemInHand(context.getHand(), newStack);
            } else {
                ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)SolidPlasticBucketItem.getEmptySuccessItem(stack, player));
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            this.place(new BlockPlaceContext(context));
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public static ItemStack getEmptySuccessItem(ItemStack stack, Player player) {
        ItemStack newStack = new ItemStack((ItemLike)ItemRegistry.PLASTIC_BUCKET.get());
        newStack.applyComponents(stack.getComponents());
        return !player.hasInfiniteMaterials() ? newStack : stack;
    }
}

