/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;

public class WarpDoorBlockItem
extends BlockItem {
    private final Block source;

    public WarpDoorBlockItem(Block block, Block source, Item.Properties properties) {
        super(block, properties);
        this.source = source;
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)"block.marioverse.warp_door", (Object[])new Object[]{Component.translatable((String)this.source.getDescriptionId())});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltip) {
        ResourceLocation blockID = BuiltInRegistries.BLOCK.getKey((Object)this.source);
        Component modName = (Component)ModList.get().getModContainerById(blockID.getNamespace()).map(c -> Component.literal((String)c.getModInfo().getDisplayName())).orElse(Component.literal((String)blockID.getNamespace()));
        if (Screen.hasShiftDown()) {
            list.add((Component)Component.literal((String)""));
            list.add((Component)Component.translatable((String)"block.marioverse.warp_door.tooltip.ability"));
            list.add((Component)Component.translatable((String)"block.marioverse.warp_door.tooltip.description"));
            list.add((Component)Component.translatable((String)"block.marioverse.warp_door.tooltip.guide"));
            list.add((Component)Component.translatable((String)"block.marioverse.warp_door.tooltip.mod"));
            list.add((Component)Component.translatable((String)"block.marioverse.warp_door.tooltip.source_mod", (Object[])new Object[]{modName}).withStyle(ChatFormatting.BLUE));
            list.add((Component)Component.literal((String)""));
        } else {
            list.add((Component)Component.translatable((String)"block.marioverse.warp_door.tooltip"));
        }
    }
}

