/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.wenxin2.marioverse.registries.AttributesRegistry;
import net.minecraft.client.Camera;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.level.BlockGetter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Camera.class})
public abstract class CameraMixin {
    @Shadow
    protected abstract void move(float var1, float var2, float var3);

    @ModifyExpressionValue(method={"setup"}, at={@At(value="INVOKE", target="Lnet/neoforged/neoforge/client/ClientHooks;getDetachedCameraDistance(Lnet/minecraft/client/Camera;ZFF)F")})
    private float setup(float originalDistance, BlockGetter level, Entity entity, boolean detached, boolean thirdPersonReverse, float partialTick) {
        Entity vehicle;
        float cameraScale = 1.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            cameraScale = Math.max(cameraScale, CameraMixin.mv$getScaleFromAttributes(living));
        }
        if ((vehicle = entity.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingVehicle = (LivingEntity)vehicle;
            cameraScale = Math.max(cameraScale, CameraMixin.mv$getScaleFromAttributes(livingVehicle));
        }
        if (cameraScale <= 1.0f) {
            return originalDistance;
        }
        return originalDistance * cameraScale;
    }

    @Unique
    private static float mv$getScaleFromAttributes(LivingEntity living) {
        AttributeInstance widthScale;
        float height = 1.0f;
        float width = 1.0f;
        AttributeInstance heightScale = living.getAttribute(AttributesRegistry.HEIGHT_SCALE);
        if (heightScale != null) {
            height = (float)heightScale.getValue();
        }
        if ((widthScale = living.getAttribute(AttributesRegistry.WIDTH_SCALE)) != null) {
            width = (float)widthScale.getValue();
        }
        return Math.max(height, width);
    }
}

