/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.wenxin2.marioverse.blocks.WarpPipeBlock;
import com.wenxin2.marioverse.blocks.entities.WarpDoorBlockEntity;
import com.wenxin2.marioverse.blocks.entities.WarpTrapDoorBlockEntity;
import com.wenxin2.marioverse.entities.IceCubeEntity;
import com.wenxin2.marioverse.registries.AttributesRegistry;
import com.wenxin2.marioverse.registries.BlockRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.utils.BlockWarpEntityHandler;
import com.wenxin2.marioverse.utils.EntityWarpEntityHandler;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements BlockWarpEntityHandler,
EntityWarpEntityHandler {
    @Shadow
    protected float moveDist;
    @Shadow
    protected float nextStep;
    @Unique
    protected float mv$appliedHeightScale = 1.0f;
    @Unique
    protected float mv$appliedWidthScale = 1.0f;

    @Shadow
    protected abstract float nextStep();

    @Shadow
    protected abstract void playStepSound(BlockPos var1, BlockState var2);

    @Shadow
    public abstract BlockPos blockPosition();

    @Shadow
    public abstract EntityType<?> getType();

    @Shadow
    public abstract Level level();

    @Shadow
    public abstract double getX();

    @Shadow
    public abstract double getY();

    @Shadow
    public abstract double getZ();

    @Shadow
    public abstract float getBbHeight();

    @Shadow
    public abstract int getId();

    @Shadow
    public abstract void setPos(Vec3 var1);

    @Override
    public boolean mv$getBlockWarpTeleportConfig() {
        return (Boolean)ConfigRegistry.TELEPORT_NON_MOBS.get();
    }

    @Override
    public boolean mv$getEntityWarpTeleportConfig() {
        return (Boolean)ConfigRegistry.TELEPORT_NON_MOBS.get();
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    public void tick(CallbackInfo ci) {
        float f7;
        float f6;
        Entity entity = (Entity)this;
        Level world = entity.level();
        BlockPos pos = entity.blockPosition();
        BlockPos posAboveEntity = pos.above(Math.round(entity.getBbHeight()));
        BlockPos posInBlock = pos.above(Math.round(entity.getBbHeight()) - 1);
        BlockState state = world.getBlockState(pos);
        BlockState stateAboveEntity = world.getBlockState(posAboveEntity);
        BlockState stateInBlock = world.getBlockState(posInBlock);
        if (this.moveDist > this.nextStep && ((Boolean)entity.getData(DataAttachmentRegistry.HAS_MINI_MUSHROOM)).booleanValue() && (entity.isSprinting() || entity.getDeltaMovement().horizontalDistance() >= 0.25) && world.getFluidState(pos).is(FluidTags.WATER) && !world.getFluidState(pos.above()).is(FluidTags.WATER)) {
            this.playStepSound(pos, state);
            this.nextStep = this.nextStep();
        }
        EntityMixin.mv$rideIceCube(entity);
        for (Direction facing : Direction.values()) {
            BlockPos offsetPos = pos.relative(facing);
            BlockState offsetState = world.getBlockState(offsetPos);
            if (((Boolean)entity.getData(DataAttachmentRegistry.PREVENT_WARP)).booleanValue() && !(entity instanceof Player)) continue;
            if (offsetState.getBlock() instanceof WarpPipeBlock && !((Boolean)offsetState.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue()) {
                this.enterWarp(entity, world, offsetPos);
            }
            if (!(state.getBlock() instanceof WarpPipeBlock) || ((Boolean)state.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue()) continue;
            this.enterWarp(entity, world, pos);
        }
        if (stateAboveEntity.getBlock() instanceof WarpPipeBlock && !((Boolean)stateAboveEntity.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() && !((Boolean)entity.getData(DataAttachmentRegistry.PREVENT_WARP)).booleanValue()) {
            this.enterWarp(entity, world, pos);
        }
        if (!((Boolean)ConfigRegistry.DISABLE_WARP_DOORS.get()).booleanValue() && world.getBlockEntity(pos) instanceof WarpDoorBlockEntity && state.getBlock() instanceof DoorBlock && ((Boolean)state.getValue((Property)DoorBlock.OPEN)).booleanValue() && state.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.LOWER && !((Boolean)entity.getData(DataAttachmentRegistry.PREVENT_WARP)).booleanValue()) {
            this.enterWarp(entity, world, pos);
        }
        if (!((Boolean)ConfigRegistry.DISABLE_WARP_TRAPDOORS.get()).booleanValue() && world.getBlockEntity(pos) instanceof WarpTrapDoorBlockEntity && state.getBlock() instanceof TrapDoorBlock && ((Boolean)state.getValue((Property)TrapDoorBlock.OPEN)).booleanValue() && !((Boolean)entity.getData(DataAttachmentRegistry.PREVENT_WARP)).booleanValue()) {
            this.enterWarp(entity, world, pos);
        }
        if (!((Boolean)ConfigRegistry.DISABLE_WARP_TRAPDOORS.get()).booleanValue() && world.getBlockEntity(posInBlock) instanceof WarpTrapDoorBlockEntity && stateInBlock.getBlock() instanceof TrapDoorBlock && ((Boolean)stateInBlock.getValue((Property)TrapDoorBlock.OPEN)).booleanValue() && !((Boolean)entity.getData(DataAttachmentRegistry.PREVENT_WARP)).booleanValue()) {
            this.enterWarp(entity, world, posInBlock);
        }
        if (!((Boolean)ConfigRegistry.DISABLE_WARP_PAINTINGS.get()).booleanValue() && !((Boolean)entity.getData(DataAttachmentRegistry.PREVENT_WARP)).booleanValue()) {
            this.enterWarp(entity, world);
        }
        if ((f6 = this.mv$getHeightScale()) != this.mv$appliedHeightScale) {
            this.mv$appliedHeightScale = f6;
            entity.refreshDimensions();
        }
        if ((f7 = this.mv$getWidthScale()) != this.mv$appliedWidthScale) {
            this.mv$appliedWidthScale = f6;
            entity.refreshDimensions();
        }
    }

    @Inject(method={"playStepSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void playStepSound(BlockPos pos, BlockState state, CallbackInfo ci) {
        Entity entity = (Entity)this;
        Level level = entity.level();
        BlockPos posEntity = entity.blockPosition();
        if (((Boolean)entity.getData(DataAttachmentRegistry.HAS_MINI_MUSHROOM)).booleanValue() && (entity.isSprinting() || entity.getDeltaMovement().horizontalDistance() >= 0.25) && level.getFluidState(posEntity).is(FluidTags.WATER) && !level.getFluidState(posEntity.above()).is(FluidTags.WATER)) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ServerParticleUtils.spawnParticleTrail((ParticleOptions)ParticleTypes.SPLASH, serverLevel, entity, false, true, 5, 0.1);
            }
            entity.playSound((SoundEvent)SoundRegistry.WATER_MINI_STEP.get(), 1.0f, 1.0f + (entity.getRandom().nextFloat() - 0.5f) * 0.2f);
            ci.cancel();
        }
    }

    @ModifyReturnValue(method={"isInWaterOrBubble"}, at={@At(value="RETURN")})
    private boolean isInWaterOrBubble(boolean original) {
        BlockState state = this.level().getBlockState(this.blockPosition());
        if (!original && state.is((Block)BlockRegistry.PIPE_BUBBLES.get())) {
            return true;
        }
        return original;
    }

    @ModifyReturnValue(method={"isInWaterRainOrBubble"}, at={@At(value="RETURN")})
    private boolean isInWaterRainOrBubble(boolean original) {
        BlockState state = this.level().getBlockState(this.blockPosition());
        if (!original && state.is((Block)BlockRegistry.PIPE_BUBBLES.get())) {
            return true;
        }
        return original;
    }

    @Inject(method={"handleEntityEvent"}, at={@At(value="HEAD")})
    private void handleEntityEvent(byte id, CallbackInfo ci) {
        Entity entity = (Entity)this;
        RandomSource random = entity.getRandom();
        if (id == 120) {
            for (int i = 0; i < 100; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.ENCHANT, entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), (random.nextDouble() - 0.5) * 2.0, -random.nextDouble(), (random.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    @ModifyReturnValue(method={"getEyeHeight(Lnet/minecraft/world/entity/Pose;)F"}, at={@At(value="TAIL")})
    private float getEyeHeight(float original, Pose pose) {
        float eyeScale = this.mv$getEyeHeightScale();
        return original * eyeScale;
    }

    @Inject(method={"getBbHeight"}, at={@At(value="HEAD")}, cancellable=true)
    private void getBbHeight(CallbackInfoReturnable<Float> cir) {
        LivingEntity livingEntity;
        AttributeMap attributeMap;
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity && (attributeMap = (livingEntity = (LivingEntity)entity).getAttributes()) != null) {
            float height = entity.getDimensions(entity.getPose()).height();
            cir.setReturnValue((Object)Float.valueOf(height));
        }
    }

    @Inject(method={"getBbWidth"}, at={@At(value="HEAD")}, cancellable=true)
    private void getBbWidth(CallbackInfoReturnable<Float> cir) {
        LivingEntity livingEntity;
        AttributeMap attributeMap;
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity && (attributeMap = (livingEntity = (LivingEntity)entity).getAttributes()) != null) {
            float width = entity.getDimensions(entity.getPose()).width();
            cir.setReturnValue((Object)Float.valueOf(width));
        }
    }

    @Unique
    public float mv$getEyeHeightScale() {
        Entity entity = (Entity)this;
        if (!(entity instanceof LivingEntity)) {
            return 1.0f;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        AttributeMap attributemap = livingEntity.getAttributes();
        return attributemap == null ? 1.0f : this.mv$sanitizeScales((float)attributemap.getValue(AttributesRegistry.EYE_HEIGHT_SCALE));
    }

    @Unique
    private static void mv$rideIceCube(Entity entity) {
        IceCubeEntity iceCube;
        Vec3 iceMovement;
        Entity belowEntity = null;
        for (Entity e : entity.level().getEntities(entity, entity.getBoundingBox().move(0.0, -1.0, 0.0))) {
            if (!(e instanceof IceCubeEntity)) continue;
            belowEntity = e;
            break;
        }
        if (belowEntity instanceof IceCubeEntity && !(iceMovement = (iceCube = (IceCubeEntity)belowEntity).getDeltaMovement()).equals((Object)Vec3.ZERO)) {
            entity.setDeltaMovement(iceMovement.x, 0.0, iceMovement.z);
            entity.move(MoverType.SELF, iceMovement);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.getNavigation().stop();
            }
        }
    }

    @Unique
    public float mv$getHeightScale() {
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            AttributeMap attributeMap = livingEntity.getAttributes();
            return attributeMap == null ? 1.0f : this.mv$sanitizeScales((float)attributeMap.getValue(AttributesRegistry.HEIGHT_SCALE));
        }
        return 1.0f;
    }

    @Unique
    public float mv$getWidthScale() {
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            AttributeMap attributeMap = livingEntity.getAttributes();
            return attributeMap == null ? 1.0f : this.mv$sanitizeScales((float)attributeMap.getValue(AttributesRegistry.WIDTH_SCALE));
        }
        return 1.0f;
    }

    @Unique
    public float mv$sanitizeScales(float scale) {
        return scale;
    }
}

