/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.mixin;

import com.wenxin2.marioverse.registries.AttributesRegistry;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

@Mixin(value={EntityRenderer.class})
public abstract class EntityRendererMixin<T extends Entity> {
    @Shadow
    protected float shadowRadius;
    @Unique
    private float mv$baseShadowRadius = -1.0f;

    @Inject(method={"getShadowRadius(Lnet/minecraft/world/entity/Entity;)F"}, at={@At(value="RETURN")}, cancellable=true)
    public void getShadowRadius(T entity, CallbackInfoReturnable<Float> cir) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            AttributeMap attributemap = livingEntity.getAttributes();
            float widthScale = (float)attributemap.getValue(AttributesRegistry.WIDTH_SCALE);
            if (this.mv$baseShadowRadius < 0.0f) {
                this.mv$baseShadowRadius = this.shadowRadius;
            }
            if ((double)widthScale >= 1.5) {
                cir.setReturnValue((Object)Float.valueOf(((Float)cir.getReturnValue()).floatValue() * widthScale / 2.25f));
            }
            if (this instanceof GeoEntityRenderer) {
                this.shadowRadius = this.mv$baseShadowRadius * widthScale;
            }
        }
    }
}

