/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.mixin;

import com.wenxin2.marioverse.registries.AttributesRegistry;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={InventoryScreen.class})
public abstract class InventoryScreenMixin {
    @ModifyArgs(method={"renderEntityInInventory"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;scale(FFF)V"))
    private static void renderEntityInInventory(Args args, GuiGraphics graphics, float x, float y, float baseScale, Vector3f translation, Quaternionf rotation, @Nullable Quaternionf cameraRotation, LivingEntity entity) {
        float entityScale = InventoryScreenMixin.mv$getScaleFromAttributes(entity);
        float zoom = 1.0f / entityScale;
        args.set(0, (Object)Float.valueOf(((Float)args.get(0)).floatValue() * zoom));
        args.set(1, (Object)Float.valueOf(((Float)args.get(1)).floatValue() * zoom));
        args.set(2, (Object)Float.valueOf(((Float)args.get(2)).floatValue() * zoom));
    }

    @Unique
    private static float mv$getScaleFromAttributes(LivingEntity living) {
        AttributeInstance widthScale;
        float height = 1.0f;
        float width = 1.0f;
        AttributeInstance heightScale = living.getAttribute(AttributesRegistry.HEIGHT_SCALE);
        if (heightScale != null) {
            height = (float)heightScale.getValue();
        }
        if ((widthScale = living.getAttribute(AttributesRegistry.WIDTH_SCALE)) != null) {
            width = (float)widthScale.getValue();
        }
        return Math.max(height, width);
    }
}

