/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.wenxin2.marioverse.Marioverse;
import com.wenxin2.marioverse.blocks.QuestionBlock;
import com.wenxin2.marioverse.blocks.QuicksandBlock;
import com.wenxin2.marioverse.blocks.entities.QuestionBlockEntity;
import com.wenxin2.marioverse.entities.KoopaShellEntity;
import com.wenxin2.marioverse.entities.KoopaTroopaEntity;
import com.wenxin2.marioverse.entities.power_ups.OneUpMushroomEntity;
import com.wenxin2.marioverse.items.OneUpMushroomItem;
import com.wenxin2.marioverse.network.client_bound.data.OneUpPayload;
import com.wenxin2.marioverse.registries.AttributesRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DamageSourceRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import com.wenxin2.marioverse.utils.BlockWarpEntityHandler;
import com.wenxin2.marioverse.utils.EntityWarpEntityHandler;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.data.SlotTypeLoader;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements BlockWarpEntityHandler,
EntityWarpEntityHandler,
AbilitiesHandler {
    @Shadow
    protected boolean jumping;
    @Unique
    private static final int MAX_PARTICLE_AMOUNT = 100;
    @Unique
    protected float mv$appliedEyeHeightScale = 1.0f;
    @Unique
    protected float mv$appliedHeightScale = 1.0f;
    @Unique
    protected float mv$appliedWidthScale = 1.0f;

    @Shadow
    public abstract void setSpeed(float var1);

    @Shadow
    public abstract void handleEntityEvent(byte var1);

    public LivingEntityMixin(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public boolean mv$getBlockWarpTeleportConfig() {
        return (Boolean)ConfigRegistry.TELEPORT_MOBS.get();
    }

    @Override
    public boolean mv$getEntityWarpTeleportConfig() {
        return (Boolean)ConfigRegistry.TELEPORT_MOBS.get();
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (tag.contains("marioverse:has_fire_flower")) {
            entity.getPersistentData().putBoolean("marioverse:has_fire_flower", tag.getBoolean("marioverse:has_fire_flower"));
        }
        if (tag.contains("marioverse:has_ice_flower")) {
            entity.getPersistentData().putBoolean("marioverse:has_ice_flower", tag.getBoolean("marioverse:has_ice_flower"));
        }
        if (tag.contains("marioverse:has_super_mushroom")) {
            entity.getPersistentData().putBoolean("marioverse:has_super_mushroom", tag.getBoolean("marioverse:has_super_mushroom"));
        }
        if (tag.contains("marioverse:has_super_mushroom_override")) {
            entity.getPersistentData().putBoolean("marioverse:has_super_mushroom_override", tag.getBoolean("marioverse:has_super_mushroom_override"));
        }
        if (tag.contains("marioverse:prevent_warp")) {
            entity.getPersistentData().putBoolean("marioverse:prevent_warp", tag.getBoolean("marioverse:prevent_warp"));
        }
        if (tag.contains("marioverse:warp_cooldown")) {
            entity.getPersistentData().putInt("marioverse:warp_cooldown", tag.getInt("marioverse:warp_cooldown"));
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        float f7;
        float f6;
        float f5;
        Player player;
        Player player2;
        LivingEntity entity = (LivingEntity)this;
        Level world = entity.level();
        BlockPos pos = entity.blockPosition();
        BlockPos posAboveEntity = pos.above(Math.round(entity.getBbHeight()));
        BlockPos posNorth = pos.north(Math.round(this.getBbWidth() + 0.1f));
        BlockPos posSouth = pos.south(Math.round(this.getBbWidth() + 0.1f));
        BlockPos posEast = pos.east(Math.round(this.getBbWidth() + 0.1f));
        BlockPos posWest = pos.west(Math.round(this.getBbWidth() + 0.1f));
        BlockState stateAboveEntity = world.getBlockState(posAboveEntity);
        BlockState stateNorth = world.getBlockState(posNorth);
        BlockState stateSouth = world.getBlockState(posSouth);
        BlockState stateEast = world.getBlockState(posEast);
        BlockState stateWest = world.getBlockState(posWest);
        RandomSource rand = RandomSource.create();
        this.mv$characterAbilities(entity);
        if (((Boolean)ConfigRegistry.ENABLE_STOMPABLE_ENEMIES.get()).booleanValue() && (entity.getType().is(TagRegistry.CAN_STOMP_ENEMIES) || ((Boolean)ConfigRegistry.ALL_MOBS_CAN_STOMP.get()).booleanValue() || world.getGameRules().getBoolean(Marioverse.ALL_MOBS_CAN_STOMP)) && (entity.fallDistance > 0.0f || entity.isInWaterOrBubble()) && !(entity instanceof Player) && !entity.isSpectator()) {
            this.mv$squashEntity(entity);
        }
        if (stateAboveEntity.is(TagRegistry.SMASHABLE_BLOCKS) && entity.getType().is(TagRegistry.CAN_SMASH_BLOCKS) && (EventHooks.canEntityGrief((Level)world, (Entity)entity) || entity instanceof Player && !(player2 = (Player)entity).mayFly()) && !entity.onGround() && entity.getY() > entity.yOld && !entity.isSpectator() && !world.isClientSide && !((Boolean)entity.getData(DataAttachmentRegistry.HAS_HIT_BLOCK.get())).booleanValue()) {
            this.mv$smashBlock(world, posAboveEntity, stateAboveEntity, (Entity)entity);
        }
        if ((EventHooks.canEntityGrief((Level)world, (Entity)entity) || entity instanceof Player) && !world.isClientSide) {
            this.mv$shellSmashBlock(stateNorth, entity, world, posNorth, stateSouth, posSouth, stateEast, posEast, stateWest, posWest);
        }
        if (stateAboveEntity.is(TagRegistry.BONKABLE_BLOCKS) && entity.getType().is(TagRegistry.CAN_BONK_BLOCKS) && !entity.onGround() && entity.getY() > entity.yOld && !entity.isSpectator() && !world.isClientSide) {
            if (stateAboveEntity.hasProperty((Property)QuestionBlock.EMPTY) && ((Boolean)stateAboveEntity.getValue((Property)QuestionBlock.EMPTY)).booleanValue()) {
                world.playSound(null, posAboveEntity, (SoundEvent)SoundRegistry.BLOCK_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                world.playSound(null, posAboveEntity, (SoundEvent)SoundRegistry.BLOCK_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        this.mv$shellBonkBlock(stateNorth, entity, world, posNorth, stateSouth, posSouth, stateEast, posEast, stateWest, posWest);
        BlockEntity blockEntity = world.getBlockEntity(posAboveEntity);
        if (blockEntity instanceof QuestionBlockEntity) {
            QuestionBlockEntity questionBlockEntity = (QuestionBlockEntity)blockEntity;
            if (entity.getType().is(TagRegistry.CAN_HIT_QUESTION_BLOCKS) && (EventHooks.canEntityGrief((Level)world, (Entity)entity) || entity instanceof Player && !(player = (Player)entity).mayFly()) && !entity.onGround() && entity.getY() > entity.yOld && !entity.isSpectator() && !world.isClientSide && !((Boolean)entity.getData(DataAttachmentRegistry.HAS_HIT_BLOCK.get())).booleanValue()) {
                this.mv$hitQuestionBlock(world, posAboveEntity, (Entity)entity, questionBlockEntity);
            }
        }
        if ((EventHooks.canEntityGrief((Level)world, (Entity)entity) || entity instanceof Player) && !world.isClientSide) {
            this.mv$shellHitQuestionBlock(world, posNorth, entity, posSouth, posEast, posWest);
        }
        if (((Boolean)entity.getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue()) {
            this.mv$superStarKillEntity(entity);
            if (!entity.isInvisible()) {
                player = this.level();
                if (player instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)player;
                    ServerParticleUtils.spawnSingleParticleOnEntityRandomly((ParticleOptions)ParticleRegistry.RAINBOW_GLINT.get(), serverWorld, (Entity)entity);
                }
                ServerParticleUtils.spawnClientParticleTrail((ParticleOptions)ParticleRegistry.RAINBOW_GLINT.get(), (Entity)entity, true, 10, rand.nextDouble() * (double)entity.getBbHeight(), 0.1);
            }
        }
        if (((Boolean)entity.getData(DataAttachmentRegistry.HAS_DASH_MUSHROOM_BOOST)).booleanValue()) {
            this.mv$boostEntityParticles(entity.getVehicle(), entity);
        }
        if ((f5 = this.mv$getEyeHeightScale()) != this.mv$appliedEyeHeightScale) {
            this.mv$appliedEyeHeightScale = f5;
            entity.refreshDimensions();
        }
        if ((f6 = this.mv$getHeightScale()) != this.mv$appliedHeightScale) {
            this.mv$appliedHeightScale = f6;
            entity.refreshDimensions();
        }
        if ((f7 = this.mv$getWidthScale()) != this.mv$appliedWidthScale) {
            this.mv$appliedWidthScale = f6;
            entity.refreshDimensions();
        }
    }

    @Unique
    private void mv$boostEntityParticles(Entity vehicle, LivingEntity entity) {
        double speed = this.getDeltaMovement().horizontalDistance();
        double minimumBoostSpeed = 0.3;
        if (vehicle != null) {
            ServerLevel serverWorld;
            Level level;
            speed = vehicle.getDeltaMovement().horizontalDistance();
            if (vehicle instanceof Boat && speed > 0.0) {
                level = vehicle.level();
                if (level instanceof ServerLevel) {
                    serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnSingleParticleOnEntityRandomly((ParticleOptions)ParticleRegistry.POWERED_UP.get(), serverWorld, vehicle);
                    ServerParticleUtils.spawnParticleTrail((ParticleOptions)ParticleRegistry.SUSPENDED_FIRE.get(), serverWorld, vehicle, true, false, 10, 0.1);
                }
                if (vehicle.level().isClientSide) {
                    ServerParticleUtils.spawnClientParticleTrail((ParticleOptions)ParticleRegistry.POWERED_UP.get(), vehicle, true, 5, 0.1, 0.0);
                    ServerParticleUtils.spawnClientParticleTrail((ParticleOptions)ParticleRegistry.SUSPENDED_FIRE.get(), vehicle, true, 10, 0.1, 0.0);
                }
            }
            if (speed >= minimumBoostSpeed) {
                if (vehicle.level().isClientSide) {
                    ServerParticleUtils.spawnClientParticleTrail((ParticleOptions)ParticleRegistry.POWERED_UP.get(), vehicle, true, 5, 0.1, 0.0);
                    ServerParticleUtils.spawnClientParticleTrail((ParticleOptions)ParticleRegistry.SUSPENDED_FIRE.get(), vehicle, true, 10, 0.1, 0.0);
                } else {
                    level = vehicle.level();
                    if (level instanceof ServerLevel) {
                        serverWorld = (ServerLevel)level;
                        if (!(entity instanceof Player)) {
                            ServerParticleUtils.spawnSingleParticleOnEntityRandomly((ParticleOptions)ParticleRegistry.POWERED_UP.get(), serverWorld, vehicle);
                            ServerParticleUtils.spawnParticleTrail((ParticleOptions)ParticleRegistry.SUSPENDED_FIRE.get(), serverWorld, vehicle, true, false, 10, 0.1);
                        }
                    }
                }
            } else {
                entity.setData(DataAttachmentRegistry.HAS_DASH_MUSHROOM_BOOST, (Object)false);
            }
        } else if (speed >= minimumBoostSpeed) {
            if (entity.level().isClientSide) {
                ServerParticleUtils.spawnClientParticleTrail((ParticleOptions)ParticleRegistry.POWERED_UP.get(), (Entity)entity, true, 5, 0.1, 0.0);
                ServerParticleUtils.spawnClientParticleTrail((ParticleOptions)ParticleRegistry.SUSPENDED_FIRE.get(), (Entity)entity, true, 10, 0.1, 0.0);
            } else {
                Level level = entity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnSingleParticleOnEntityRandomly((ParticleOptions)ParticleRegistry.POWERED_UP.get(), serverWorld, (Entity)entity);
                    ServerParticleUtils.spawnParticleTrail((ParticleOptions)ParticleRegistry.SUSPENDED_FIRE.get(), serverWorld, (Entity)entity, true, false, 10, 0.1);
                }
            }
        } else {
            entity.setData(DataAttachmentRegistry.HAS_DASH_MUSHROOM_BOOST, (Object)false);
        }
    }

    @Unique
    private void mv$shellSmashBlock(BlockState stateNorth, LivingEntity entity, Level world, BlockPos posNorth, BlockState stateSouth, BlockPos posSouth, BlockState stateEast, BlockPos posEast, BlockState stateWest, BlockPos posWest) {
        KoopaShellEntity shell;
        if ((stateNorth.is(TagRegistry.SMASHABLE_BLOCKS) || stateNorth.getBlock() instanceof DecoratedPotBlock) && entity.getType().is(TagRegistry.CAN_SMASH_BLOCKS) && entity instanceof KoopaShellEntity) {
            shell = (KoopaShellEntity)entity;
            if (entity.getDeltaMovement().horizontalDistance() > 0.1 && !((Boolean)entity.getData(DataAttachmentRegistry.HAS_HIT_BLOCK.get())).booleanValue()) {
                this.mv$smashBlock(world, posNorth, stateNorth, (Entity)entity);
                shell.bounceShell(world, Direction.NORTH);
            }
        }
        if ((stateSouth.is(TagRegistry.SMASHABLE_BLOCKS) || stateSouth.getBlock() instanceof DecoratedPotBlock) && entity.getType().is(TagRegistry.CAN_SMASH_BLOCKS) && entity instanceof KoopaShellEntity) {
            shell = (KoopaShellEntity)entity;
            if (entity.getDeltaMovement().horizontalDistance() > 0.1 && !((Boolean)entity.getData(DataAttachmentRegistry.HAS_HIT_BLOCK.get())).booleanValue()) {
                this.mv$smashBlock(world, posSouth, stateSouth, (Entity)entity);
                shell.bounceShell(world, Direction.SOUTH);
            }
        }
        if ((stateEast.is(TagRegistry.SMASHABLE_BLOCKS) || stateEast.getBlock() instanceof DecoratedPotBlock) && entity.getType().is(TagRegistry.CAN_SMASH_BLOCKS) && entity instanceof KoopaShellEntity) {
            shell = (KoopaShellEntity)entity;
            if (entity.getDeltaMovement().horizontalDistance() > 0.1 && !((Boolean)entity.getData(DataAttachmentRegistry.HAS_HIT_BLOCK.get())).booleanValue()) {
                this.mv$smashBlock(world, posEast, stateEast, (Entity)entity);
                shell.bounceShell(world, Direction.EAST);
            }
        }
        if ((stateWest.is(TagRegistry.SMASHABLE_BLOCKS) || stateWest.getBlock() instanceof DecoratedPotBlock) && entity.getType().is(TagRegistry.CAN_SMASH_BLOCKS) && entity instanceof KoopaShellEntity) {
            shell = (KoopaShellEntity)entity;
            if (entity.getDeltaMovement().horizontalDistance() > 0.1 && !((Boolean)entity.getData(DataAttachmentRegistry.HAS_HIT_BLOCK.get())).booleanValue()) {
                this.mv$smashBlock(world, posWest, stateWest, (Entity)entity);
                shell.bounceShell(world, Direction.WEST);
            }
        }
    }

    @Unique
    private void mv$shellBonkBlock(BlockState stateNorth, LivingEntity entity, Level world, BlockPos posNorth, BlockState stateSouth, BlockPos posSouth, BlockState stateEast, BlockPos posEast, BlockState stateWest, BlockPos posWest) {
        if (stateNorth.is(TagRegistry.BONKABLE_BLOCKS) && entity.getType().is(TagRegistry.CAN_BONK_BLOCKS) && entity instanceof KoopaShellEntity && entity.getDeltaMovement().horizontalDistance() > 0.1) {
            if (stateNorth.hasProperty((Property)QuestionBlock.EMPTY) && ((Boolean)stateNorth.getValue((Property)QuestionBlock.EMPTY)).booleanValue()) {
                world.playSound(null, posNorth, (SoundEvent)SoundRegistry.BLOCK_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                world.playSound(null, posNorth, (SoundEvent)SoundRegistry.BLOCK_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        if (stateSouth.is(TagRegistry.BONKABLE_BLOCKS) && entity.getType().is(TagRegistry.CAN_BONK_BLOCKS) && entity instanceof KoopaShellEntity && entity.getDeltaMovement().horizontalDistance() > 0.1) {
            if (stateSouth.hasProperty((Property)QuestionBlock.EMPTY) && ((Boolean)stateSouth.getValue((Property)QuestionBlock.EMPTY)).booleanValue()) {
                world.playSound(null, posSouth, (SoundEvent)SoundRegistry.BLOCK_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                world.playSound(null, posSouth, (SoundEvent)SoundRegistry.BLOCK_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        if (stateEast.is(TagRegistry.BONKABLE_BLOCKS) && entity.getType().is(TagRegistry.CAN_BONK_BLOCKS) && entity instanceof KoopaShellEntity && entity.getDeltaMovement().horizontalDistance() > 0.1) {
            if (stateEast.hasProperty((Property)QuestionBlock.EMPTY) && ((Boolean)stateEast.getValue((Property)QuestionBlock.EMPTY)).booleanValue()) {
                world.playSound(null, posEast, (SoundEvent)SoundRegistry.BLOCK_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                world.playSound(null, posEast, (SoundEvent)SoundRegistry.BLOCK_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        if (stateWest.is(TagRegistry.BONKABLE_BLOCKS) && entity.getType().is(TagRegistry.CAN_BONK_BLOCKS) && entity instanceof KoopaShellEntity && entity.getDeltaMovement().horizontalDistance() > 0.1) {
            if (stateWest.hasProperty((Property)QuestionBlock.EMPTY) && ((Boolean)stateWest.getValue((Property)QuestionBlock.EMPTY)).booleanValue()) {
                world.playSound(null, posWest, (SoundEvent)SoundRegistry.BLOCK_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                world.playSound(null, posWest, (SoundEvent)SoundRegistry.BLOCK_BONK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    @Unique
    private void mv$shellHitQuestionBlock(Level world, BlockPos posNorth, LivingEntity entity, BlockPos posSouth, BlockPos posEast, BlockPos posWest) {
        QuestionBlockEntity questionBlockEntity;
        BlockEntity blockEntity = world.getBlockEntity(posNorth);
        if (blockEntity instanceof QuestionBlockEntity) {
            questionBlockEntity = (QuestionBlockEntity)blockEntity;
            if (entity instanceof KoopaShellEntity && entity.getType().is(TagRegistry.CAN_HIT_QUESTION_BLOCKS) && entity.getDeltaMovement().horizontalDistance() > 0.1) {
                this.mv$hitQuestionBlock(world, posNorth, (Entity)entity, questionBlockEntity);
            }
        }
        if ((blockEntity = world.getBlockEntity(posSouth)) instanceof QuestionBlockEntity) {
            questionBlockEntity = (QuestionBlockEntity)blockEntity;
            if (entity instanceof KoopaShellEntity && entity.getType().is(TagRegistry.CAN_HIT_QUESTION_BLOCKS) && entity.getDeltaMovement().horizontalDistance() > 0.1) {
                this.mv$hitQuestionBlock(world, posSouth, (Entity)entity, questionBlockEntity);
            }
        }
        if ((blockEntity = world.getBlockEntity(posEast)) instanceof QuestionBlockEntity) {
            questionBlockEntity = (QuestionBlockEntity)blockEntity;
            if (entity instanceof KoopaShellEntity && entity.getType().is(TagRegistry.CAN_HIT_QUESTION_BLOCKS) && entity.getDeltaMovement().horizontalDistance() > 0.1) {
                this.mv$hitQuestionBlock(world, posEast, (Entity)entity, questionBlockEntity);
            }
        }
        if ((blockEntity = world.getBlockEntity(posWest)) instanceof QuestionBlockEntity) {
            questionBlockEntity = (QuestionBlockEntity)blockEntity;
            if (entity instanceof KoopaShellEntity && entity.getType().is(TagRegistry.CAN_HIT_QUESTION_BLOCKS) && entity.getDeltaMovement().horizontalDistance() > 0.1) {
                this.mv$hitQuestionBlock(world, posWest, (Entity)entity, questionBlockEntity);
            }
        }
    }

    @Unique
    private void mv$characterAbilities(LivingEntity entity) {
        boolean hasCostume;
        AttributeInstance blockReachAttribute = entity.getAttribute(Attributes.BLOCK_INTERACTION_RANGE);
        AttributeInstance entityReachAttribute = entity.getAttribute(Attributes.ENTITY_INTERACTION_RANGE);
        AttributeInstance jumpAttribute = entity.getAttribute(Attributes.JUMP_STRENGTH);
        AttributeInstance safeFallAttribute = entity.getAttribute(Attributes.SAFE_FALL_DISTANCE);
        boolean isMega = (Boolean)entity.getData(DataAttachmentRegistry.HAS_MEGA_MUSHROOM);
        boolean isMini = (Boolean)entity.getData(DataAttachmentRegistry.HAS_MINI_MUSHROOM);
        Vec3 motion = entity.getDeltaMovement();
        boolean bl = hasCostume = this.mv$hasMarioCostume(entity) || this.mv$hasLuigiCostume(entity) || this.mv$hasPeachCostume(entity);
        if (jumpAttribute != null) {
            boolean isRunning = entity.isSprinting();
            double normalJumpBoost = 0.0;
            double runningJumpBoost = 0.0;
            if (hasCostume) {
                if (this.mv$hasPeachCostume(entity)) {
                    normalJumpBoost = 0.3;
                    runningJumpBoost = 0.4;
                } else if (this.mv$hasLuigiCostume(entity)) {
                    normalJumpBoost = 0.6;
                    runningJumpBoost = 0.7;
                } else {
                    normalJumpBoost = 0.5;
                    runningJumpBoost = 0.6;
                }
            }
            if (isMega) {
                if (hasCostume) {
                    normalJumpBoost *= 0.8;
                    runningJumpBoost *= 1.0;
                } else {
                    normalJumpBoost = 0.3;
                    runningJumpBoost = 0.4;
                }
            }
            if (isMini) {
                if (hasCostume) {
                    normalJumpBoost *= 1.2;
                    runningJumpBoost *= 1.4;
                } else {
                    normalJumpBoost = 0.5;
                    runningJumpBoost = 0.6;
                }
            }
            if (!entity.isShiftKeyDown() && (hasCostume || isMini || isMega)) {
                if (isRunning) {
                    LivingEntityMixin.mv$setModifier(jumpAttribute, AttributesRegistry.RUNNING_JUMP_BOOST, runningJumpBoost);
                    LivingEntityMixin.mv$setModifier(jumpAttribute, AttributesRegistry.JUMP_BOOST, 0.0);
                } else {
                    LivingEntityMixin.mv$setModifier(jumpAttribute, AttributesRegistry.JUMP_BOOST, normalJumpBoost);
                    LivingEntityMixin.mv$setModifier(jumpAttribute, AttributesRegistry.RUNNING_JUMP_BOOST, 0.0);
                }
            } else {
                LivingEntityMixin.mv$setModifier(jumpAttribute, AttributesRegistry.JUMP_BOOST, 0.0);
                LivingEntityMixin.mv$setModifier(jumpAttribute, AttributesRegistry.RUNNING_JUMP_BOOST, 0.0);
            }
        }
        if (safeFallAttribute != null) {
            double safeFallDistance = 0.0;
            if (isMega) {
                safeFallDistance = hasCostume ? 7.0 : 4.0;
            } else if (isMini) {
                safeFallDistance = hasCostume ? 16.0 : 14.0;
            } else if (hasCostume) {
                safeFallDistance = 7.0;
            }
            if (hasCostume || isMega || isMini) {
                LivingEntityMixin.mv$setModifier(safeFallAttribute, AttributesRegistry.SAFE_FALL_DISTANCE, safeFallDistance);
            } else {
                LivingEntityMixin.mv$setModifier(safeFallAttribute, AttributesRegistry.SAFE_FALL_DISTANCE, 0.0);
            }
        }
        if (blockReachAttribute != null) {
            double reachDistance = 0.0;
            if (isMega) {
                reachDistance = (Double)ConfigRegistry.MEGA_MUSHROOM_REACH_DISTANCE.get();
            } else if (isMini) {
                reachDistance = (Double)ConfigRegistry.MINI_MUSHROOM_REACH_DISTANCE.get();
            }
            if (isMega || isMini) {
                LivingEntityMixin.mv$setModifier(blockReachAttribute, AttributesRegistry.BLOCK_REACH_DISTANCE, reachDistance);
            } else {
                LivingEntityMixin.mv$setModifier(blockReachAttribute, AttributesRegistry.BLOCK_REACH_DISTANCE, 0.0);
            }
        }
        if (entityReachAttribute != null) {
            double reachDistance = 0.0;
            if (isMega) {
                reachDistance = (Double)ConfigRegistry.MEGA_MUSHROOM_REACH_DISTANCE.get();
            } else if (isMini) {
                reachDistance = (Double)ConfigRegistry.MINI_MUSHROOM_REACH_DISTANCE.get();
            }
            if (isMega || isMini) {
                LivingEntityMixin.mv$setModifier(entityReachAttribute, AttributesRegistry.ENTITY_REACH_DISTANCE, reachDistance);
            } else {
                LivingEntityMixin.mv$setModifier(entityReachAttribute, AttributesRegistry.ENTITY_REACH_DISTANCE, 0.0);
            }
        }
        if (this.mv$hasPeachCostume(entity) && motion.y < 0.0) {
            entity.setDeltaMovement(motion.x, motion.y * 0.7, motion.z);
        }
        if (isMini && motion.y < 0.0) {
            entity.setDeltaMovement(motion.x, motion.y * 0.9, motion.z);
        }
    }

    @Unique
    private static void mv$setModifier(AttributeInstance attribute, ResourceLocation id, double amount) {
        AttributeModifier modifier = attribute.getModifier(id);
        if (amount == 0.0) {
            if (modifier != null) {
                attribute.removeModifier(id);
            }
            return;
        }
        if (modifier != null) {
            if (modifier.amount() == amount) {
                return;
            }
            attribute.removeModifier(id);
        }
        attribute.addPermanentModifier(new AttributeModifier(id, amount, AttributeModifier.Operation.ADD_VALUE));
    }

    @ModifyReturnValue(method={"getArmorValue"}, at={@At(value="RETURN")})
    private int getArmorValue(int original) {
        LivingEntity entity = (LivingEntity)this;
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)entity);
        if (capability != null) {
            AttributeInstance knockbackAttribute;
            AccessoriesContainer[] accessorySlots = new AccessoriesContainer[]{capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_hat")), capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_shirt")), capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_pants")), capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_shoes"))};
            int totalExtraArmor = 0;
            float totalToughness = 0.0f;
            float totalKnockbackResistance = 0.0f;
            for (AccessoriesContainer container : accessorySlots) {
                Item item;
                if (container == null) {
                    return original;
                }
                ItemStack stack = container.getAccessories().getItem(0);
                if (stack.isEmpty() || !((item = stack.getItem()) instanceof ArmorItem)) continue;
                ArmorItem accessoryArmor = (ArmorItem)item;
                ArmorMaterial material = (ArmorMaterial)accessoryArmor.getMaterial().value();
                totalExtraArmor += material.getDefense(accessoryArmor.getType()) / 2;
                totalToughness += material.toughness() / 2.0f;
                totalKnockbackResistance += material.knockbackResistance() / 2.0f;
            }
            AttributeInstance toughnessAttribute = entity.getAttribute(Attributes.ARMOR_TOUGHNESS);
            if (toughnessAttribute != null) {
                boolean hasModifier;
                boolean bl = hasModifier = toughnessAttribute.getModifier(AttributesRegistry.COSTUME_ARMOR_TOUGHNESS) != null;
                if (totalToughness > 0.0f) {
                    AttributeModifier toughnessModifier = new AttributeModifier(AttributesRegistry.COSTUME_ARMOR_TOUGHNESS, (double)totalToughness, AttributeModifier.Operation.ADD_VALUE);
                    if (!hasModifier) {
                        toughnessAttribute.addPermanentModifier(toughnessModifier);
                    }
                } else if (hasModifier) {
                    toughnessAttribute.removeModifier(AttributesRegistry.COSTUME_ARMOR_TOUGHNESS);
                }
            }
            if ((knockbackAttribute = entity.getAttribute(Attributes.KNOCKBACK_RESISTANCE)) != null) {
                boolean hasModifier;
                boolean bl = hasModifier = knockbackAttribute.getModifier(AttributesRegistry.COSTUME_ARMOR_KNOCKBACK_RESISTANCE) != null;
                if (totalKnockbackResistance > 0.0f) {
                    AttributeModifier knockbackModifier = new AttributeModifier(AttributesRegistry.COSTUME_ARMOR_KNOCKBACK_RESISTANCE, (double)totalKnockbackResistance, AttributeModifier.Operation.ADD_VALUE);
                    if (!hasModifier) {
                        knockbackAttribute.addPermanentModifier(knockbackModifier);
                    }
                } else if (hasModifier) {
                    knockbackAttribute.removeModifier(AttributesRegistry.COSTUME_ARMOR_KNOCKBACK_RESISTANCE);
                }
            }
            return original + totalExtraArmor;
        }
        return original;
    }

    @ModifyReturnValue(method={"checkTotemDeathProtection"}, at={@At(value="RETURN")})
    private boolean checkTotemDeathProtection(boolean original, DamageSource source) {
        SoundSource soundSource;
        LivingEntity livingEntity = (LivingEntity)this;
        SoundSource soundSource2 = soundSource = livingEntity instanceof Player ? SoundSource.PLAYERS : SoundSource.NEUTRAL;
        if (!source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            ItemStack stackCharm2;
            AccessoriesContainer containerCharm;
            AccessoriesCapability capability;
            ItemStack stackInHand;
            ItemStack stack = livingEntity.getOffhandItem();
            for (InteractionHand hand : InteractionHand.values()) {
                stackInHand = livingEntity.getItemInHand(hand);
                if (!(stackInHand.getItem() instanceof OneUpMushroomItem)) continue;
                stack = stackInHand.copy();
                stackInHand.shrink(1);
                break;
            }
            if ((capability = AccessoriesCapability.get((LivingEntity)livingEntity)) != null && (containerCharm = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)livingEntity, (String)"charm"))) != null && (stackCharm2 = containerCharm.getAccessories().getItem(0)).getItem() instanceof OneUpMushroomItem) {
                this.level().playSound(null, livingEntity.blockPosition(), (SoundEvent)SoundRegistry.ONE_UP_COLLECTED.get(), soundSource, 1.0f, 1.0f);
                livingEntity.setHealth(((Double)ConfigRegistry.ONE_UP_HEALTH_HEALED.get()).floatValue());
                stackCharm2.shrink(1);
                stackInHand = livingEntity.level();
                if (stackInHand instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)stackInHand;
                    ServerParticleUtils.spawnPoweredUpParticles((ParticleOptions)ParticleRegistry.POWERED_UP.get(), serverWorld, (Entity)livingEntity, 25);
                    ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.ONE_UP.get(), serverWorld, (Entity)livingEntity, 1.0);
                    if (livingEntity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)livingEntity;
                        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new OneUpPayload(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)livingEntity;
                    serverplayer.awardStat(Stats.ITEM_USED.get((Object)((Item)ItemRegistry.ONE_UP_MUSHROOM.get())), 1);
                    CriteriaTriggers.USED_TOTEM.trigger(serverplayer, stack);
                    this.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
                }
                return true;
            }
            if (!stack.isEmpty() && stack.getItem() instanceof OneUpMushroomItem) {
                this.level().playSound(null, livingEntity.blockPosition(), (SoundEvent)SoundRegistry.ONE_UP_COLLECTED.get(), soundSource, 1.0f, 1.0f);
                livingEntity.setHealth(((Double)ConfigRegistry.ONE_UP_HEALTH_HEALED.get()).floatValue());
                stack.shrink(1);
                Level stackCharm2 = livingEntity.level();
                if (stackCharm2 instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)stackCharm2;
                    ServerParticleUtils.spawnPoweredUpParticles((ParticleOptions)ParticleRegistry.POWERED_UP.get(), serverWorld, (Entity)livingEntity, 25);
                    ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.ONE_UP.get(), serverWorld, (Entity)livingEntity, 1.0);
                    if (livingEntity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)livingEntity;
                        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new OneUpPayload(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)livingEntity;
                    serverplayer.awardStat(Stats.ITEM_USED.get((Object)((Item)ItemRegistry.ONE_UP_MUSHROOM.get())), 1);
                    CriteriaTriggers.USED_TOTEM.trigger(serverplayer, stack);
                    this.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
                }
                return true;
            }
        }
        return original;
    }

    @ModifyReturnValue(method={"isDamageSourceBlocked"}, at={@At(value="RETURN")})
    public boolean isDamageSourceBlocked(boolean original, DamageSource source) {
        Vec3 vec32;
        LivingEntity livingEntity = (LivingEntity)this;
        if (source.is(TagRegistry.SHIELD_BLOCKS) && livingEntity.isBlocking() && (vec32 = source.getSourcePosition()) != null) {
            return true;
        }
        return original;
    }

    @ModifyReturnValue(method={"createLivingAttributes"}, at={@At(value="RETURN")})
    private static AttributeSupplier.Builder createLivingAttributes(AttributeSupplier.Builder original) {
        original.add(AttributesRegistry.EYE_HEIGHT_SCALE);
        original.add(AttributesRegistry.HEIGHT_SCALE);
        original.add(AttributesRegistry.WIDTH_SCALE);
        return original;
    }

    @ModifyReturnValue(method={"handleRelativeFrictionAndCalculateMovement"}, at={@At(value="RETURN")})
    private Vec3 mv$handleRelativeFrictionAndCalculateMovement(Vec3 motion) {
        LivingEntity livingEntity = (LivingEntity)this;
        BlockState state = livingEntity.level().getBlockState(this.blockPosition());
        if ((this.horizontalCollision || this.jumping) && state.getBlock() instanceof QuicksandBlock) {
            return new Vec3(motion.x, 0.2, motion.z);
        }
        return motion;
    }

    @ModifyReturnValue(method={"getDimensions"}, at={@At(value="TAIL")})
    private EntityDimensions getDimensions(EntityDimensions original, Pose pose) {
        float eyeScale = this.mv$getEyeHeightScale();
        float heightScale = this.mv$getHeightScale();
        float widthScale = this.mv$getWidthScale();
        return EntityDimensions.scalable((float)(original.width() * widthScale), (float)(original.height() * heightScale)).withEyeHeight(original.eyeHeight() * eyeScale);
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="HEAD")})
    private void jumpFromGround(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        AttributeInstance speedAttribute = entity.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speedAttribute != null && speedAttribute.hasModifier(AttributesRegistry.MINI_GOOMBA_SLOWDOWN)) {
            speedAttribute.removeModifier(AttributesRegistry.MINI_GOOMBA_SLOWDOWN);
        }
    }

    @Inject(method={"canFreeze"}, at={@At(value="HEAD")}, cancellable=true)
    private void canFreeze(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)entity);
        if (capability != null) {
            boolean hasFreezeImmunity;
            AccessoriesContainer containerHat = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_hat"));
            AccessoriesContainer containerShirt = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_shirt"));
            AccessoriesContainer containerPants = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_pants"));
            AccessoriesContainer containerShoes = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)"costume_shoes"));
            boolean bl = hasFreezeImmunity = containerHat != null && containerHat.getAccessories().getItem(0).is(ItemTags.FREEZE_IMMUNE_WEARABLES) || containerShirt != null && containerShirt.getAccessories().getItem(0).is(ItemTags.FREEZE_IMMUNE_WEARABLES) || containerPants != null && containerPants.getAccessories().getItem(0).is(ItemTags.FREEZE_IMMUNE_WEARABLES) || containerShoes != null && containerShoes.getAccessories().getItem(0).is(ItemTags.FREEZE_IMMUNE_WEARABLES);
            if (hasFreezeImmunity) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"handleEntityEvent"}, at={@At(value="HEAD")})
    private void handleEntityEvent(byte id, CallbackInfo info) {
        LivingEntity entity = (LivingEntity)this;
        RandomSource random = entity.getRandom();
        if (id == 109) {
            ParticleUtils.spawnParticlesOnBlockFaces((Level)entity.level(), (BlockPos)BlockPos.containing((double)(entity.getX() + 0.5), (double)(entity.getY() + (double)entity.getBbHeight()), (double)(entity.getZ() + 0.5)), (ParticleOptions)((ParticleOptions)ParticleRegistry.COIN_GLINT.get()), (IntProvider)UniformInt.of((int)2, (int)3));
        } else if (id == 110) {
            ParticleUtils.spawnParticlesOnBlockFaces((Level)entity.level(), (BlockPos)BlockPos.containing((double)(entity.getX() + 0.5), (double)(entity.getY() + (double)entity.getBbHeight()), (double)(entity.getZ() + 0.5)), (ParticleOptions)((ParticleOptions)ParticleRegistry.COIN_GLINT.get()), (IntProvider)UniformInt.of((int)1, (int)1));
        } else if (id == 111) {
            this.level().addParticle((ParticleOptions)ParticleTypes.CRIT, entity.getX(), entity.getY() + (double)entity.getEyeHeight(), entity.getZ(), 0.0, 1.0, 0.0);
        } else if (id == 112) {
            ParticleUtils.spawnParticlesOnBlockFaces((Level)entity.level(), (BlockPos)this.blockPosition(), (ParticleOptions)((ParticleOptions)ParticleRegistry.GLOWING_STAR.get()), (IntProvider)UniformInt.of((int)1, (int)1));
        } else if (id == 113) {
            ParticleUtils.spawnParticlesOnBlockFaces((Level)entity.level(), (BlockPos)this.blockPosition(), (ParticleOptions)((ParticleOptions)ParticleRegistry.COIN_GLINT.get()), (IntProvider)UniformInt.of((int)1, (int)1));
        } else if (id == 119) {
            this.mv$spawnPowerUpParticles((Entity)entity, (ParticleOptions)ParticleRegistry.COIN_GLINT.get(), 15);
        } else if (id == 120) {
            for (int i = 0; i < 100; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.ENCHANT, entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), (random.nextDouble() - 0.5) * 2.0, -random.nextDouble(), (random.nextDouble() - 0.5) * 2.0);
            }
        } else if (id == 123) {
            this.mv$spawnPowerUpParticles((Entity)entity, (ParticleOptions)ParticleRegistry.FIRE_POWERED_UP.get(), 15);
        } else if (id == 124) {
            this.mv$spawnPowerUpParticles((Entity)entity, (ParticleOptions)ParticleRegistry.POWERED_UP.get(), 25);
        } else if (id == 125) {
            if (this.level().isClientSide) {
                ParticleUtils.spawnParticlesOnBlockFaces((Level)this.level(), (BlockPos)this.blockPosition().above(Math.round(this.getBbHeight())).above(), (ParticleOptions)((ParticleOptions)ParticleRegistry.COIN_GLINT.get()), (IntProvider)UniformInt.of((int)1, (int)1));
            }
        } else if (id == 126) {
            if (this.level().isClientSide) {
                this.level().addParticle((ParticleOptions)ParticleRegistry.ONE_UP.get(), entity.getX(), entity.getY() + (double)entity.getBbHeight(), entity.getZ(), 0.0, 1.0, 0.0);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    @Unique
    public float mv$getEyeHeightScale() {
        LivingEntity entity = (LivingEntity)this;
        AttributeMap attributemap = entity.getAttributes();
        return attributemap == null ? 1.0f : this.mv$sanitizeScales((float)attributemap.getValue(AttributesRegistry.EYE_HEIGHT_SCALE));
    }

    @Unique
    public float mv$getHeightScale() {
        LivingEntity entity = (LivingEntity)this;
        AttributeMap attributemap = entity.getAttributes();
        return attributemap == null ? 1.0f : this.mv$sanitizeScales((float)attributemap.getValue(AttributesRegistry.HEIGHT_SCALE));
    }

    @Unique
    public float mv$getWidthScale() {
        LivingEntity entity = (LivingEntity)this;
        AttributeMap attributemap = entity.getAttributes();
        return attributemap == null ? 1.0f : this.mv$sanitizeScales((float)attributemap.getValue(AttributesRegistry.WIDTH_SCALE));
    }

    @Unique
    public float mv$sanitizeScales(float scale) {
        return scale;
    }

    @Unique
    public void mv$spawnPowerUpParticles(Entity entity, ParticleOptions particleType, int avgAmount) {
        if (entity.level().isClientSide) {
            float scaleFactor = entity.getBbWidth();
            int numParticles = (int)(scaleFactor * (float)avgAmount);
            double radius = entity.getBbWidth() / 2.0f;
            for (int i = 0; i < numParticles; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)numParticles;
                double offsetX = Math.cos(angle) * radius;
                double offsetY = entity.getBbHeight();
                double offsetZ = Math.sin(angle) * radius;
                double x = entity.getX() + offsetX;
                double y = entity.getY();
                double z = entity.getZ() + offsetZ;
                this.level().addParticle(particleType, x, y + offsetY - 0.2, z, 0.0, 1.0, 0.0);
                this.level().addParticle(particleType, x, y + offsetY / 2.0, z, 0.0, 1.0, 0.0);
                this.level().addParticle(particleType, x, y + 0.2, z, 0.0, 1.0, 0.0);
            }
        }
    }

    @Unique
    public void mv$superStarKillEntity(LivingEntity attackingEntity) {
        List nearbyEntities = attackingEntity.level().getEntities((Entity)attackingEntity, attackingEntity.getBoundingBox());
        if (!nearbyEntities.isEmpty()) {
            for (Entity collidedEntity : nearbyEntities) {
                Player player;
                LivingEntity entity;
                if (!(collidedEntity instanceof LivingEntity) || (entity = (LivingEntity)collidedEntity).getType().is(TagRegistry.SUPER_STAR_IMMUNE)) continue;
                if (entity instanceof Player && (player = (Player)entity).isCreative() || entity.isSpectator()) {
                    return;
                }
                if (((Boolean)collidedEntity.getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue()) {
                    return;
                }
                Vec3 knockbackDirection = entity.position().subtract(attackingEntity.position()).normalize();
                double knockbackStrength = 5.0;
                Vec3 knockbackVelocity = knockbackDirection.scale(knockbackStrength).add(0.0, 1.0, 0.0);
                if (!((Boolean)ConfigRegistry.DISABLE_CONSECUTIVE_BOUNCING.get()).booleanValue() && entity.isAlive() && !entity.isInvulnerable()) {
                    OneUpMushroomEntity.consecutiveReward(attackingEntity, entity, (Integer)attackingEntity.getData(DataAttachmentRegistry.CONSECUTIVE_BOUNCES));
                }
                entity.setDeltaMovement(knockbackVelocity);
                entity.hurt(DamageSourceRegistry.superStar(collidedEntity, (Entity)attackingEntity), ((Double)ConfigRegistry.SUPER_STAR_DAMAGE.get()).floatValue());
            }
        }
    }

    @Unique
    public void mv$squashEntity(LivingEntity stompingEntity) {
        List nearbyEntities = stompingEntity.level().getEntities((Entity)stompingEntity, stompingEntity.getBoundingBox().inflate(0.5, 1.25, 0.5));
        if (!nearbyEntities.isEmpty()) {
            for (Entity entity : nearbyEntities) {
                LivingEntity damagedEntity;
                if (!(entity instanceof LivingEntity) || (damagedEntity = (LivingEntity)entity).isVehicle() || !stompingEntity.getType().is(TagRegistry.CAN_STOMP_ENEMIES) && !((Boolean)ConfigRegistry.ALL_MOBS_CAN_STOMP.get()).booleanValue() && !stompingEntity.level().getGameRules().getBoolean(Marioverse.ALL_MOBS_CAN_STOMP) || damagedEntity.getType().is(TagRegistry.POWER_UP_ENTITIES) || !damagedEntity.getType().is(TagRegistry.CAN_BE_STOMPED) && !damagedEntity.getType().is(TagRegistry.CAN_BE_INSTAKILL_STOMPED) && (!((Boolean)ConfigRegistry.STOMP_ALL_MOBS.get()).booleanValue() || !(damagedEntity instanceof LivingEntity)) && (!damagedEntity.level().getGameRules().getBoolean(Marioverse.STOMP_ALL_MOBS) || !(damagedEntity instanceof LivingEntity))) continue;
                if (stompingEntity instanceof Player) {
                    Player player = (Player)stompingEntity;
                    if (player.getAbilities().flying) {
                        return;
                    }
                }
                if (((Boolean)stompingEntity.getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue() || ((Boolean)damagedEntity.getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue()) {
                    return;
                }
                if (!(stompingEntity.getY() >= damagedEntity.getY() + (double)damagedEntity.getEyeHeight()) || !(stompingEntity.fallDistance > 0.0f) && !stompingEntity.isInWaterOrBubble()) continue;
                double bounceBlockHeight = ConfigRegistry.STOMP_BOUNCE_HEIGHT.getAsDouble();
                double gravity = 0.08;
                double bounceVelocity = Math.sqrt(2.0 * gravity * bounceBlockHeight);
                if (damagedEntity.isAlive()) {
                    stompingEntity.setDeltaMovement(stompingEntity.getDeltaMovement().x, bounceVelocity, stompingEntity.getDeltaMovement().z);
                    stompingEntity.hasImpulse = true;
                    if (stompingEntity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)stompingEntity;
                        serverPlayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)stompingEntity));
                    }
                }
                float scaleFactor = damagedEntity.getBbHeight() * damagedEntity.getBbWidth();
                int numParticles = (int)(scaleFactor * 20.0f);
                double radius = damagedEntity.getBbWidth() / 2.0f;
                Level level = stompingEntity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnParticleRingAboveEntity((ParticleOptions)ParticleTypes.CRIT, serverWorld, (Entity)damagedEntity, radius, 0.0, numParticles);
                }
                boolean hasNoArmor = true;
                for (ItemStack armorSlot : damagedEntity.getArmorSlots()) {
                    if (armorSlot.isEmpty()) continue;
                    hasNoArmor = false;
                    break;
                }
                if (stompingEntity.level().isClientSide() || damagedEntity.isDeadOrDying()) continue;
                if (damagedEntity.getType().is(TagRegistry.CAN_BE_INSTAKILL_STOMPED) && hasNoArmor && !((Boolean)stompingEntity.getData(DataAttachmentRegistry.HAS_MINI_MUSHROOM)).booleanValue()) {
                    damagedEntity.hurt(DamageSourceRegistry.stomp((Entity)damagedEntity, (Entity)stompingEntity), damagedEntity.getHealth());
                } else if (damagedEntity.getType().is(TagRegistry.CAN_BE_STOMPED) || ((Boolean)ConfigRegistry.STOMP_ALL_MOBS.get()).booleanValue() || stompingEntity.level().getGameRules().getBoolean(Marioverse.STOMP_ALL_MOBS)) {
                    if (((Boolean)stompingEntity.getData(DataAttachmentRegistry.HAS_MINI_MUSHROOM)).booleanValue() || damagedEntity instanceof KoopaTroopaEntity || damagedEntity instanceof KoopaShellEntity) {
                        damagedEntity.hurt(DamageSourceRegistry.stomp((Entity)damagedEntity, (Entity)stompingEntity), 0.0f);
                    } else {
                        damagedEntity.hurt(DamageSourceRegistry.stomp((Entity)damagedEntity, (Entity)stompingEntity), ((Double)ConfigRegistry.STOMP_DAMAGE.get()).floatValue());
                    }
                }
                if (((Boolean)ConfigRegistry.DISABLE_CONSECUTIVE_BOUNCING.get()).booleanValue() || ((Boolean)stompingEntity.getData(DataAttachmentRegistry.HAS_MINI_MUSHROOM)).booleanValue()) break;
                OneUpMushroomEntity.consecutiveReward(stompingEntity, damagedEntity, (Integer)stompingEntity.getData(DataAttachmentRegistry.CONSECUTIVE_BOUNCES));
                break;
            }
        }
    }
}

