/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.mixin;

import com.wenxin2.marioverse.blocks.CheckpointFlagBlock;
import com.wenxin2.marioverse.blocks.states.TripleBlockStates;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import com.wenxin2.marioverse.utils.BlockWarpPlayerHandler;
import com.wenxin2.marioverse.utils.EntityWarpPlayerHandler;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public class ServerPlayerMixin
implements BlockWarpPlayerHandler,
EntityWarpPlayerHandler,
AbilitiesHandler {
    @Override
    public boolean mv$getBlockWarpTeleportConfig() {
        return (Boolean)ConfigRegistry.TELEPORT_PLAYERS.get();
    }

    @Override
    public boolean mv$getEntityWarpTeleportConfig() {
        return (Boolean)ConfigRegistry.TELEPORT_PLAYERS.get();
    }

    @Inject(method={"findRespawnAndUseSpawnBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private static void findRespawnAndUseSpawnBlock(ServerLevel world, BlockPos pos, float angle, boolean forced, boolean anchor, CallbackInfoReturnable<Optional<ServerPlayer.RespawnPosAngle>> cir) {
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof CheckpointFlagBlock) {
            Vec3 spawnPos = state.getValue(CheckpointFlagBlock.PART) == TripleBlockStates.TOP ? Vec3.atBottomCenterOf((Vec3i)pos.below(2)) : (state.getValue(CheckpointFlagBlock.PART) == TripleBlockStates.MIDDLE ? Vec3.atBottomCenterOf((Vec3i)pos.below()) : Vec3.atBottomCenterOf((Vec3i)pos));
            cir.setReturnValue(Optional.of(new ServerPlayer.RespawnPosAngle(spawnPos, angle)));
        }
    }
}

