/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.network.server_bound.handler;

import com.wenxin2.marioverse.entities.projectiles.BouncingIceBallProjectile;
import com.wenxin2.marioverse.network.client_bound.data.SwingHandPayload;
import com.wenxin2.marioverse.network.server_bound.data.IceBallShootPayload;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.EntityRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class IceBallShootPacket {
    public static final IceBallShootPacket INSTANCE = new IceBallShootPacket();
    private static final int ICE_BALL_COOLDOWN = 5;

    public static IceBallShootPacket get() {
        return INSTANCE;
    }

    public void handle(IceBallShootPayload payload, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> {
                Player player = context.player();
                if (((Boolean)player.getData(DataAttachmentRegistry.HAS_ICE_FLOWER)).booleanValue()) {
                    this.handleIceballShooting(player);
                }
            });
        }
    }

    public void handleIceballShooting(Player player) {
        if ((Integer)player.getData(DataAttachmentRegistry.ICE_BALL_COOLDOWN) == 0 && (Integer)player.getData(DataAttachmentRegistry.ICE_BALL_COUNT) < (Integer)ConfigRegistry.MAX_PLAYER_ICE_BALLS.get()) {
            IceBallShootPacket.shootIceBall(player);
            player.setData(DataAttachmentRegistry.ICE_BALL_COOLDOWN, (Object)5);
            player.setData(DataAttachmentRegistry.ICE_BALL_COUNT, (Object)((Integer)player.getData(DataAttachmentRegistry.ICE_BALL_COUNT) + 1));
        } else if ((Integer)player.getData(DataAttachmentRegistry.ICE_BALL_COUNT) >= (Integer)ConfigRegistry.MAX_PLAYER_ICE_BALLS.get()) {
            player.setData(DataAttachmentRegistry.ICE_BALL_COOLDOWN, (Object)((Integer)ConfigRegistry.ICE_BALL_COOLDOWN.get()));
            player.setData(DataAttachmentRegistry.ICE_BALL_COUNT, (Object)0);
        }
    }

    public static void shootIceBall(Player player) {
        Level world = player.level();
        SoundSource soundSource = SoundSource.PLAYERS;
        BouncingIceBallProjectile iceBall = new BouncingIceBallProjectile((EntityType<? extends BouncingIceBallProjectile>)((EntityType)EntityRegistry.BOUNCING_ICE_BALL.get()), world);
        iceBall.setOwner((Entity)player);
        iceBall.setPos(player.getX(), player.getEyeY() - 0.5, player.getZ());
        iceBall.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.2f, 1.0f);
        world.playSound(null, player.blockPosition(), (SoundEvent)SoundRegistry.ICE_BALL_THROWN.get(), soundSource, 1.0f, 1.0f);
        Vec3 look = player.getLookAngle();
        iceBall.setDeltaMovement(look.scale(0.5));
        iceBall.setYRot((float)Math.toDegrees(Math.atan2(look.z, look.x)) + 90.0f);
        iceBall.setXRot((float)Math.toDegrees(Math.atan2(look.y, Math.sqrt(look.x * look.x + look.z * look.z))));
        world.addFreshEntity((Entity)iceBall);
        world.gameEvent((Entity)player, (Holder)GameEvent.PROJECTILE_SHOOT, player.position());
        if (!world.isClientSide() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SwingHandPayload(Boolean.TRUE), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

