/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.network.server_bound.handler;

import com.wenxin2.marioverse.Marioverse;
import com.wenxin2.marioverse.entities.KoopaShellEntity;
import com.wenxin2.marioverse.entities.KoopaTroopaEntity;
import com.wenxin2.marioverse.entities.power_ups.OneUpMushroomEntity;
import com.wenxin2.marioverse.entities.projectiles.LargeSnowballProjectile;
import com.wenxin2.marioverse.network.server_bound.data.SquashEntityPayload;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DamageSourceRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SquashEntityPacket {
    public static final SquashEntityPacket INSTANCE = new SquashEntityPacket();

    public static SquashEntityPacket get() {
        return INSTANCE;
    }

    public void handle(SquashEntityPayload payload, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> {
                Player player = context.player();
                if (((Boolean)ConfigRegistry.ENABLE_STOMPABLE_ENEMIES.get()).booleanValue() && (player.getType().is(TagRegistry.CAN_STOMP_ENEMIES) || ((Boolean)ConfigRegistry.ALL_MOBS_CAN_STOMP.get()).booleanValue() || player.level().getGameRules().getBoolean(Marioverse.ALL_MOBS_CAN_STOMP)) && (player.fallDistance > 0.0f || player.isInWaterOrBubble())) {
                    this.squashEntity(player, payload.isHoldingJump());
                }
            });
        }
    }

    /*
     * Unable to fully structure code
     */
    public void squashEntity(Player stompingPlayer, boolean isHoldingJump) {
        block16: {
            nearbyEntities = stompingPlayer.level().getEntities((Entity)stompingPlayer, stompingPlayer.getBoundingBox().inflate(0.0, 0.5, 0.0));
            if (nearbyEntities.isEmpty()) break block16;
            for (Entity damagedEntity : nearbyEntities) {
                if (damagedEntity.isVehicle() || !stompingPlayer.getType().is(TagRegistry.CAN_STOMP_ENEMIES) && !((Boolean)ConfigRegistry.ALL_MOBS_CAN_STOMP.get()).booleanValue() && !stompingPlayer.level().getGameRules().getBoolean(Marioverse.ALL_MOBS_CAN_STOMP) || damagedEntity.getType().is(TagRegistry.POWER_UP_ENTITIES) || !damagedEntity.getType().is(TagRegistry.CAN_BE_STOMPED) && !damagedEntity.getType().is(TagRegistry.CAN_BE_INSTAKILL_STOMPED) && !((Boolean)ConfigRegistry.STOMP_ALL_MOBS.get()).booleanValue() && !stompingPlayer.level().getGameRules().getBoolean(Marioverse.STOMP_ALL_MOBS)) continue;
                if (stompingPlayer instanceof Player) {
                    player = stompingPlayer;
                    if (player.getAbilities().flying) {
                        return;
                    }
                }
                if (((Boolean)stompingPlayer.getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue() || ((Boolean)damagedEntity.getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue()) {
                    return;
                }
                if (!(stompingPlayer.getY() >= damagedEntity.getY() + (double)damagedEntity.getEyeHeight()) || !(stompingPlayer.fallDistance > 0.0f) && !stompingPlayer.isInWaterOrBubble()) continue;
                bounceBlockHeight = ConfigRegistry.STOMP_BOUNCE_HEIGHT.getAsDouble();
                if (isHoldingJump) {
                    bounceBlockHeight = ConfigRegistry.STOMP_BOUNCE_HEIGHT_JUMP.getAsDouble();
                }
                gravity = 0.08;
                bounceVelocity = Math.sqrt(2.0 * gravity * bounceBlockHeight);
                if (damagedEntity.isAlive()) {
                    stompingPlayer.setDeltaMovement(stompingPlayer.getDeltaMovement().x, bounceVelocity, stompingPlayer.getDeltaMovement().z);
                    stompingPlayer.hasImpulse = true;
                    if (stompingPlayer instanceof ServerPlayer) {
                        serverPlayer = (ServerPlayer)stompingPlayer;
                        serverPlayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)stompingPlayer));
                    }
                }
                scaleFactor = damagedEntity.getBbHeight() * damagedEntity.getBbWidth();
                numParticles = (int)(scaleFactor * 20.0f);
                radius = damagedEntity.getBbWidth() / 2.0f;
                var17_16 = stompingPlayer.level();
                if (var17_16 instanceof ServerLevel) {
                    serverWorld = (ServerLevel)var17_16;
                    ServerParticleUtils.spawnParticleRingAboveEntity((ParticleOptions)ParticleTypes.CRIT, serverWorld, damagedEntity, radius, 0.0, numParticles);
                }
                if (damagedEntity instanceof LargeSnowballProjectile) {
                    snowball = (LargeSnowballProjectile)damagedEntity;
                    snowball.discardEffectsOnSideHit(damagedEntity.level(), damagedEntity.blockPosition(), null);
                }
                hasNoArmor = true;
                if (damagedEntity instanceof LivingEntity) {
                    livingEntity = (LivingEntity)damagedEntity;
                    for (ItemStack armorSlot : livingEntity.getArmorSlots()) {
                        if (armorSlot.isEmpty()) continue;
                        hasNoArmor = false;
                        break;
                    }
                }
                if (stompingPlayer.level().isClientSide() || !damagedEntity.isAlive()) continue;
                if (!damagedEntity.getType().is(TagRegistry.CAN_BE_INSTAKILL_STOMPED) || !hasNoArmor || !(damagedEntity instanceof LivingEntity)) ** GOTO lbl-1000
                livingEntity = (LivingEntity)damagedEntity;
                if (!((Boolean)stompingPlayer.getData(DataAttachmentRegistry.HAS_MINI_MUSHROOM)).booleanValue()) {
                    damagedEntity.hurt(DamageSourceRegistry.stomp(damagedEntity, (Entity)stompingPlayer), livingEntity.getHealth());
                } else if (damagedEntity.getType().is(TagRegistry.CAN_BE_STOMPED) || ((Boolean)ConfigRegistry.STOMP_ALL_MOBS.get()).booleanValue() || damagedEntity.level().getGameRules().getBoolean(Marioverse.STOMP_ALL_MOBS)) {
                    if (((Boolean)stompingPlayer.getData(DataAttachmentRegistry.HAS_MINI_MUSHROOM)).booleanValue() || damagedEntity instanceof KoopaTroopaEntity || damagedEntity instanceof KoopaShellEntity) {
                        damagedEntity.hurt(DamageSourceRegistry.stomp(damagedEntity, (Entity)stompingPlayer), 0.0f);
                    } else {
                        damagedEntity.hurt(DamageSourceRegistry.stomp(damagedEntity, (Entity)stompingPlayer), ((Double)ConfigRegistry.STOMP_DAMAGE.get()).floatValue());
                    }
                }
                if (((Boolean)ConfigRegistry.DISABLE_CONSECUTIVE_BOUNCING.get()).booleanValue() || ((Boolean)stompingPlayer.getData(DataAttachmentRegistry.HAS_MINI_MUSHROOM)).booleanValue() || !(damagedEntity instanceof LivingEntity)) break;
                livingEntity = (LivingEntity)damagedEntity;
                OneUpMushroomEntity.consecutiveReward((LivingEntity)stompingPlayer, livingEntity, (Integer)stompingPlayer.getData(DataAttachmentRegistry.CONSECUTIVE_BOUNCES));
                break;
            }
        }
    }
}

