/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.registries;

import com.wenxin2.marioverse.Marioverse;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;

public class AttributesRegistry {
    public static final DeferredHolder<Attribute, Attribute> EYE_HEIGHT_SCALE;
    public static final DeferredHolder<Attribute, Attribute> HEIGHT_SCALE;
    public static final DeferredHolder<Attribute, Attribute> WIDTH_SCALE;
    public static final ResourceLocation AUTO_STEP_HEIGHT;
    public static final ResourceLocation BLOCK_REACH_DISTANCE;
    public static final ResourceLocation COSTUME_ARMOR_KNOCKBACK_RESISTANCE;
    public static final ResourceLocation COSTUME_ARMOR_TOUGHNESS;
    public static final ResourceLocation DAMAGED_SCALE;
    public static final ResourceLocation ENTITY_REACH_DISTANCE;
    public static final ResourceLocation JUMP_BOOST;
    public static final ResourceLocation MAX_HEATH;
    public static final ResourceLocation MINI_GOOMBA_SLOWDOWN;
    public static final ResourceLocation RUNNING_JUMP_BOOST;
    public static final ResourceLocation SAFE_FALL_DISTANCE;

    public static void init() {
    }

    public static void updateAttributeModifiers(@Nullable AttributeInstance attribute, ResourceLocation id, double amount, boolean shouldAdd, boolean shouldRemove) {
        if (attribute == null) {
            return;
        }
        AttributeModifier modifier = attribute.getModifier(id);
        if (modifier != null && shouldRemove) {
            attribute.removeModifier(modifier);
            modifier = null;
        }
        if (modifier == null && shouldAdd && amount != 0.0) {
            attribute.addPermanentModifier(new AttributeModifier(id, amount, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    static {
        AUTO_STEP_HEIGHT = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"auto_step_height");
        BLOCK_REACH_DISTANCE = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"block_reach_distance");
        COSTUME_ARMOR_KNOCKBACK_RESISTANCE = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"costume_armor_knockback_resistance");
        COSTUME_ARMOR_TOUGHNESS = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"costume_armor_toughness");
        DAMAGED_SCALE = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"damaged_scale");
        ENTITY_REACH_DISTANCE = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"entity_reach_distance");
        JUMP_BOOST = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"character_jump_boost");
        MAX_HEATH = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"max_health");
        MINI_GOOMBA_SLOWDOWN = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"mini_goomba_slowdown");
        RUNNING_JUMP_BOOST = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"character_running_jump_boost");
        SAFE_FALL_DISTANCE = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"character_safe_fall_distance");
        EYE_HEIGHT_SCALE = Marioverse.ATTRIBUTES.register("eye_height_scale", () -> new RangedAttribute("attribute.marioverse.generic.eye_height_scale", 1.0, 0.0625, 32.0).setSyncable(true).setSentiment(Attribute.Sentiment.NEUTRAL));
        HEIGHT_SCALE = Marioverse.ATTRIBUTES.register("height_scale", () -> new RangedAttribute("attribute.marioverse.generic.height_scale", 1.0, 0.0625, 32.0).setSyncable(true).setSentiment(Attribute.Sentiment.NEUTRAL));
        WIDTH_SCALE = Marioverse.ATTRIBUTES.register("width_scale", () -> new RangedAttribute("attribute.marioverse.generic.width_scale", 1.0, 0.0625, 32.0).setSyncable(true).setSentiment(Attribute.Sentiment.NEUTRAL));
    }
}

