/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.sounds;

import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FadingSoundInstance
extends AbstractTickableSoundInstance {
    private final LivingEntity entity;
    private final float fadeDuration;
    private final IntSupplier duration;
    private final BooleanSupplier hasPowerUp;
    private int lastDuration;
    private float fadeTicks = -1.0f;

    public FadingSoundInstance(LivingEntity entity, SoundEvent soundEvent, SoundSource soundSource, RandomSource random, float fadeDuration, IntSupplier duration, BooleanSupplier hasPowerUp) {
        super(soundEvent, soundSource, random);
        this.entity = entity;
        this.fadeDuration = fadeDuration;
        this.duration = duration;
        this.hasPowerUp = hasPowerUp;
        this.lastDuration = duration.getAsInt();
        this.looping = true;
        this.delay = 0;
        this.volume = 1.0f;
    }

    public void tick() {
        int currentDuration = this.duration.getAsInt();
        if (currentDuration > this.lastDuration) {
            this.fadeTicks = -1.0f;
            this.volume = 1.0f;
        }
        if (!this.hasPowerUp.getAsBoolean() && this.fadeTicks < 0.0f) {
            this.fadeTicks = this.fadeDuration / 2.0f;
        }
        if (this.fadeTicks >= 0.0f) {
            this.volume = Math.max(0.0f, this.fadeTicks / this.fadeDuration);
            this.fadeTicks -= 1.0f;
            if (this.fadeTicks <= 0.0f) {
                this.stop();
            }
        }
        this.lastDuration = currentDuration;
        this.x = this.entity.getX();
        this.y = this.entity.getY();
        this.z = this.entity.getZ();
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }
}

