/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.client.entity.model;

import dev.xylonity.bonsai.ghosts.Ghosts;
import dev.xylonity.bonsai.ghosts.common.entity.kodama.KodamaEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class KodamaModel
extends GeoModel<KodamaEntity> {
    private final float yawMultiply = 0.5f;
    private final float maxYawDegrees = 60.0f;
    private final float maxPitchDegrees = 45.0f;

    public ResourceLocation getModelResource(KodamaEntity animatable) {
        return Ghosts.of("geo/kodama_" + animatable.getVariant() + ".geo.json");
    }

    public ResourceLocation getTextureResource(KodamaEntity animatable) {
        return Ghosts.of("textures/entity/kodama_" + animatable.getVariant() + ".png");
    }

    public ResourceLocation getAnimationResource(KodamaEntity animatable) {
        return Ghosts.of("animations/kodama.animation.json");
    }

    public void setCustomAnimations(KodamaEntity animatable, long instanceId, AnimationState<KodamaEntity> animationState) {
        boolean headAnimActive;
        GeoBone head = this.getAnimationProcessor().getBone("head");
        if (head == null || animatable.isBartering()) {
            return;
        }
        EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        boolean bl = headAnimActive = animatable.getRattlingTicks() > 0;
        if (entityData == null) {
            if (!headAnimActive) {
                head.setRotX(0.0f);
                head.setRotY(0.0f);
                head.setRotZ(0.0f);
            }
            return;
        }
        float pitchDegrees = Mth.clamp((float)entityData.headPitch(), (float)-45.0f, (float)45.0f);
        float yawDegrees = Mth.wrapDegrees((float)entityData.netHeadYaw());
        yawDegrees = Mth.clamp((float)yawDegrees, (float)-60.0f, (float)60.0f) * 0.5f;
        float pitchRadians = pitchDegrees * ((float)Math.PI / 180);
        float yawRadians = yawDegrees * ((float)Math.PI / 180);
        if (!headAnimActive) {
            head.setRotX(pitchRadians);
            head.setRotY(yawRadians);
            head.setRotZ(0.0f);
            return;
        }
        head.setRotX(head.getRotX() + pitchRadians);
        head.setRotY(head.getRotY() + yawRadians);
    }
}

