/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xylonity.bonsai.ghosts.client.entity.layer.KodamaGlowLayer;
import dev.xylonity.bonsai.ghosts.client.entity.model.KodamaModel;
import dev.xylonity.bonsai.ghosts.common.entity.kodama.KodamaEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.RenderUtil;

public class KodamaRenderer
extends GeoEntityRenderer<KodamaEntity> {
    public KodamaRenderer(EntityRendererProvider.Context context) {
        super(context, (GeoModel)new KodamaModel());
        this.renderLayers.addLayer((GeoRenderLayer)new KodamaGlowLayer((GeoRenderer<KodamaEntity>)this));
    }

    public void renderRecursively(PoseStack poseStack, KodamaEntity animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        ItemStack stack = animatable.getItemBySlot(EquipmentSlot.MAINHAND);
        if (!stack.isEmpty() && bone.getName().equals("item")) {
            poseStack.pushPose();
            this.moveToBone(poseStack, bone);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.mulPose(Axis.ZN.rotationDegrees(90.0f));
            poseStack.mulPose(Axis.XN.rotationDegrees(180.0f));
            poseStack.translate(0.3, 0.0, -0.13);
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, packedLight, packedOverlay, poseStack, bufferSource, animatable.level(), 0);
            poseStack.popPose();
            buffer = bufferSource.getBuffer(renderType);
        }
        super.renderRecursively(poseStack, (Entity)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }

    protected void moveToBone(PoseStack poseStack, GeoBone bone) {
        poseStack.translate(-bone.getPosX() / 16.0f, bone.getPosY() / 16.0f, bone.getPosZ() / 16.0f);
        RenderUtil.rotateMatrixAroundBone((PoseStack)poseStack, (GeoBone)bone);
        poseStack.translate(bone.getPivotX() / 16.0f, bone.getPivotY() / 16.0f, bone.getPivotZ() / 16.0f);
    }
}

