/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xylonity.bonsai.ghosts.common.blockentity.CalibratedHauntedEyeBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CalibratedHauntedEyeBlock
extends DirectionalBlock
implements EntityBlock {
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    private static final double MAX_DETECTION_DISTANCE = 15.0;
    public static final MapCodec<DirectionalBlock> CODEC = RecordCodecBuilder.mapCodec(blockInstance -> blockInstance.group((App)CalibratedHauntedEyeBlock.propertiesCodec()).apply((Applicative)blockInstance, CalibratedHauntedEyeBlock::new));

    public CalibratedHauntedEyeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getNearestLookingDirection().getOpposite().getOpposite())).setValue((Property)POWER, (Comparable)Integer.valueOf(0));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWER});
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.isClientSide) {
            level.scheduleTick(pos, (Block)this, 1);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int currentPower;
        int newPower = this.calculatePowerLevel((Level)level, pos, state);
        if (newPower != (currentPower = ((Integer)state.getValue((Property)POWER)).intValue())) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(newPower)), 3);
            this.updateNeighbors((Level)level, pos, state);
        }
        level.scheduleTick(pos, (Block)this, 1);
    }

    private int calculatePowerLevel(Level level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        Vec3 eyePos = Vec3.atCenterOf((Vec3i)pos);
        Vec3 lookDirection = Vec3.atLowerCornerOf((Vec3i)facing.getNormal());
        List entities = level.getEntitiesOfClass(LivingEntity.class, this.createSearchArea(pos, facing), entity -> !entity.isSpectator());
        if (entities.isEmpty()) {
            return 0;
        }
        double closestDistance = 16.0;
        for (Entity entity2 : entities) {
            double distance;
            Vec3 entityPos = entity2.position();
            Vec3 toEntity = entityPos.subtract(eyePos);
            double dotProduct = toEntity.normalize().dot(lookDirection);
            if (!(dotProduct > 0.5) || !((distance = eyePos.distanceTo(entityPos)) < closestDistance)) continue;
            closestDistance = distance;
        }
        if (closestDistance > 15.0) {
            return 0;
        }
        int power = (int)Math.ceil(15.0 - closestDistance / 15.0 * 14.0);
        return Math.max(1, Math.min(15, power));
    }

    private AABB createSearchArea(BlockPos pos, Direction facing) {
        Vec3 center = Vec3.atCenterOf((Vec3i)pos);
        double expand = 3.0;
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> new AABB(center.x - 3.0, center.y - 3.0, center.z - 15.0, center.x + 3.0, center.y + 3.0, center.z);
            case Direction.SOUTH -> new AABB(center.x - 3.0, center.y - 3.0, center.z, center.x + 3.0, center.y + 3.0, center.z + 15.0);
            case Direction.WEST -> new AABB(center.x - 15.0, center.y - 3.0, center.z - 3.0, center.x, center.y + 3.0, center.z + 3.0);
            case Direction.EAST -> new AABB(center.x, center.y - 3.0, center.z - 3.0, center.x + 15.0, center.y + 3.0, center.z + 3.0);
            case Direction.UP -> new AABB(center.x - 3.0, center.y, center.z - 3.0, center.x + 3.0, center.y + 15.0, center.z + 3.0);
            case Direction.DOWN -> new AABB(center.x - 3.0, center.y - 15.0, center.z - 3.0, center.x + 3.0, center.y, center.z + 3.0);
        };
    }

    private void updateNeighbors(Level level, BlockPos pos, BlockState state) {
        Direction out = (Direction)state.getValue((Property)FACING);
        BlockPos target = pos.relative(out);
        level.neighborChanged(target, (Block)this, pos);
        level.updateNeighborsAtExceptFromFacing(target, (Block)this, out.getOpposite());
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return side == state.getValue((Property)FACING) ? (Integer)state.getValue((Property)POWER) : 0;
    }

    public int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return this.getSignal(state, level, pos, side);
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new CalibratedHauntedEyeBlockEntity(blockPos, blockState);
    }
}

