/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity;

import dev.xylonity.bonsai.ghosts.util.GhostOwnerTracker;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AbstractGhostEntity
extends TamableAnimal
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> MAIN_INTERACTION = SynchedEntityData.defineId(AbstractGhostEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private boolean chunkForced = false;
    private long forcedChunk = Long.MIN_VALUE;
    private boolean isTracked = false;

    public AbstractGhostEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.getOwnerUUID() != null) {
            if (!this.isTracked) {
                GhostOwnerTracker.getInstance().addGhost(this);
                this.isTracked = true;
            }
            this.ensureChunkForced();
        }
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    public void remove(Entity.RemovalReason reason) {
        if (!this.level().isClientSide && this.isTracked) {
            GhostOwnerTracker.getInstance().removeGhost(this);
            this.isTracked = false;
        }
        super.remove(reason);
    }

    private void ensureChunkForced() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ChunkPos chunkPosition = new ChunkPos(this.blockPosition());
            long now = chunkPosition.toLong();
            if (this.chunkForced && this.forcedChunk != now) {
                ChunkPos old = new ChunkPos(this.forcedChunk);
                serverLevel.setChunkForced(old.x, old.z, false);
                this.chunkForced = false;
            }
            if (!this.chunkForced) {
                serverLevel.setChunkForced(chunkPosition.x, chunkPosition.z, true);
                this.forcedChunk = now;
                this.chunkForced = true;
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MAIN_INTERACTION, (Object)0);
    }

    public void cycleMainInteraction(Player player) {
        int interaction = (this.getMainInteraction() + 1) % 3;
        this.setOrderedToSit(interaction == 0);
        if (player != null) {
            switch (interaction) {
                case 0: {
                    player.displayClientMessage((Component)Component.translatable((String)"entity.ghosts.client_message.interaction_0", (Object[])new Object[]{this.getName()}), true);
                    break;
                }
                case 1: {
                    player.displayClientMessage((Component)Component.translatable((String)"entity.ghosts.client_message.interaction_1", (Object[])new Object[]{this.getName()}), true);
                    break;
                }
                case 2: {
                    player.displayClientMessage((Component)Component.translatable((String)"entity.ghosts.client_message.interaction_2", (Object[])new Object[]{this.getName()}), true);
                }
            }
        }
        this.entityData.set(MAIN_INTERACTION, (Object)interaction);
    }

    protected void rotateBody() {
        Vec3 vel = this.getDeltaMovement();
        if (vel.lengthSqr() < 1.0E-4) {
            return;
        }
        float yaw = (float)(Mth.atan2((double)vel.z, (double)vel.x) * 57.29577951308232) - 90.0f;
        float pitch = (float)(-(Mth.atan2((double)vel.y, (double)Math.sqrt(vel.x * vel.x + vel.z * vel.z)) * 57.29577951308232));
        this.setYRot(yaw);
        this.setYHeadRot(yaw);
        this.yBodyRot = yaw;
        this.yRotO = yaw;
        this.yBodyRotO = yaw;
        this.setXRot(pitch);
        this.xRotO = pitch;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.IN_WALL)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public void setMainInteraction(int interaction) {
        this.entityData.set(MAIN_INTERACTION, (Object)interaction);
    }

    public int getMainInteraction() {
        return (Integer)this.entityData.get(MAIN_INTERACTION);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setMainInteraction(compound.getInt("MainInteraction"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("MainInteraction", this.getMainInteraction());
    }

    public ItemStack getHoldItem() {
        return this.getItemBySlot(EquipmentSlot.MAINHAND);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

