/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.generic;

import dev.xylonity.bonsai.ghosts.common.entity.ghost.GhostEntity;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GhostPlaceGoal
extends Goal {
    private final GhostEntity ghost;
    private final Ingredient placeables;
    private final Predicate<BlockState> preference;
    private final int minLight;
    private final int retryCooldown;
    private final double approachSpeed;
    private int nextTryTick;
    private int lastRepathTick;
    private final double maxOwnerDrift = 36.0;
    private BlockPos targetPlacePos;
    private BlockPos lastPlacedPos;

    public GhostPlaceGoal(GhostEntity ghost, Ingredient placeables, Predicate<BlockState> pref, int lightThreshold, int retry, double speed) {
        this.ghost = ghost;
        this.placeables = placeables;
        this.preference = pref;
        this.minLight = lightThreshold;
        this.retryCooldown = Math.max(5, retry);
        this.approachSpeed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        int minOwnerDistFromLast;
        int manhattanDistance;
        if (this.ghost.level().isClientSide) {
            return false;
        }
        if (this.ghost.getMainInteraction() != 1) {
            return false;
        }
        if (this.ghost.isInSittingPose() || this.ghost.isPassenger()) {
            return false;
        }
        if (this.ghost.tickCount < this.nextTryTick) {
            return false;
        }
        LivingEntity owner = this.ghost.getOwner();
        if (owner == null) {
            return false;
        }
        ItemStack heldStack = this.ghost.getHoldItem();
        if (!this.isPlaceableBlockItem(heldStack)) {
            return false;
        }
        if (this.lastPlacedPos != null && (manhattanDistance = owner.blockPosition().distManhattan((Vec3i)this.lastPlacedPos)) < (minOwnerDistFromLast = 4)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)heldStack.getItem();
        BlockPos found = this.findDarkPlacePosNearOwner(this.ghost.level(), owner, blockItem);
        if (found == null) {
            return false;
        }
        this.targetPlacePos = found.immutable();
        return true;
    }

    public boolean canContinueToUse() {
        if (this.ghost.level().isClientSide) {
            return false;
        }
        if (this.ghost.getMainInteraction() != 1) {
            return false;
        }
        if (this.targetPlacePos == null) {
            return false;
        }
        LivingEntity owner = this.ghost.getOwner();
        if (owner == null) {
            return false;
        }
        if (owner.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.targetPlacePos)) > 36.0) {
            return false;
        }
        ItemStack heldStack = this.ghost.getHoldItem();
        if (!this.isPlaceableBlockItem(heldStack)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)heldStack.getItem();
        return this.isValidPlacement(this.ghost.level(), this.targetPlacePos, blockItem);
    }

    public void start() {
        this.lastRepathTick = this.ghost.tickCount;
        if (this.targetPlacePos == null) {
            return;
        }
        this.moveToTarget();
    }

    public void stop() {
        this.ghost.getNavigation().stop();
        this.targetPlacePos = null;
        int desired = this.ghost.tickCount + this.retryCooldown;
        if (this.nextTryTick < desired) {
            this.nextTryTick = desired;
        }
    }

    public void tick() {
        double placeDistanceSquare;
        if (this.targetPlacePos == null) {
            return;
        }
        LivingEntity owner = this.ghost.getOwner();
        if (owner == null) {
            this.stop();
            return;
        }
        if (!this.ghost.level().getBlockState(this.targetPlacePos).isAir()) {
            this.stop();
            return;
        }
        Vec3 center = Vec3.atCenterOf((Vec3i)this.targetPlacePos);
        if (owner.position().distanceToSqr(center) > 36.0) {
            this.stop();
            return;
        }
        double distSquare = this.ghost.position().distanceToSqr(center);
        if (distSquare <= 9.0) {
            this.ghost.getLookControl().setLookAt(center.x, center.y, center.z);
        }
        if (distSquare <= (placeDistanceSquare = 1.9599999999999997)) {
            this.ghost.getNavigation().stop();
            if (this.canSee(this.targetPlacePos) && this.placeNow(this.targetPlacePos)) {
                this.stop();
            }
            return;
        }
        int ticksPerRepath = 12;
        if (this.ghost.tickCount - this.lastRepathTick >= ticksPerRepath) {
            this.lastRepathTick = this.ghost.tickCount;
            this.moveToTarget();
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    private void moveToTarget() {
        if (this.targetPlacePos == null) {
            return;
        }
        Vec3 movePos = Vec3.atCenterOf((Vec3i)this.targetPlacePos).add(0.0, 0.1, 0.0);
        this.ghost.getNavigation().moveTo(movePos.x, movePos.y, movePos.z, this.approachSpeed);
    }

    private boolean isPlaceableBlockItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (!this.placeables.test(stack)) {
            return false;
        }
        return stack.getItem() instanceof BlockItem;
    }

    private boolean isValidPlacement(Level level, BlockPos placePos, BlockItem blockItem) {
        if (!level.getBlockState(placePos).isAir()) {
            return false;
        }
        if (this.lastPlacedPos != null) {
            int dx = Math.abs(placePos.getX() - this.lastPlacedPos.getX());
            int dy = Math.abs(placePos.getY() - this.lastPlacedPos.getY());
            int dz = Math.abs(placePos.getZ() - this.lastPlacedPos.getZ());
            if (dx <= 1 && dy <= 1 && dz <= 1) {
                return false;
            }
        }
        if (level.getMaxLocalRawBrightness(placePos) > this.minLight) {
            return false;
        }
        BlockPos basePos = placePos.below();
        BlockState baseState = level.getBlockState(basePos);
        if (baseState.isAir()) {
            return false;
        }
        if (!this.preference.test(baseState)) {
            return false;
        }
        return blockItem.getBlock().defaultBlockState().canSurvive((LevelReader)level, placePos);
    }

    private boolean placeNow(BlockPos placePos) {
        ItemStack heldStack = this.ghost.getHoldItem();
        if (!this.isPlaceableBlockItem(heldStack)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)heldStack.getItem();
        if (!this.isValidPlacement(this.ghost.level(), placePos, blockItem)) {
            return false;
        }
        this.ghost.triggerAnim("torch_place_controller", "torch_place");
        this.ghost.level().setBlock(placePos, blockItem.getBlock().defaultBlockState(), 3);
        heldStack.shrink(1);
        if (heldStack.isEmpty()) {
            this.ghost.setHoldItem(ItemStack.EMPTY);
        }
        this.lastPlacedPos = placePos.immutable();
        this.nextTryTick = this.ghost.tickCount + this.retryCooldown;
        return true;
    }

    private boolean canSee(BlockPos placePos) {
        Vec3 targetPosition = Vec3.atCenterOf((Vec3i)placePos);
        BlockHitResult hitResult = this.ghost.level().clip(new ClipContext(this.ghost.getEyePosition(), targetPosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.ghost));
        if (hitResult.getType() == HitResult.Type.MISS) {
            return true;
        }
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = hitResult;
            return blockHitResult.getBlockPos().equals((Object)placePos);
        }
        return false;
    }

    private BlockPos findDarkPlacePosNearOwner(Level level, LivingEntity owner, BlockItem blockItem) {
        Vec3 forward = owner.getDeltaMovement();
        forward = new Vec3(forward.x, 0.0, forward.z);
        if (forward.lengthSqr() < 5.0E-4) {
            Vec3 look = owner.getLookAngle();
            forward = new Vec3(look.x, 0.0, look.z);
        }
        if (forward.lengthSqr() > 1.0E-4) {
            forward = forward.normalize();
        }
        BlockPos bestPosition = null;
        double bestScore = Double.POSITIVE_INFINITY;
        BlockPos centerPosition = owner.blockPosition();
        int searchRadius = 4;
        for (int dx = -searchRadius; dx <= searchRadius; ++dx) {
            for (int dz = -searchRadius; dz <= searchRadius; ++dz) {
                int searchRadiusDown = 4;
                for (int down = 1; down <= searchRadiusDown; ++down) {
                    double score;
                    int light;
                    BlockPos placePosition;
                    BlockPos basePos = centerPosition.offset(dx, -down, dz);
                    BlockState baseState = level.getBlockState(basePos);
                    if (baseState.isAir() || !this.preference.test(baseState) || !level.getBlockState(placePosition = basePos.above()).isAir() || (light = level.getMaxLocalRawBrightness(placePosition)) > this.minLight || !blockItem.getBlock().defaultBlockState().canSurvive((LevelReader)level, placePosition)) continue;
                    Vec3 toPosition = Vec3.atCenterOf((Vec3i)placePosition).subtract(owner.position());
                    Vec3 toPositionFlat = new Vec3(toPosition.x, 0.0, toPosition.z);
                    double distanceToPosition = toPositionFlat.length();
                    double behindPenalty = 0.0;
                    if (forward.lengthSqr() > 1.0E-4 && toPositionFlat.lengthSqr() > 1.0E-4) {
                        double normalized = forward.dot(toPositionFlat.normalize());
                        behindPenalty = (1.0 - normalized) * 2.0;
                    }
                    if (!((score = (double)light * 1000.0 + distanceToPosition * 25.0 + behindPenalty * 200.0) < bestScore)) continue;
                    bestScore = score;
                    bestPosition = placePosition;
                }
            }
        }
        return bestPosition;
    }
}

