/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.generic;

import dev.xylonity.bonsai.ghosts.common.entity.AbstractGhostEntity;
import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class GhostWanderGoal
extends Goal {
    protected final AbstractGhostEntity ghost;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected final double speedModifier;
    protected int interval;
    protected boolean forceTrigger;
    private final boolean checkNoActionTime;
    private final float lerp;
    protected Vec3 targetPos;

    public GhostWanderGoal(AbstractGhostEntity ghost, double speedModifier, int interval, boolean checkNoActionTime, float lerpFactor) {
        this.ghost = ghost;
        this.speedModifier = speedModifier;
        this.interval = interval;
        this.checkNoActionTime = checkNoActionTime;
        this.lerp = lerpFactor;
        this.forceTrigger = false;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public GhostWanderGoal(AbstractGhostEntity ghost, double speedModifier) {
        this(ghost, speedModifier, 120, false, 0.1f);
    }

    public boolean canUse() {
        Vec3 pos;
        if (this.ghost.isVehicle() || this.ghost.isInSittingPose()) {
            return false;
        }
        if (this.ghost.isTame()) {
            boolean allow;
            int inter = this.ghost.getMainInteraction();
            boolean bl = allow = inter == 2 || inter == 1 && this.isOwnerStill();
            if (!allow) {
                return false;
            }
        }
        if (!this.forceTrigger) {
            if (this.checkNoActionTime && this.ghost.getNoActionTime() >= 100) {
                return false;
            }
            if (this.ghost.getRandom().nextInt(GhostWanderGoal.reducedTickDelay((int)this.interval)) != 0) {
                return false;
            }
        }
        if ((pos = this.getPosition()) == null) {
            return false;
        }
        this.wantedX = pos.x;
        this.wantedY = pos.y;
        this.wantedZ = pos.z;
        this.forceTrigger = false;
        return true;
    }

    protected Vec3 getPosition() {
        Vec3 origin = this.ghost.position();
        for (int i = 0; i < 12; ++i) {
            double dx = (this.ghost.getRandom().nextDouble() * 2.0 - 1.0) * 4.0;
            double dz = (this.ghost.getRandom().nextDouble() * 2.0 - 1.0) * 4.0;
            double dy = this.ghost.getRandom().nextDouble() * 2.0 - 1.0;
            Vec3 c = origin.add(dx, dy, dz);
            c = new Vec3(c.x, Mth.clamp((double)c.y, (double)(this.ghost.level().getMinBuildHeight() + 1), (double)(this.ghost.level().getMaxBuildHeight() - 1)), c.z);
            if (!this.isSafePosition(c)) continue;
            return c;
        }
        return null;
    }

    private boolean isSafePosition(Vec3 pos) {
        if (!this.ghost.level().noCollision((Entity)this.ghost, this.ghost.getBoundingBox().move(pos.x - this.ghost.getX(), pos.y - this.ghost.getY(), pos.z - this.ghost.getZ()))) {
            return false;
        }
        BlockPos min = new BlockPos(Mth.floor((double)(pos.x - (double)(this.ghost.getBbWidth() / 2.0f))), Mth.floor((double)pos.y), Mth.floor((double)(pos.z - (double)(this.ghost.getBbWidth() / 2.0f))));
        BlockPos max = new BlockPos(Mth.floor((double)(pos.x + (double)(this.ghost.getBbWidth() / 2.0f))), Mth.floor((double)(pos.y + (double)this.ghost.getBbHeight())), Mth.floor((double)(pos.z + (double)(this.ghost.getBbWidth() / 2.0f))));
        for (BlockPos check : BlockPos.betweenClosed((BlockPos)min, (BlockPos)max)) {
            BlockState state = this.ghost.level().getBlockState(check);
            if (state.isAir() || !state.getFluidState().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void start() {
        this.targetPos = new Vec3(this.wantedX, this.wantedY, this.wantedZ);
        this.ghost.noPhysics = true;
    }

    public boolean canContinueToUse() {
        double dz;
        double dy;
        double dx;
        if (this.ghost.isVehicle() || this.ghost.isInSittingPose() || this.targetPos == null) {
            return false;
        }
        if (this.ghost.isTame()) {
            boolean allow;
            int inter = this.ghost.getMainInteraction();
            boolean bl = allow = inter == 2 || inter == 1 && this.isOwnerStill();
            if (!allow) {
                return false;
            }
        }
        return (dx = this.targetPos.x - this.ghost.getX()) * dx + (dy = this.targetPos.y - this.ghost.getY()) * dy + (dz = this.targetPos.z - this.ghost.getZ()) * dz > 1.0;
    }

    public void tick() {
        if (this.targetPos == null) {
            return;
        }
        this.ghost.lookAt(EntityAnchorArgument.Anchor.EYES, this.targetPos);
        Vec3 delta = this.targetPos.subtract(this.ghost.position());
        double len = delta.length();
        if (len < 0.001) {
            return;
        }
        Vec3 dir = delta.scale(1.0 / len);
        Vec3 vel = dir.scale(this.speedModifier);
        Vec3 cur = this.ghost.getDeltaMovement();
        double vx = Mth.lerp((double)this.lerp, (double)cur.x, (double)vel.x);
        double vy = Mth.lerp((double)this.lerp, (double)cur.y, (double)vel.y);
        double vz = Mth.lerp((double)this.lerp, (double)cur.z, (double)vel.z);
        this.ghost.setDeltaMovement(vx, vy, vz);
    }

    public void stop() {
        this.ghost.noPhysics = false;
        this.targetPos = null;
    }

    private boolean isOwnerStill() {
        LivingEntity owner = this.ghost.getOwner();
        if (owner == null) {
            return false;
        }
        return owner.getDeltaMovement().lengthSqr() < 0.01;
    }
}

