/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.smallghost;

import dev.xylonity.bonsai.ghosts.common.entity.ghost.SmallGhostEntity;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SmallGhostPickupSaplingGoal
extends Goal {
    private final SmallGhostEntity ghost;
    private final double speed;
    private final float lerp;
    private final int scanRadius;
    private int nextScanTick;
    private ItemEntity targetItem;

    public SmallGhostPickupSaplingGoal(SmallGhostEntity ghost, double speed, float lerp, int scanRadius) {
        this.ghost = ghost;
        this.speed = speed;
        this.lerp = lerp;
        this.scanRadius = scanRadius;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.ghost.level().isClientSide) {
            return false;
        }
        if (this.ghost.getIsSleeping()) {
            return false;
        }
        if (!this.ghost.getHoldItem().isEmpty()) {
            return false;
        }
        if (this.ghost.tickCount < this.nextScanTick) {
            return false;
        }
        this.nextScanTick = this.ghost.tickCount + 20;
        this.targetItem = this.findNearestSaplingItem();
        return this.targetItem != null;
    }

    public boolean canContinueToUse() {
        if (this.ghost.level().isClientSide) {
            return false;
        }
        if (this.ghost.getIsSleeping()) {
            return false;
        }
        if (!this.ghost.getHoldItem().isEmpty()) {
            return false;
        }
        if (this.targetItem == null || !this.targetItem.isAlive()) {
            return false;
        }
        ItemStack itemStack = this.targetItem.getItem();
        if (itemStack.isEmpty() || !itemStack.is(ItemTags.SAPLINGS)) {
            return false;
        }
        double max = (double)this.scanRadius + 2.0;
        return this.ghost.distanceToSqr((Entity)this.targetItem) <= max * max;
    }

    public void start() {
        this.ghost.noPhysics = false;
        if (this.ghost.getIsSleeping()) {
            this.ghost.setIsSleeping(false);
        }
        if (this.ghost.getCdFullHide() > 0) {
            this.ghost.setCdFullHide(0);
        }
    }

    public void stop() {
        this.targetItem = null;
        this.ghost.setDeltaMovement(this.ghost.getDeltaMovement().scale(0.6));
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.targetItem == null || !this.targetItem.isAlive()) {
            this.stop();
            return;
        }
        BlockPos blockPos = this.targetItem.blockPosition();
        Vec3 baseTarget = Vec3.atCenterOf((Vec3i)blockPos).add(0.0, 0.15, 0.0);
        this.ghost.getLookControl().setLookAt(baseTarget.x, baseTarget.y, baseTarget.z);
        double pickDistSqr = 1.5625;
        if (this.ghost.position().distanceToSqr(baseTarget) <= pickDistSqr) {
            ItemStack stack = this.targetItem.getItem();
            if (!stack.isEmpty() && stack.is(ItemTags.SAPLINGS) && this.ghost.getHoldItem().isEmpty()) {
                ItemStack pickup = stack.copy();
                pickup.setCount(1);
                if (stack.getCount() > 1) {
                    stack.shrink(1);
                    this.ghost.take((Entity)this.targetItem, 1);
                } else {
                    this.targetItem.discard();
                }
                this.ghost.setHoldItem(pickup);
            }
            this.stop();
            return;
        }
        this.steerSmooth(baseTarget);
    }

    private void steerSmooth(Vec3 target) {
        Vec3 delta = target.subtract(this.ghost.position());
        double distance = delta.length();
        if (distance < 0.001) {
            return;
        }
        double slowRadius = 2.2;
        double speed = this.speed * Mth.clamp((double)(distance / slowRadius), (double)0.15, (double)1.0);
        Vec3 velocity = delta.scale(speed / distance);
        Vec3 currentVelocity = this.ghost.getDeltaMovement();
        this.ghost.setDeltaMovement(Mth.lerp((double)this.lerp, (double)currentVelocity.x, (double)velocity.x), Mth.lerp((double)this.lerp, (double)currentVelocity.y, (double)velocity.y), Mth.lerp((double)this.lerp, (double)currentVelocity.z, (double)velocity.z));
    }

    private ItemEntity findNearestSaplingItem() {
        Vec3 position = this.ghost.position();
        AABB box = new AABB(position.x - (double)this.scanRadius, position.y - (double)this.scanRadius, position.z - (double)this.scanRadius, position.x + (double)this.scanRadius, position.y + (double)this.scanRadius, position.z + (double)this.scanRadius);
        List items = this.ghost.level().getEntitiesOfClass(ItemEntity.class, box, e -> e.isAlive() && !e.getItem().isEmpty() && e.getItem().is(ItemTags.SAPLINGS));
        if (items.isEmpty()) {
            return null;
        }
        return items.stream().min(Comparator.comparingDouble(arg_0 -> ((SmallGhostEntity)this.ghost).distanceToSqr(arg_0))).orElse(null);
    }
}

