/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.smallghost;

import dev.xylonity.bonsai.ghosts.common.entity.ghost.SmallGhostEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SmallGhostPlantSaplingGoal
extends Goal {
    private final SmallGhostEntity ghost;
    private final double speed;
    private final float lerp;
    private final int retryCooldown;
    private final int searchRadius;
    private int nextTryTick;
    private BlockPos targetPlacePos;

    public SmallGhostPlantSaplingGoal(SmallGhostEntity ghost, double speed, float lerp, int retryCooldown, int searchRadius) {
        this.ghost = ghost;
        this.speed = speed;
        this.lerp = lerp;
        this.retryCooldown = Math.max(10, retryCooldown);
        this.searchRadius = Math.max(2, searchRadius);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.ghost.level().isClientSide) {
            return false;
        }
        if (this.ghost.getIsSleeping()) {
            return false;
        }
        if (this.ghost.tickCount < this.nextTryTick) {
            return false;
        }
        ItemStack held = this.ghost.getHoldItem();
        if (!this.isSaplingBlockItem(held)) {
            return false;
        }
        if (this.ghost.getRandom().nextInt(40) != 0) {
            return false;
        }
        BlockPos found = this.findPlantPos();
        if (found == null) {
            return false;
        }
        this.targetPlacePos = found.immutable();
        return true;
    }

    public boolean canContinueToUse() {
        if (this.ghost.level().isClientSide) {
            return false;
        }
        if (this.ghost.getIsSleeping()) {
            return false;
        }
        if (this.targetPlacePos == null) {
            return false;
        }
        ItemStack held = this.ghost.getHoldItem();
        if (!this.isSaplingBlockItem(held)) {
            return false;
        }
        return this.isValidPlacement(this.targetPlacePos, (BlockItem)held.getItem());
    }

    public void start() {
        this.ghost.noPhysics = false;
        if (this.ghost.getIsSleeping()) {
            this.ghost.setIsSleeping(false);
        }
        if (this.ghost.getCdFullHide() > 0) {
            this.ghost.setCdFullHide(0);
        }
    }

    public void stop() {
        this.targetPlacePos = null;
        int desired = this.ghost.tickCount + this.retryCooldown;
        if (this.nextTryTick < desired) {
            this.nextTryTick = desired;
        }
        this.ghost.setDeltaMovement(this.ghost.getDeltaMovement().scale(0.6));
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.targetPlacePos == null) {
            this.stop();
            return;
        }
        ItemStack held = this.ghost.getHoldItem();
        if (!this.isSaplingBlockItem(held)) {
            this.stop();
            return;
        }
        BlockItem blockItem = (BlockItem)held.getItem();
        if (!this.isValidPlacement(this.targetPlacePos, blockItem)) {
            this.stop();
            return;
        }
        Vec3 center = Vec3.atCenterOf((Vec3i)this.targetPlacePos).add(0.0, 0.15, 0.0);
        this.ghost.getLookControl().setLookAt(center.x, center.y, center.z);
        double placeDistSqr = 2.1025;
        if (this.ghost.position().distanceToSqr(center) <= placeDistSqr) {
            this.ghost.level().setBlock(this.targetPlacePos, blockItem.getBlock().defaultBlockState(), 3);
            held.shrink(1);
            if (held.isEmpty()) {
                this.ghost.setHoldItem(ItemStack.EMPTY);
            }
            this.stop();
            return;
        }
        this.steerSmooth(center);
    }

    private void steerSmooth(Vec3 target) {
        Vec3 delta = target.subtract(this.ghost.position());
        double distance = delta.length();
        if (distance < 0.001) {
            return;
        }
        double slowRadius = 2.2;
        double speed = this.speed * Mth.clamp((double)(distance / slowRadius), (double)0.15, (double)1.0);
        Vec3 velocity = delta.scale(speed / distance);
        Vec3 currentVelocity = this.ghost.getDeltaMovement();
        this.ghost.setDeltaMovement(Mth.lerp((double)this.lerp, (double)currentVelocity.x, (double)velocity.x), Mth.lerp((double)this.lerp, (double)currentVelocity.y, (double)velocity.y), Mth.lerp((double)this.lerp, (double)currentVelocity.z, (double)velocity.z));
    }

    private boolean isSaplingBlockItem(ItemStack stack) {
        return !stack.isEmpty() && stack.is(ItemTags.SAPLINGS) && stack.getItem() instanceof BlockItem;
    }

    private boolean isValidPlacement(BlockPos placePos, BlockItem blockItem) {
        if (!this.ghost.level().getBlockState(placePos).isAir()) {
            return false;
        }
        BlockPos basePos = placePos.below();
        BlockState base = this.ghost.level().getBlockState(basePos);
        if (!base.is(Blocks.GRASS_BLOCK) && !base.is(Blocks.DIRT)) {
            return false;
        }
        return blockItem.getBlock().defaultBlockState().canSurvive((LevelReader)this.ghost.level(), placePos);
    }

    private BlockPos findPlantPos() {
        BlockPos origin = this.ghost.blockPosition();
        for (int i = 0; i < 32; ++i) {
            int dx = this.ghost.getRandom().nextInt(-this.searchRadius, this.searchRadius + 1);
            int dz = this.ghost.getRandom().nextInt(-this.searchRadius, this.searchRadius + 1);
            for (int down = 0; down <= 5; ++down) {
                BlockItem blockItem;
                ItemStack held;
                Item item;
                BlockPos basePos = origin.offset(dx, -down, dz);
                BlockState base = this.ghost.level().getBlockState(basePos);
                if (!base.is(Blocks.GRASS_BLOCK) && !base.is(Blocks.DIRT)) continue;
                BlockPos placePos = basePos.above();
                if (!this.ghost.level().getBlockState(placePos).isAir() || !((item = (held = this.ghost.getHoldItem()).getItem()) instanceof BlockItem) || !(blockItem = (BlockItem)item).getBlock().defaultBlockState().canSurvive((LevelReader)this.ghost.level(), placePos)) continue;
                return placePos;
            }
        }
        return null;
    }
}

