/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.smallghost;

import dev.xylonity.bonsai.ghosts.common.entity.ghost.SmallGhostEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SmallGhostTakeSaplingBlockGoal
extends Goal {
    private final SmallGhostEntity ghost;
    private final int scanRadius;
    private final double speed;
    private final float lerp;
    private int nextScanTick;
    private BlockPos targetPos;

    public SmallGhostTakeSaplingBlockGoal(SmallGhostEntity ghost, int scanRadius, double speed, float lerp) {
        this.ghost = ghost;
        this.scanRadius = Math.max(2, scanRadius);
        this.speed = speed;
        this.lerp = lerp;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.ghost.level().isClientSide) {
            return false;
        }
        if (!this.ghost.getHoldItem().isEmpty()) {
            return false;
        }
        if (this.ghost.getIsSleeping()) {
            return false;
        }
        if (this.ghost.tickCount < this.nextScanTick) {
            return false;
        }
        this.nextScanTick = this.ghost.tickCount + 20;
        this.targetPos = this.findSaplingBlock();
        return this.targetPos != null;
    }

    public boolean canContinueToUse() {
        if (this.ghost.level().isClientSide) {
            return false;
        }
        if (!this.ghost.getHoldItem().isEmpty()) {
            return false;
        }
        if (this.ghost.getIsSleeping()) {
            return false;
        }
        if (this.targetPos == null) {
            return false;
        }
        BlockState st = this.ghost.level().getBlockState(this.targetPos);
        if (!st.is(BlockTags.SAPLINGS)) {
            return false;
        }
        double max = (double)this.scanRadius + 2.0;
        return this.ghost.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.targetPos)) <= max * max;
    }

    public void start() {
        this.ghost.noPhysics = false;
        if (this.ghost.getIsSleeping()) {
            this.ghost.setIsSleeping(false);
        }
        if (this.ghost.getCdFullHide() > 0) {
            this.ghost.setCdFullHide(0);
        }
    }

    public void stop() {
        this.targetPos = null;
        this.ghost.setDeltaMovement(this.ghost.getDeltaMovement().scale(0.6));
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.targetPos == null) {
            this.stop();
            return;
        }
        BlockState blockState = this.ghost.level().getBlockState(this.targetPos);
        if (!blockState.is(BlockTags.SAPLINGS)) {
            this.stop();
            return;
        }
        Vec3 center = Vec3.atCenterOf((Vec3i)this.targetPos).add(0.0, 0.15, 0.0);
        this.ghost.getLookControl().setLookAt(center.x, center.y, center.z);
        double takeDistSqr = 1.8225000000000002;
        if (this.ghost.position().distanceToSqr(center) <= takeDistSqr) {
            this.ghost.setHoldItem(new ItemStack((ItemLike)blockState.getBlock().asItem()));
            this.ghost.level().setBlock(this.targetPos, Blocks.AIR.defaultBlockState(), 3);
            this.stop();
            return;
        }
        this.steerSmooth(center);
    }

    private void steerSmooth(Vec3 target) {
        Vec3 delta = target.subtract(this.ghost.position());
        double distance = delta.length();
        if (distance < 0.001) {
            return;
        }
        double slowRadius = 2.2;
        double speed = this.speed * Mth.clamp((double)(distance / slowRadius), (double)0.15, (double)1.0);
        Vec3 velocity = delta.scale(speed / distance);
        Vec3 currentVelocity = this.ghost.getDeltaMovement();
        this.ghost.setDeltaMovement(Mth.lerp((double)this.lerp, (double)currentVelocity.x, (double)velocity.x), Mth.lerp((double)this.lerp, (double)currentVelocity.y, (double)velocity.y), Mth.lerp((double)this.lerp, (double)currentVelocity.z, (double)velocity.z));
    }

    private BlockPos findSaplingBlock() {
        BlockPos origin = this.ghost.blockPosition();
        BlockPos best = null;
        double bestDist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < 48; ++i) {
            double distance;
            int dx = this.ghost.getRandom().nextInt(-this.scanRadius, this.scanRadius + 1);
            int dz = this.ghost.getRandom().nextInt(-this.scanRadius, this.scanRadius + 1);
            int dy = this.ghost.getRandom().nextInt(-3, 4);
            BlockPos blockPos = origin.offset(dx, dy, dz);
            BlockState blockState = this.ghost.level().getBlockState(blockPos);
            if (!blockState.is(BlockTags.SAPLINGS) || !((distance = this.ghost.position().distanceToSqr(Vec3.atCenterOf((Vec3i)blockPos))) < bestDist)) continue;
            bestDist = distance;
            best = blockPos.immutable();
        }
        return best;
    }
}

