/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.kodama;

import dev.xylonity.bonsai.ghosts.common.entity.PassiveEntity;
import dev.xylonity.bonsai.ghosts.registry.GhostsBlocks;
import dev.xylonity.bonsai.ghosts.registry.GhostsSounds;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class KodamaEntity
extends PassiveEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation RATTLE = RawAnimation.begin().thenPlay("rattle");
    private final RawAnimation RATTLE_2 = RawAnimation.begin().thenPlay("rattle_2");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation BARTER = RawAnimation.begin().thenPlay("barter");
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(KodamaEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> RATTLING_TICKS = SynchedEntityData.defineId(KodamaEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BARTER_TICKS = SynchedEntityData.defineId(KodamaEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int ANIMATION_RATTLING_TICKS = 38;
    private static final int ANIMATION_BARTER_TICKS = 50;
    private float flashAlpha;
    private int rattleAnimationType;

    public KodamaEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.noCulling = true;
        this.flashAlpha = 0.0f;
        this.setCanPickUpLoot(true);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return AbstractGolem.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.FLYING_SPEED, (double)0.3f).add(Attributes.MOVEMENT_SPEED, (double)0.24f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5){

            public void start() {
                super.start();
                if (KodamaEntity.this.isBartering()) {
                    KodamaEntity.this.setBarterTicks(0);
                    KodamaEntity.this.spawnAtLocation(new ItemStack((ItemLike)Items.AMETHYST_SHARD));
                    KodamaEntity.this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                }
            }
        });
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                if (KodamaEntity.this.isBartering() || KodamaEntity.this.getRattlingTicks() > 0) {
                    return false;
                }
                return super.canUse();
            }

            public boolean canContinueToUse() {
                if (KodamaEntity.this.isBartering() || KodamaEntity.this.getRattlingTicks() > 0) {
                    return false;
                }
                return super.canContinueToUse();
            }
        });
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f, 1.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)0);
        builder.define(RATTLING_TICKS, (Object)0);
        builder.define(BARTER_TICKS, (Object)0);
    }

    public void setFlashAlpha(float flashAlpha) {
        this.flashAlpha = flashAlpha;
    }

    public float getFlashAlpha() {
        return this.flashAlpha;
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setRattlingTicks(int variant) {
        this.entityData.set(RATTLING_TICKS, (Object)variant);
    }

    public int getRattlingTicks() {
        return (Integer)this.entityData.get(RATTLING_TICKS);
    }

    public void setBarterTicks(int ticks) {
        this.entityData.set(BARTER_TICKS, (Object)ticks);
    }

    public int getBarterTicks() {
        return (Integer)this.entityData.get(BARTER_TICKS);
    }

    public boolean isBartering() {
        return this.getBarterTicks() > 0;
    }

    protected boolean shouldPanic() {
        return this.getLastHurtByMob() != null || this.isFreezing() || this.isOnFire();
    }

    public boolean wantsToPickUp(ItemStack stack) {
        if (this.isBartering() || this.getRattlingTicks() > 0 || this.shouldPanic() || !this.onGround()) {
            return false;
        }
        if (!this.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty()) {
            return false;
        }
        return stack.is(Items.AMETHYST_SHARD);
    }

    protected void pickUpItem(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.getItem();
        boolean isAmethyst = stack.is(Items.AMETHYST_SHARD);
        if (!this.level().isClientSide && isAmethyst && stack.getCount() > 1) {
            ItemStack one = stack.split(1);
            itemEntity.setItem(stack);
            this.setItemSlot(EquipmentSlot.MAINHAND, one);
            if (!this.isBartering()) {
                this.setBarterTicks(1);
                this.level().playSound(null, this.blockPosition(), GhostsSounds.KODAMA_IDLE.get(), SoundSource.NEUTRAL, 0.7f, 1.2f);
            }
            return;
        }
        boolean wasAmethyst = stack.is(Items.AMETHYST_SHARD);
        super.pickUpItem(itemEntity);
        if (!this.level().isClientSide && wasAmethyst) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.AMETHYST_SHARD));
            if (!this.isBartering()) {
                this.setBarterTicks(1);
                this.level().playSound(null, this.blockPosition(), GhostsSounds.KODAMA_IDLE.get(), SoundSource.NEUTRAL, 0.7f, 1.2f);
            }
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack inHand = player.getItemInHand(hand);
        if (inHand.is(Items.AMETHYST_SHARD)) {
            if (this.isBartering()) {
                return InteractionResult.SUCCESS;
            }
            if (!this.level().isClientSide) {
                if (!player.getAbilities().instabuild) {
                    inHand.shrink(1);
                }
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.AMETHYST_SHARD));
                this.setBarterTicks(1);
                this.level().playSound(null, this.blockPosition(), GhostsSounds.KODAMA_IDLE.get(), SoundSource.NEUTRAL, 0.7f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void tick() {
        Vec3 currentPos = this.position();
        super.tick();
        if (!this.level().isClientSide) {
            boolean ok;
            long dayTime = this.level().getDayTime() % 24000L;
            if (!this.shouldPanic() && this.getRattlingTicks() <= 0) {
                if (dayTime >= 13000L && dayTime <= 13200L) {
                    this.startRattling(0.1f);
                } else {
                    this.startRattling(0.001f);
                }
            }
            boolean bl = ok = !this.shouldPanic() && this.getRattlingTicks() > 0 && this.onGround();
            if (!ok) {
                this.setRattlingTicks(0);
            }
            if (this.getRattlingTicks() > 0) {
                this.setRattlingTicks(this.getRattlingTicks() - 1);
            }
            if (this.getBarterTicks() > 0) {
                this.setBarterTicks(this.getBarterTicks() + 1);
            }
            if (this.getBarterTicks() == 50) {
                this.doBarter();
                this.setBarterTicks(0);
            }
        }
    }

    private void doBarter() {
        this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        ItemStack sapling = this.getRandomSaplingStack();
        if (!sapling.isEmpty()) {
            this.spawnAtLocation(sapling, 0.35f);
            this.level().playSound(null, this.blockPosition(), GhostsSounds.KODAMA_RATTLE.get(), SoundSource.NEUTRAL, 0.8f, 1.0f);
        } else {
            this.spawnAtLocation(new ItemStack((ItemLike)GhostsBlocks.HAUNTED_SAPLING.get()), 0.35f);
        }
    }

    private ItemStack getRandomSaplingStack() {
        ArrayList items = new ArrayList();
        BuiltInRegistries.ITEM.getTag(ItemTags.SAPLINGS).ifPresent(named -> named.forEach(holder -> {
            Item item = (Item)holder.value();
            if (item == Items.AZALEA || item == Items.FLOWERING_AZALEA) {
                return;
            }
            items.add(item);
        }));
        if (items.isEmpty()) {
            return ItemStack.EMPTY;
        }
        Item picked = (Item)items.get(this.level().random.nextInt(items.size()));
        return new ItemStack((ItemLike)picked);
    }

    private void startRattling(float chance) {
        if (this.level().random.nextFloat() > chance) {
            return;
        }
        this.setRattlingTicks(38);
        this.level().playSound(null, this.blockPosition(), GhostsSounds.KODAMA_RATTLE.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Variant")) {
            this.setVariant(compound.getInt("Variant"));
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Variant", this.getVariant());
    }

    public static boolean checkKodamaSpawnRules(EntityType<? extends Animal> kodama, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return KodamaEntity.isDarkEnoughToSpawn(level, pos, random) && KodamaEntity.checkMobSpawnRules(kodama, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor level, BlockPos pos, RandomSource random) {
        if (level.getBrightness(LightLayer.SKY, pos) > random.nextInt(32)) {
            return false;
        }
        DimensionType dimensiontype = level.dimensionType();
        int i = dimensiontype.monsterSpawnBlockLightLimit();
        if (i < 15 && level.getBrightness(LightLayer.BLOCK, pos) > i) {
            return false;
        }
        int j = level.getLevel().isThundering() ? level.getMaxLocalRawBrightness(pos, 10) : level.getMaxLocalRawBrightness(pos);
        return j <= dimensiontype.monsterSpawnLightTest().sample(random);
    }

    protected int getBaseExperienceReward() {
        return this.level().random.nextInt(4) + 2;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (this.getVariant() == 0) {
            this.setVariant(level.getLevel().random.nextInt(4) + 1);
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    protected SoundEvent getAmbientSound() {
        return GhostsSounds.KODAMA_IDLE.get();
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getRattlingTicks() == 37) {
            this.rattleAnimationType = this.level().random.nextInt(2);
        }
        if (this.getBarterTicks() > 0) {
            event.setAnimation(this.BARTER);
        } else if (this.getRattlingTicks() > 0) {
            event.setAnimation(this.rattleAnimationType == 0 ? this.RATTLE : this.RATTLE_2);
        } else if (event.isMoving()) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

