/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.event;

import dev.xylonity.bonsai.ghosts.common.entity.AbstractGhostEntity;
import dev.xylonity.bonsai.ghosts.util.GhostOwnerTracker;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber(modid="ghosts", bus=EventBusSubscriber.Bus.GAME)
public class GhostsCommonEvents {
    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        Player player;
        Level level;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (level = (player = (Player)livingEntity).level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AbstractGhostEntity ghost = GhostOwnerTracker.getInstance().findGhostWithTotem(serverLevel, player.getUUID());
            if (ghost != null) {
                GhostsCommonEvents.defaultTotemBehavior((LivingEntity)player);
                ghost.getMainHandItem().shrink(1);
                event.setCanceled(true);
            }
        }
    }

    private static void defaultTotemBehavior(LivingEntity entity) {
        entity.setHealth(1.0f);
        entity.removeAllEffects();
        entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
        entity.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
        entity.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
        entity.level().broadcastEntityEvent((Entity)entity, (byte)35);
    }
}

