/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.event;

import dev.xylonity.bonsai.ghosts.common.datagen.GhostsWorldgenProvider;
import dev.xylonity.bonsai.ghosts.common.entity.ghost.GhostEntity;
import dev.xylonity.bonsai.ghosts.common.entity.ghost.SmallGhostEntity;
import dev.xylonity.bonsai.ghosts.common.entity.kodama.KodamaEntity;
import dev.xylonity.bonsai.ghosts.registry.GhostsBlocks;
import dev.xylonity.bonsai.ghosts.registry.GhostsEntities;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class GhostsServerEvents {

    @EventBusSubscriber(modid="ghosts", bus=EventBusSubscriber.Bus.GAME)
    public static class GhostsServerForgeEvents {
        @SubscribeEvent
        public static void onBlockToolModification(BlockEvent.BlockToolModificationEvent event) {
            if (event.getItemAbility() == ItemAbilities.AXE_STRIP) {
                if (event.getState().is(GhostsBlocks.HAUNTED_LOG.get())) {
                    event.setFinalState(GhostsBlocks.STRIPPED_HAUNTED_LOG.get().defaultBlockState());
                }
                if (event.getState().is(GhostsBlocks.HAUNTED_EYE_LOG.get())) {
                    event.setFinalState(GhostsBlocks.STRIPPED_HAUNTED_LOG.get().defaultBlockState());
                }
            }
        }
    }

    @EventBusSubscriber(modid="ghosts", bus=EventBusSubscriber.Bus.MOD)
    public static class GhostsServerModEvents {
        @SubscribeEvent
        public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
            event.put(GhostsEntities.GHOST.get(), GhostEntity.setAttributes().build());
            event.put(GhostsEntities.SMALL_GHOST.get(), SmallGhostEntity.setAttributes().build());
            event.put(GhostsEntities.KODAMA.get(), KodamaEntity.setAttributes().build());
        }

        @SubscribeEvent
        public static void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
            event.register(GhostsEntities.GHOST.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
            event.register(GhostsEntities.SMALL_GHOST.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
            event.register(GhostsEntities.KODAMA.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, KodamaEntity::checkKodamaSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        }

        @SubscribeEvent
        public static void gatherData(GatherDataEvent event) {
            DataGenerator generator = event.getGenerator();
            PackOutput packOutput = generator.getPackOutput();
            CompletableFuture lookupProvider = event.getLookupProvider();
            generator.addProvider(event.includeServer(), (DataProvider)new GhostsWorldgenProvider(packOutput, lookupProvider));
        }
    }
}

