/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.configurations.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xylonity.bonsai.ghosts.registry.GhostsBlocks;
import dev.xylonity.bonsai.ghosts.registry.GhostsFoliagePlacers;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class HauntedFoliagePlacer
extends BlobFoliagePlacer {
    public static final MapCodec<HauntedFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> HauntedFoliagePlacer.blobParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, HauntedFoliagePlacer::new));

    public HauntedFoliagePlacer(IntProvider radius, IntProvider offset, int height) {
        super(radius, offset, height);
    }

    protected FoliagePlacerType<?> type() {
        return GhostsFoliagePlacers.HAUNTED_FOLIAGE.get();
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        int baseRadius = foliageRadius + attachment.radiusOffset();
        this.placeLeavesRow(level, blockSetter, random, config, attachment.pos(), baseRadius, -1, attachment.doubleTrunk());
        this.placeLeavesRow(level, blockSetter, random, config, attachment.pos(), baseRadius, 0, attachment.doubleTrunk());
        int topRadius = Math.max(baseRadius - 1, 0);
        this.placeLeavesRow(level, blockSetter, random, config, attachment.pos(), topRadius, 1, attachment.doubleTrunk());
        BlockPos centerPos = attachment.pos();
        for (int i = -1; i <= 0; ++i) {
            BlockPos layerPos = centerPos.above(i);
            for (int x = -baseRadius; x <= baseRadius; ++x) {
                for (int z = -baseRadius; z <= baseRadius; ++z) {
                    BlockPos hangingPos;
                    int distance = Math.max(Math.abs(x), Math.abs(z));
                    if (distance != baseRadius) continue;
                    BlockPos leafPos = layerPos.offset(x, 0, z);
                    if (!(random.nextFloat() < 0.25f) || !level.isStateAtPosition(leafPos, state -> state.is(config.foliageProvider.getState(random, leafPos).getBlock()))) continue;
                    int hangingLength = 1 + random.nextInt(2);
                    for (int h = 1; h <= hangingLength && level.isStateAtPosition(hangingPos = leafPos.below(h), BlockBehaviour.BlockStateBase::isAir); ++h) {
                        blockSetter.set(hangingPos, GhostsBlocks.HAUNTED_LEAVES.get().defaultBlockState());
                    }
                }
            }
        }
    }
}

