/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.configurations.tree;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xylonity.bonsai.ghosts.registry.GhostsBlocks;
import dev.xylonity.bonsai.ghosts.registry.GhostsTrunkPlacerTypes;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class HauntedTrunkPlacer
extends StraightTrunkPlacer {
    public static final MapCodec<HauntedTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> HauntedTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, HauntedTrunkPlacer::new));
    private boolean hasSpawnedEye = false;

    public HauntedTrunkPlacer(int i, int j, int k) {
        super(i, j, k);
    }

    protected TrunkPlacerType<?> type() {
        return GhostsTrunkPlacerTypes.HAUNTED_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos pos, TreeConfiguration config) {
        HauntedTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.below(), (TreeConfiguration)config);
        for (int i = 0; i < freeTreeHeight; ++i) {
            BlockPos currentPosition = pos.above(i);
            if (random.nextFloat() < 0.2f && !this.hasSpawnedEye) {
                blockSetter.accept(currentPosition, GhostsBlocks.HAUNTED_EYE_LOG.get().defaultBlockState());
                this.hasSpawnedEye = true;
                continue;
            }
            this.placeLog(level, blockSetter, random, currentPosition, config);
        }
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(pos.above(freeTreeHeight), 0, false));
    }
}

