/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.platform;

import com.mojang.serialization.MapCodec;
import dev.xylonity.bonsai.ghosts.Ghosts;
import dev.xylonity.bonsai.ghosts.GhostsNeoForge;
import dev.xylonity.bonsai.ghosts.platform.GhostsPlatform;
import dev.xylonity.bonsai.ghosts.registry.GhostsBlockEntities;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.registries.DeferredHolder;

public class GhostsPlatformNeoforge
implements GhostsPlatform {
    @Override
    public <X extends Item> Supplier<X> registerItem(String id, Supplier<X> item) {
        return GhostsNeoForge.ITEMS.register(id, item);
    }

    @Override
    public <X extends Block> Supplier<X> registerBlock(String id, Supplier<X> block, boolean registerItem) {
        DeferredHolder blockSupplier = GhostsNeoForge.BLOCKS.register(id, block);
        if (registerItem) {
            this.registerItem(id, () -> GhostsPlatformNeoforge.lambda$registerBlock$0((Supplier)blockSupplier));
        }
        return blockSupplier;
    }

    @Override
    public <T extends ParticleType<?>> Supplier<T> registerParticle(String id, boolean overrideLimiter) {
        return GhostsNeoForge.PARTICLES.register(id, () -> new SimpleParticleType(overrideLimiter));
    }

    @Override
    public <X extends BlockEntity> Supplier<BlockEntityType<X>> registerBlockEntity(String id, GhostsBlockEntities.BlockEntityFactory<X> supplier, Supplier<Block> ... blocks) {
        return GhostsNeoForge.BLOCKENTITIES.register(id, () -> {
            Block[] blockArray = (Block[])Arrays.stream(blocks).map(Supplier::get).toArray(Block[]::new);
            return BlockEntityType.Builder.of(supplier::create, (Block[])blockArray).build(null);
        });
    }

    @Override
    public <X extends CreativeModeTab> Supplier<X> registerCreativeTab(String id, Supplier<X> creativeModeTab) {
        return GhostsNeoForge.CREATIVE_TABS.register(id, creativeModeTab);
    }

    @Override
    public <T extends Item, X extends LivingEntity> Supplier<T> registerSpawnEgg(String id, Supplier<? extends EntityType<? extends Mob>> entity, int color1, int color2, Item.Properties properties) {
        return this.registerItem(id, () -> new DeferredSpawnEggItem(entity, color1, color2, properties));
    }

    @Override
    public <X extends Entity> Supplier<EntityType<X>> registerEntity(String name, EntityType.EntityFactory<X> entity, MobCategory category, float width, float height, @Nullable List<Consumer<EntityType.Builder<X>>> properties) {
        return GhostsNeoForge.ENTITIES.register(name, () -> {
            EntityType.Builder builder = EntityType.Builder.of((EntityType.EntityFactory)entity, (MobCategory)category).sized(width, height);
            if (properties != null) {
                for (Consumer property : properties) {
                    property.accept(builder);
                }
            }
            return builder.build(Ghosts.of(name).toString());
        });
    }

    @Override
    public <X extends SoundEvent> Supplier<X> registerSound(String id, Supplier<X> sound) {
        return GhostsNeoForge.SOUNDS.register(id, sound);
    }

    @Override
    public <U extends TrunkPlacer> Supplier<TrunkPlacerType<U>> registerTrunkPlacer(String id, MapCodec<U> codec) {
        return GhostsNeoForge.TRUNK_PLACER_TYPES.register(id, () -> new TrunkPlacerType(codec));
    }

    @Override
    public <U extends FoliagePlacer> Supplier<FoliagePlacerType<U>> registerFoliagePlacer(String id, MapCodec<U> codec) {
        return GhostsNeoForge.FOLIAGE_TYPES.register(id, () -> new FoliagePlacerType(codec));
    }

    @Override
    public WoodType registerWoodType(ResourceLocation id, BlockSetType setType) {
        WoodType type = new WoodType(id.toString(), setType);
        WoodType.register((WoodType)type);
        return type;
    }

    @Override
    public CreativeModeTab.Builder creativeTabBuilder() {
        return CreativeModeTab.builder();
    }

    private static /* synthetic */ BlockItem lambda$registerBlock$0(Supplier blockSupplier) {
        return new BlockItem((Block)blockSupplier.get(), new Item.Properties());
    }
}

