/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.client.entity.render;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import dev.xylonity.bonsai.ghosts.Ghosts;
import dev.xylonity.bonsai.ghosts.common.entity.boat.HauntedBoat;
import dev.xylonity.bonsai.ghosts.common.entity.boat.HauntedChestBoat;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1690;
import net.minecraft.class_2960;
import net.minecraft.class_4595;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_630;
import net.minecraft.class_7752;
import net.minecraft.class_881;

public class HauntedBoatRenderer
extends class_881 {
    private final Map<HauntedBoat.Type, Pair<class_2960, class_4595<class_1690>>> boatResources = (Map)Stream.of(HauntedBoat.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)Ghosts.of(HauntedBoatRenderer.getTextureLocation(type, chestBoat)), this.createBoatModel(context, (HauntedBoat.Type)((Object)type), chestBoat))));

    public HauntedBoatRenderer(class_5617.class_5618 context, boolean chestBoat) {
        super(context, chestBoat);
    }

    private static String getTextureLocation(HauntedBoat.Type pType, boolean pChestBoat) {
        return pChestBoat ? "textures/entity/chest_boat/" + pType.getName() + ".png" : "textures/entity/boat/" + pType.getName() + ".png";
    }

    private class_4595<class_1690> createBoatModel(class_5617.class_5618 pContext, HauntedBoat.Type pType, boolean pChestBoat) {
        class_5601 modellayerlocation = pChestBoat ? HauntedBoatRenderer.createChestBoatModelName(pType) : HauntedBoatRenderer.createBoatModelName(pType);
        class_630 modelpart = pContext.method_32167(modellayerlocation);
        return pChestBoat ? new class_7752(modelpart) : new class_554(modelpart);
    }

    public static class_5601 createBoatModelName(HauntedBoat.Type pType) {
        return HauntedBoatRenderer.createLocation("boat/" + pType.getName(), "main");
    }

    public static class_5601 createChestBoatModelName(HauntedBoat.Type pType) {
        return HauntedBoatRenderer.createLocation("chest_boat/" + pType.getName(), "main");
    }

    private static class_5601 createLocation(String pPath, String pModel) {
        return new class_5601(Ghosts.of(pPath), pModel);
    }

    public Pair<class_2960, class_4595<class_1690>> getModelWithLocation(class_1690 rawBoat) {
        if (rawBoat instanceof HauntedBoat) {
            HauntedBoat boat = (HauntedBoat)rawBoat;
            return this.boatResources.get((Object)boat.getBoatVariant());
        }
        if (rawBoat instanceof HauntedChestBoat) {
            HauntedChestBoat boat = (HauntedChestBoat)rawBoat;
            return this.boatResources.get((Object)boat.getBoatVariant());
        }
        return null;
    }
}

