/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xylonity.bonsai.ghosts.common.blockentity.CalibratedHauntedEyeBlockEntity;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class CalibratedHauntedEyeBlock
extends class_2318
implements class_2343 {
    public static final class_2758 POWER = class_2741.field_12511;
    private static final double MAX_DETECTION_DISTANCE = 15.0;
    public static final MapCodec<class_2318> CODEC = RecordCodecBuilder.mapCodec(blockInstance -> blockInstance.group((App)CalibratedHauntedEyeBlock.method_54096()).apply((Applicative)blockInstance, CalibratedHauntedEyeBlock::new));

    public CalibratedHauntedEyeBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)field_10927, (Comparable)class_2350.field_11043)).method_11657((class_2769)POWER, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends class_2318> method_53969() {
        return CODEC;
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_10927, (Comparable)ctx.method_7715().method_10153().method_10153())).method_11657((class_2769)POWER, (Comparable)Integer.valueOf(0));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_10927, POWER});
    }

    public void method_9615(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState, boolean isMoving) {
        if (!level.field_9236) {
            level.method_39279(pos, (class_2248)this, 1);
        }
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        int currentPower;
        int newPower = this.calculatePowerLevel((class_1937)level, pos, state);
        if (newPower != (currentPower = ((Integer)state.method_11654((class_2769)POWER)).intValue())) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)POWER, (Comparable)Integer.valueOf(newPower)), 3);
            this.updateNeighbors((class_1937)level, pos, state);
        }
        level.method_39279(pos, (class_2248)this, 1);
    }

    private int calculatePowerLevel(class_1937 level, class_2338 pos, class_2680 state) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)field_10927);
        class_243 eyePos = class_243.method_24953((class_2382)pos);
        class_243 lookDirection = class_243.method_24954((class_2382)facing.method_10163());
        List entities = level.method_8390(class_1309.class, this.createSearchArea(pos, facing), entity -> !entity.method_7325());
        if (entities.isEmpty()) {
            return 0;
        }
        double closestDistance = 16.0;
        for (class_1297 entity2 : entities) {
            double distance;
            class_243 entityPos = entity2.method_19538();
            class_243 toEntity = entityPos.method_1020(eyePos);
            double dotProduct = toEntity.method_1029().method_1026(lookDirection);
            if (!(dotProduct > 0.5) || !((distance = eyePos.method_1022(entityPos)) < closestDistance)) continue;
            closestDistance = distance;
        }
        if (closestDistance > 15.0) {
            return 0;
        }
        int power = (int)Math.ceil(15.0 - closestDistance / 15.0 * 14.0);
        return Math.max(1, Math.min(15, power));
    }

    private class_238 createSearchArea(class_2338 pos, class_2350 facing) {
        class_243 center = class_243.method_24953((class_2382)pos);
        double expand = 3.0;
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11043 -> new class_238(center.field_1352 - 3.0, center.field_1351 - 3.0, center.field_1350 - 15.0, center.field_1352 + 3.0, center.field_1351 + 3.0, center.field_1350);
            case class_2350.field_11035 -> new class_238(center.field_1352 - 3.0, center.field_1351 - 3.0, center.field_1350, center.field_1352 + 3.0, center.field_1351 + 3.0, center.field_1350 + 15.0);
            case class_2350.field_11039 -> new class_238(center.field_1352 - 15.0, center.field_1351 - 3.0, center.field_1350 - 3.0, center.field_1352, center.field_1351 + 3.0, center.field_1350 + 3.0);
            case class_2350.field_11034 -> new class_238(center.field_1352, center.field_1351 - 3.0, center.field_1350 - 3.0, center.field_1352 + 15.0, center.field_1351 + 3.0, center.field_1350 + 3.0);
            case class_2350.field_11036 -> new class_238(center.field_1352 - 3.0, center.field_1351, center.field_1350 - 3.0, center.field_1352 + 3.0, center.field_1351 + 15.0, center.field_1350 + 3.0);
            case class_2350.field_11033 -> new class_238(center.field_1352 - 3.0, center.field_1351 - 15.0, center.field_1350 - 3.0, center.field_1352 + 3.0, center.field_1351, center.field_1350 + 3.0);
        };
    }

    private void updateNeighbors(class_1937 level, class_2338 pos, class_2680 state) {
        class_2350 out = (class_2350)state.method_11654((class_2769)field_10927);
        class_2338 target = pos.method_10093(out);
        level.method_8492(target, (class_2248)this, pos);
        level.method_8508(target, (class_2248)this, out.method_10153());
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public int method_9524(class_2680 state, class_1922 level, class_2338 pos, class_2350 side) {
        return side == state.method_11654((class_2769)field_10927) ? (Integer)state.method_11654((class_2769)POWER) : 0;
    }

    public int method_9603(class_2680 state, class_1922 level, class_2338 pos, class_2350 side) {
        return this.method_9524(state, level, pos, side);
    }

    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return new CalibratedHauntedEyeBlockEntity(blockPos, blockState);
    }
}

