/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.smallghost;

import dev.xylonity.bonsai.ghosts.common.entity.ghost.SmallGhostEntity;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1352;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3489;
import net.minecraft.class_3532;

public class SmallGhostPickupSaplingGoal
extends class_1352 {
    private final SmallGhostEntity ghost;
    private final double speed;
    private final float lerp;
    private final int scanRadius;
    private int nextScanTick;
    private class_1542 targetItem;

    public SmallGhostPickupSaplingGoal(SmallGhostEntity ghost, double speed, float lerp, int scanRadius) {
        this.ghost = ghost;
        this.speed = speed;
        this.lerp = lerp;
        this.scanRadius = scanRadius;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (this.ghost.method_37908().field_9236) {
            return false;
        }
        if (this.ghost.getIsSleeping()) {
            return false;
        }
        if (!this.ghost.getHoldItem().method_7960()) {
            return false;
        }
        if (this.ghost.field_6012 < this.nextScanTick) {
            return false;
        }
        this.nextScanTick = this.ghost.field_6012 + 20;
        this.targetItem = this.findNearestSaplingItem();
        return this.targetItem != null;
    }

    public boolean method_6266() {
        if (this.ghost.method_37908().field_9236) {
            return false;
        }
        if (this.ghost.getIsSleeping()) {
            return false;
        }
        if (!this.ghost.getHoldItem().method_7960()) {
            return false;
        }
        if (this.targetItem == null || !this.targetItem.method_5805()) {
            return false;
        }
        class_1799 itemStack = this.targetItem.method_6983();
        if (itemStack.method_7960() || !itemStack.method_31573(class_3489.field_15528)) {
            return false;
        }
        double max = (double)this.scanRadius + 2.0;
        return this.ghost.method_5858((class_1297)this.targetItem) <= max * max;
    }

    public void method_6269() {
        this.ghost.field_5960 = false;
        if (this.ghost.getIsSleeping()) {
            this.ghost.setIsSleeping(false);
        }
        if (this.ghost.getCdFullHide() > 0) {
            this.ghost.setCdFullHide(0);
        }
    }

    public void method_6270() {
        this.targetItem = null;
        this.ghost.method_18799(this.ghost.method_18798().method_1021(0.6));
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        if (this.targetItem == null || !this.targetItem.method_5805()) {
            this.method_6270();
            return;
        }
        class_2338 blockPos = this.targetItem.method_24515();
        class_243 baseTarget = class_243.method_24953((class_2382)blockPos).method_1031(0.0, 0.15, 0.0);
        this.ghost.method_5988().method_20248(baseTarget.field_1352, baseTarget.field_1351, baseTarget.field_1350);
        double pickDistSqr = 1.5625;
        if (this.ghost.method_19538().method_1025(baseTarget) <= pickDistSqr) {
            class_1799 stack = this.targetItem.method_6983();
            if (!stack.method_7960() && stack.method_31573(class_3489.field_15528) && this.ghost.getHoldItem().method_7960()) {
                class_1799 pickup = stack.method_7972();
                pickup.method_7939(1);
                if (stack.method_7947() > 1) {
                    stack.method_7934(1);
                    this.ghost.method_6103((class_1297)this.targetItem, 1);
                } else {
                    this.targetItem.method_31472();
                }
                this.ghost.setHoldItem(pickup);
            }
            this.method_6270();
            return;
        }
        this.steerSmooth(baseTarget);
    }

    private void steerSmooth(class_243 target) {
        class_243 delta = target.method_1020(this.ghost.method_19538());
        double distance = delta.method_1033();
        if (distance < 0.001) {
            return;
        }
        double slowRadius = 2.2;
        double speed = this.speed * class_3532.method_15350((double)(distance / slowRadius), (double)0.15, (double)1.0);
        class_243 velocity = delta.method_1021(speed / distance);
        class_243 currentVelocity = this.ghost.method_18798();
        this.ghost.method_18800(class_3532.method_16436((double)this.lerp, (double)currentVelocity.field_1352, (double)velocity.field_1352), class_3532.method_16436((double)this.lerp, (double)currentVelocity.field_1351, (double)velocity.field_1351), class_3532.method_16436((double)this.lerp, (double)currentVelocity.field_1350, (double)velocity.field_1350));
    }

    private class_1542 findNearestSaplingItem() {
        class_243 position = this.ghost.method_19538();
        class_238 box = new class_238(position.field_1352 - (double)this.scanRadius, position.field_1351 - (double)this.scanRadius, position.field_1350 - (double)this.scanRadius, position.field_1352 + (double)this.scanRadius, position.field_1351 + (double)this.scanRadius, position.field_1350 + (double)this.scanRadius);
        List items = this.ghost.method_37908().method_8390(class_1542.class, box, e -> e.method_5805() && !e.method_6983().method_7960() && e.method_6983().method_31573(class_3489.field_15528));
        if (items.isEmpty()) {
            return null;
        }
        return items.stream().min(Comparator.comparingDouble(arg_0 -> ((SmallGhostEntity)this.ghost).method_5858(arg_0))).orElse(null);
    }
}

