/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.smallghost;

import dev.xylonity.bonsai.ghosts.common.entity.ghost.SmallGhostEntity;
import java.util.EnumSet;
import net.minecraft.class_1352;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_4538;

public class SmallGhostPlantSaplingGoal
extends class_1352 {
    private final SmallGhostEntity ghost;
    private final double speed;
    private final float lerp;
    private final int retryCooldown;
    private final int searchRadius;
    private int nextTryTick;
    private class_2338 targetPlacePos;

    public SmallGhostPlantSaplingGoal(SmallGhostEntity ghost, double speed, float lerp, int retryCooldown, int searchRadius) {
        this.ghost = ghost;
        this.speed = speed;
        this.lerp = lerp;
        this.retryCooldown = Math.max(10, retryCooldown);
        this.searchRadius = Math.max(2, searchRadius);
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (this.ghost.method_37908().field_9236) {
            return false;
        }
        if (this.ghost.getIsSleeping()) {
            return false;
        }
        if (this.ghost.field_6012 < this.nextTryTick) {
            return false;
        }
        class_1799 held = this.ghost.getHoldItem();
        if (!this.isSaplingBlockItem(held)) {
            return false;
        }
        if (this.ghost.method_59922().method_43048(40) != 0) {
            return false;
        }
        class_2338 found = this.findPlantPos();
        if (found == null) {
            return false;
        }
        this.targetPlacePos = found.method_10062();
        return true;
    }

    public boolean method_6266() {
        if (this.ghost.method_37908().field_9236) {
            return false;
        }
        if (this.ghost.getIsSleeping()) {
            return false;
        }
        if (this.targetPlacePos == null) {
            return false;
        }
        class_1799 held = this.ghost.getHoldItem();
        if (!this.isSaplingBlockItem(held)) {
            return false;
        }
        return this.isValidPlacement(this.targetPlacePos, (class_1747)held.method_7909());
    }

    public void method_6269() {
        this.ghost.field_5960 = false;
        if (this.ghost.getIsSleeping()) {
            this.ghost.setIsSleeping(false);
        }
        if (this.ghost.getCdFullHide() > 0) {
            this.ghost.setCdFullHide(0);
        }
    }

    public void method_6270() {
        this.targetPlacePos = null;
        int desired = this.ghost.field_6012 + this.retryCooldown;
        if (this.nextTryTick < desired) {
            this.nextTryTick = desired;
        }
        this.ghost.method_18799(this.ghost.method_18798().method_1021(0.6));
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        if (this.targetPlacePos == null) {
            this.method_6270();
            return;
        }
        class_1799 held = this.ghost.getHoldItem();
        if (!this.isSaplingBlockItem(held)) {
            this.method_6270();
            return;
        }
        class_1747 blockItem = (class_1747)held.method_7909();
        if (!this.isValidPlacement(this.targetPlacePos, blockItem)) {
            this.method_6270();
            return;
        }
        class_243 center = class_243.method_24953((class_2382)this.targetPlacePos).method_1031(0.0, 0.15, 0.0);
        this.ghost.method_5988().method_20248(center.field_1352, center.field_1351, center.field_1350);
        double placeDistSqr = 2.1025;
        if (this.ghost.method_19538().method_1025(center) <= placeDistSqr) {
            this.ghost.method_37908().method_8652(this.targetPlacePos, blockItem.method_7711().method_9564(), 3);
            held.method_7934(1);
            if (held.method_7960()) {
                this.ghost.setHoldItem(class_1799.field_8037);
            }
            this.method_6270();
            return;
        }
        this.steerSmooth(center);
    }

    private void steerSmooth(class_243 target) {
        class_243 delta = target.method_1020(this.ghost.method_19538());
        double distance = delta.method_1033();
        if (distance < 0.001) {
            return;
        }
        double slowRadius = 2.2;
        double speed = this.speed * class_3532.method_15350((double)(distance / slowRadius), (double)0.15, (double)1.0);
        class_243 velocity = delta.method_1021(speed / distance);
        class_243 currentVelocity = this.ghost.method_18798();
        this.ghost.method_18800(class_3532.method_16436((double)this.lerp, (double)currentVelocity.field_1352, (double)velocity.field_1352), class_3532.method_16436((double)this.lerp, (double)currentVelocity.field_1351, (double)velocity.field_1351), class_3532.method_16436((double)this.lerp, (double)currentVelocity.field_1350, (double)velocity.field_1350));
    }

    private boolean isSaplingBlockItem(class_1799 stack) {
        return !stack.method_7960() && stack.method_31573(class_3489.field_15528) && stack.method_7909() instanceof class_1747;
    }

    private boolean isValidPlacement(class_2338 placePos, class_1747 blockItem) {
        if (!this.ghost.method_37908().method_8320(placePos).method_26215()) {
            return false;
        }
        class_2338 basePos = placePos.method_10074();
        class_2680 base = this.ghost.method_37908().method_8320(basePos);
        if (!base.method_27852(class_2246.field_10219) && !base.method_27852(class_2246.field_10566)) {
            return false;
        }
        return blockItem.method_7711().method_9564().method_26184((class_4538)this.ghost.method_37908(), placePos);
    }

    private class_2338 findPlantPos() {
        class_2338 origin = this.ghost.method_24515();
        for (int i = 0; i < 32; ++i) {
            int dx = this.ghost.method_59922().method_43051(-this.searchRadius, this.searchRadius + 1);
            int dz = this.ghost.method_59922().method_43051(-this.searchRadius, this.searchRadius + 1);
            for (int down = 0; down <= 5; ++down) {
                class_1747 blockItem;
                class_1799 held;
                class_1792 class_17922;
                class_2338 basePos = origin.method_10069(dx, -down, dz);
                class_2680 base = this.ghost.method_37908().method_8320(basePos);
                if (!base.method_27852(class_2246.field_10219) && !base.method_27852(class_2246.field_10566)) continue;
                class_2338 placePos = basePos.method_10084();
                if (!this.ghost.method_37908().method_8320(placePos).method_26215() || !((class_17922 = (held = this.ghost.getHoldItem()).method_7909()) instanceof class_1747) || !(blockItem = (class_1747)class_17922).method_7711().method_9564().method_26184((class_4538)this.ghost.method_37908(), placePos)) continue;
                return placePos;
            }
        }
        return null;
    }
}

