/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.smallghost;

import dev.xylonity.bonsai.ghosts.common.entity.ghost.SmallGhostEntity;
import java.util.EnumSet;
import net.minecraft.class_1352;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3532;

public class SmallGhostTakeSaplingBlockGoal
extends class_1352 {
    private final SmallGhostEntity ghost;
    private final int scanRadius;
    private final double speed;
    private final float lerp;
    private int nextScanTick;
    private class_2338 targetPos;

    public SmallGhostTakeSaplingBlockGoal(SmallGhostEntity ghost, int scanRadius, double speed, float lerp) {
        this.ghost = ghost;
        this.scanRadius = Math.max(2, scanRadius);
        this.speed = speed;
        this.lerp = lerp;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (this.ghost.method_37908().field_9236) {
            return false;
        }
        if (!this.ghost.getHoldItem().method_7960()) {
            return false;
        }
        if (this.ghost.getIsSleeping()) {
            return false;
        }
        if (this.ghost.field_6012 < this.nextScanTick) {
            return false;
        }
        this.nextScanTick = this.ghost.field_6012 + 20;
        this.targetPos = this.findSaplingBlock();
        return this.targetPos != null;
    }

    public boolean method_6266() {
        if (this.ghost.method_37908().field_9236) {
            return false;
        }
        if (!this.ghost.getHoldItem().method_7960()) {
            return false;
        }
        if (this.ghost.getIsSleeping()) {
            return false;
        }
        if (this.targetPos == null) {
            return false;
        }
        class_2680 st = this.ghost.method_37908().method_8320(this.targetPos);
        if (!st.method_26164(class_3481.field_15462)) {
            return false;
        }
        double max = (double)this.scanRadius + 2.0;
        return this.ghost.method_19538().method_1025(class_243.method_24953((class_2382)this.targetPos)) <= max * max;
    }

    public void method_6269() {
        this.ghost.field_5960 = false;
        if (this.ghost.getIsSleeping()) {
            this.ghost.setIsSleeping(false);
        }
        if (this.ghost.getCdFullHide() > 0) {
            this.ghost.setCdFullHide(0);
        }
    }

    public void method_6270() {
        this.targetPos = null;
        this.ghost.method_18799(this.ghost.method_18798().method_1021(0.6));
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        if (this.targetPos == null) {
            this.method_6270();
            return;
        }
        class_2680 blockState = this.ghost.method_37908().method_8320(this.targetPos);
        if (!blockState.method_26164(class_3481.field_15462)) {
            this.method_6270();
            return;
        }
        class_243 center = class_243.method_24953((class_2382)this.targetPos).method_1031(0.0, 0.15, 0.0);
        this.ghost.method_5988().method_20248(center.field_1352, center.field_1351, center.field_1350);
        double takeDistSqr = 1.8225000000000002;
        if (this.ghost.method_19538().method_1025(center) <= takeDistSqr) {
            this.ghost.setHoldItem(new class_1799((class_1935)blockState.method_26204().method_8389()));
            this.ghost.method_37908().method_8652(this.targetPos, class_2246.field_10124.method_9564(), 3);
            this.method_6270();
            return;
        }
        this.steerSmooth(center);
    }

    private void steerSmooth(class_243 target) {
        class_243 delta = target.method_1020(this.ghost.method_19538());
        double distance = delta.method_1033();
        if (distance < 0.001) {
            return;
        }
        double slowRadius = 2.2;
        double speed = this.speed * class_3532.method_15350((double)(distance / slowRadius), (double)0.15, (double)1.0);
        class_243 velocity = delta.method_1021(speed / distance);
        class_243 currentVelocity = this.ghost.method_18798();
        this.ghost.method_18800(class_3532.method_16436((double)this.lerp, (double)currentVelocity.field_1352, (double)velocity.field_1352), class_3532.method_16436((double)this.lerp, (double)currentVelocity.field_1351, (double)velocity.field_1351), class_3532.method_16436((double)this.lerp, (double)currentVelocity.field_1350, (double)velocity.field_1350));
    }

    private class_2338 findSaplingBlock() {
        class_2338 origin = this.ghost.method_24515();
        class_2338 best = null;
        double bestDist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < 48; ++i) {
            double distance;
            int dx = this.ghost.method_59922().method_43051(-this.scanRadius, this.scanRadius + 1);
            int dz = this.ghost.method_59922().method_43051(-this.scanRadius, this.scanRadius + 1);
            int dy = this.ghost.method_59922().method_43051(-3, 4);
            class_2338 blockPos = origin.method_10069(dx, dy, dz);
            class_2680 blockState = this.ghost.method_37908().method_8320(blockPos);
            if (!blockState.method_26164(class_3481.field_15462) || !((distance = this.ghost.method_19538().method_1025(class_243.method_24953((class_2382)blockPos))) < bestDist)) continue;
            bestDist = distance;
            best = blockPos.method_10062();
        }
        return best;
    }
}

