/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.util;

import dev.xylonity.bonsai.ghosts.common.entity.AbstractGhostEntity;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1802;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public final class GhostOwnerTracker {
    private static final Map<UUID, Set<UUID>> owner_to_ghost = new ConcurrentHashMap<UUID, Set<UUID>>();
    private static final GhostOwnerTracker instance = new GhostOwnerTracker();

    private GhostOwnerTracker() {
    }

    public static GhostOwnerTracker getInstance() {
        return instance;
    }

    public void addGhost(AbstractGhostEntity ghost) {
        UUID ownerUUID = ghost.method_6139();
        if (ownerUUID != null) {
            owner_to_ghost.computeIfAbsent(ownerUUID, k -> ConcurrentHashMap.newKeySet()).add(ghost.method_5667());
        }
    }

    public void removeGhost(AbstractGhostEntity ghost) {
        UUID ownerUUID = ghost.method_6139();
        if (ownerUUID != null) {
            owner_to_ghost.remove(ownerUUID);
        }
    }

    @Nullable
    public AbstractGhostEntity findGhostWithTotem(class_3218 level, UUID playerUUID) {
        Set<UUID> ghostUUIDs = owner_to_ghost.get(playerUUID);
        if (ghostUUIDs == null || ghostUUIDs.isEmpty()) {
            return null;
        }
        for (class_3218 serverLevel : level.method_8503().method_3738()) {
            for (UUID uuid : ghostUUIDs) {
                AbstractGhostEntity ghost;
                class_1297 entity = serverLevel.method_14190(uuid);
                if (!(entity instanceof AbstractGhostEntity) || !(ghost = (AbstractGhostEntity)entity).method_6047().method_31574(class_1802.field_8288)) continue;
                return ghost;
            }
        }
        return null;
    }
}

