/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.xylonity.bonsai.ghosts.client.entity.layer.GhostGlowLayer;
import dev.xylonity.bonsai.ghosts.client.entity.model.GhostModel;
import dev.xylonity.bonsai.ghosts.client.entity.render.core.BaseGhostRenderer;
import dev.xylonity.bonsai.ghosts.common.entity.ghost.GhostEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.AbstractSkullBlock;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;
import software.bernie.geckolib.util.RenderUtils;

public class GhostRenderer
extends BaseGhostRenderer<GhostEntity> {
    public GhostRenderer(EntityRendererProvider.Context context) {
        super(context, new GhostModel());
        this.renderLayers.addLayer((GeoRenderLayer)new GhostGlowLayer((GeoRenderer<GhostEntity>)this));
        this.addRenderLayer((GeoRenderLayer)new HeadAnyItemArmorAwareLayer((GeoRenderer<GhostEntity>)this, "glow_1"));
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<GhostEntity>((GeoRenderer)this){

            protected ItemStack getArmorItemForBone(GeoBone bone, GhostEntity animatable) {
                if ("glow_1".equals(bone.getName())) {
                    return this.helmetStack;
                }
                return null;
            }

            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, GhostEntity animatable) {
                if ("glow_1".equals(bone.getName())) {
                    return EquipmentSlot.HEAD;
                }
                return super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
            }

            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, GhostEntity animatable, HumanoidModel<?> baseModel) {
                if ("glow_1".equals(bone.getName())) {
                    return baseModel.f_102808_;
                }
                return super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
            }

            protected void prepModelPartForRender(PoseStack poseStack, GeoBone bone, ModelPart sourcePart) {
                super.prepModelPartForRender(poseStack, bone, sourcePart);
                if ("glow_1".equals(bone.getName())) {
                    poseStack.m_85837_(0.0, -0.1, 0.0);
                }
            }
        });
    }

    @Override
    public void renderRecursively(PoseStack poseStack, GhostEntity animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if ("mushroom_red".equals(bone.getName()) || "mushroom_brown".equals(bone.getName())) {
            ItemStack head = animatable.m_6844_(EquipmentSlot.HEAD);
            if ("mushroom_red".equals(bone.getName())) {
                if (!GhostRenderer.isRedMush(head)) {
                    return;
                }
                super.renderRecursively(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, 1.0f);
                return;
            }
            if ("mushroom_brown".equals(bone.getName())) {
                if (!GhostRenderer.isBrownMush(head)) {
                    return;
                }
                super.renderRecursively(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, 1.0f);
                return;
            }
        }
        super.renderRecursively(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void actuallyRender(PoseStack poseStack, GhostEntity animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.actuallyRender(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, 0.65f);
    }

    private static boolean isRedMush(ItemStack s) {
        return s.m_150930_(Items.f_41953_);
    }

    private static boolean isBrownMush(ItemStack s) {
        return s.m_150930_(Items.f_41952_);
    }

    public static class HeadAnyItemArmorAwareLayer
    extends ItemArmorGeoLayer<GhostEntity> {
        private final String headBoneName;

        public HeadAnyItemArmorAwareLayer(GeoRenderer<GhostEntity> renderer, String headBoneName) {
            super(renderer);
            this.headBoneName = headBoneName;
        }

        protected ItemStack getArmorItemForBone(GeoBone bone, GhostEntity animatable) {
            if (this.headBoneName.equals(bone.getName())) {
                return this.helmetStack;
            }
            return null;
        }

        protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, GhostEntity animatable) {
            if (this.headBoneName.equals(bone.getName())) {
                return EquipmentSlot.HEAD;
            }
            return super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
        }

        protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, GhostEntity animatable, HumanoidModel<?> baseModel) {
            if (this.headBoneName.equals(bone.getName())) {
                return baseModel.f_102808_;
            }
            return super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
        }

        public void renderForBone(PoseStack poseStack, GhostEntity anim, GeoBone bone, RenderType renderType, MultiBufferSource buffers, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            BlockItem block;
            ItemStack stack = this.getArmorItemForBone(bone, anim);
            if (stack == null || stack.m_41619_()) {
                return;
            }
            if (GhostRenderer.isRedMush(stack) || GhostRenderer.isBrownMush(stack)) {
                return;
            }
            if (stack.m_41720_() instanceof ArmorItem) {
                return;
            }
            Item item = stack.m_41720_();
            if (item instanceof BlockItem && (block = (BlockItem)item).m_40614_() instanceof AbstractSkullBlock) {
                super.renderForBone(poseStack, (LivingEntity)anim, bone, renderType, buffers, buffer, partialTick, packedLight, packedOverlay);
                return;
            }
            HumanoidModel model = this.getModelForItem(bone, EquipmentSlot.HEAD, stack, (LivingEntity)anim);
            try {
                this.getReferenceCubeForModel(bone, this.getModelPartForBone(bone, EquipmentSlot.HEAD, stack, anim, model));
            }
            catch (IndexOutOfBoundsException ex) {
                return;
            }
            poseStack.m_85836_();
            RenderUtils.translateMatrixToBone((PoseStack)poseStack, (CoreGeoBone)bone);
            RenderUtils.translateToPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
            RenderUtils.rotateMatrixAroundBone((PoseStack)poseStack, (CoreGeoBone)bone);
            RenderUtils.scaleMatrixForBone((PoseStack)poseStack, (CoreGeoBone)bone);
            RenderUtils.translateAwayFromPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
            poseStack.m_85841_(0.5125f, 0.5125f, 0.5125f);
            poseStack.m_252880_(0.0f, 0.5f, 0.0f);
            Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.NONE, packedLight, OverlayTexture.f_118083_, poseStack, buffers, anim.m_9236_(), 0);
            poseStack.m_85849_();
            buffers.m_6299_(renderType);
        }
    }
}

