/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.client.entity.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xylonity.bonsai.ghosts.Ghosts;
import dev.xylonity.bonsai.ghosts.common.block.CalibratedHauntedEyeBlock;
import dev.xylonity.bonsai.ghosts.common.blockentity.CalibratedHauntedEyeBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class CalibratedHauntedEyeGlowRenderer
implements BlockEntityRenderer<CalibratedHauntedEyeBlockEntity> {
    private static final ResourceLocation GLOW_OFF = Ghosts.of("block/calibrated_haunted_eye_front_glow");
    private static final ResourceLocation GLOW_ON = Ghosts.of("block/calibrated_haunted_eye_front_on_glow");

    public CalibratedHauntedEyeGlowRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(CalibratedHauntedEyeBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffers, int packedLight, int packedOverlay) {
        BlockState state = blockEntity.m_58900_();
        if (!(state.m_60734_() instanceof CalibratedHauntedEyeBlock)) {
            return;
        }
        int power = (Integer)state.m_61143_((Property)CalibratedHauntedEyeBlock.POWER);
        Direction frontDirection = (Direction)state.m_61143_((Property)CalibratedHauntedEyeBlock.f_52588_);
        this.renderFrontGlow(poseStack, buffers, power, frontDirection);
        if (power > 0) {
            this.renderTopGlow(poseStack, buffers, power, frontDirection);
        }
    }

    private void renderFrontGlow(PoseStack poseStack, MultiBufferSource buffers, int power, Direction frontDirection) {
        ResourceLocation texture = power > 0 ? GLOW_ON : GLOW_OFF;
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
        int fullBright = LightTexture.m_109885_((int)15, (int)15);
        VertexConsumer vertexConsumer = buffers.m_6299_(RenderType.m_110466_());
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        CalibratedHauntedEyeGlowRenderer.rotateFromNorthTo(poseStack, frontDirection);
        poseStack.m_85841_(1.001f, 1.001f, 1.001f);
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        Matrix4f lastPose = poseStack.m_85850_().m_252922_();
        Matrix3f normalMatrix = poseStack.m_85850_().m_252943_();
        float u0 = sprite.m_118409_();
        float u1 = sprite.m_118410_();
        float v0 = sprite.m_118411_();
        float v1 = sprite.m_118412_();
        float x0 = 0.0f;
        float y0 = 0.0f;
        float x1 = 1.0f;
        float y1 = 1.0f;
        float z = -0.001f;
        vertexConsumer.m_252986_(lastPose, x0, y0, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_252939_(normalMatrix, 0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(lastPose, x0, y1, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_252939_(normalMatrix, 0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(lastPose, x1, y1, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_252939_(normalMatrix, 0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(lastPose, x1, y0, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_252939_(normalMatrix, 0.0f, 0.0f, -1.0f).m_5752_();
        poseStack.m_85849_();
    }

    private void renderTopGlow(PoseStack poseStack, MultiBufferSource buffers, int power, Direction frontDirection) {
        ResourceLocation texture = power <= 4 ? Ghosts.of("block/calibrated_haunted_eye_top_2_glow") : (power <= 6 ? Ghosts.of("block/calibrated_haunted_eye_top_3_glow") : (power <= 8 ? Ghosts.of("block/calibrated_haunted_eye_top_4_glow") : (power <= 10 ? Ghosts.of("block/calibrated_haunted_eye_top_5_glow") : Ghosts.of("block/calibrated_haunted_eye_top_6_glow"))));
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
        int fullBright = LightTexture.m_109885_((int)15, (int)15);
        VertexConsumer vertexConsumer = buffers.m_6299_(RenderType.m_110466_());
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        CalibratedHauntedEyeGlowRenderer.rotateTopForFacing(poseStack, frontDirection);
        poseStack.m_85841_(1.001f, 1.001f, 1.001f);
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        Matrix4f lastPose = poseStack.m_85850_().m_252922_();
        Matrix3f normalMatrix = poseStack.m_85850_().m_252943_();
        float u0 = sprite.m_118409_();
        float u1 = sprite.m_118410_();
        float v0 = sprite.m_118411_();
        float v1 = sprite.m_118412_();
        float x0 = 0.0f;
        float z0 = 0.0f;
        float x1 = 1.0f;
        float z1 = 1.0f;
        float y = 1.001f;
        vertexConsumer.m_252986_(lastPose, x0, y, z0).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(lastPose, x0, y, z1).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(lastPose, x1, y, z1).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(lastPose, x1, y, z0).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }

    private static void rotateFromNorthTo(PoseStack poseStack, Direction direction) {
        switch (direction) {
            case NORTH: {
                break;
            }
            case SOUTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case EAST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                break;
            }
            case WEST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case UP: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                break;
            }
            case DOWN: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            }
        }
    }

    private static void rotateTopForFacing(PoseStack poseStack, Direction facing) {
        switch (facing) {
            case NORTH: {
                break;
            }
            case SOUTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case EAST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                break;
            }
            case WEST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case UP: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                break;
            }
            case DOWN: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            }
        }
    }
}

