/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.client.particle;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class FlyingGhostParticle
extends TextureSheetParticle {
    private static final int FRAME_TICKS = 4;
    private static final int FRAMES = 8;
    private final SpriteSet spritesset;
    private int lastFrame = -1;
    private final double startY;
    private final float floatSpeed;
    private final float floatAmplitude;

    FlyingGhostParticle(ClientLevel world, double x, double y, double z, SpriteSet sprites, double velX, double velY, double velZ) {
        super(world, x, y + 0.5, z, 0.0, 0.0, 0.0);
        this.f_107663_ = 0.2f;
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
        this.f_107225_ = new Random().nextInt(800, 1200);
        this.m_108339_(sprites);
        this.spritesset = sprites;
        this.f_107226_ = 0.03f;
        this.f_172258_ = 0.99f;
        this.startY = this.f_107213_;
        this.floatSpeed = 0.03f + this.f_107223_.m_188501_() * 0.02f;
        this.floatAmplitude = 2.0f;
        int frame = 0;
        this.m_108337_(this.spritesset.m_5819_(frame, 8));
        this.lastFrame = frame;
    }

    protected int m_6355_(float partialTick) {
        return 0xF000F0;
    }

    @Nonnull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        super.m_5989_();
        int frame = this.f_107224_ / 4 % 8;
        if (frame != this.lastFrame) {
            this.m_108337_(this.spritesset.m_5819_(frame, 8));
            this.lastFrame = frame;
        }
        float offset = Mth.m_14031_((float)((float)this.f_107224_ * this.floatSpeed)) * this.floatAmplitude;
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107216_ = 0.0;
        this.m_107264_(this.f_107212_, this.startY + (double)offset, this.f_107214_);
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(@Nonnull SimpleParticleType particleType, @Nonnull ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new FlyingGhostParticle(level, x, y, z, this.sprites, dx, dy, dz);
        }
    }
}

