/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.block;

import dev.xylonity.bonsai.ghosts.common.blockentity.CalibratedHauntedEyeBlockEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CalibratedHauntedEyeBlock
extends DirectionalBlock
implements EntityBlock {
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    private static final double MAX_DETECTION_DISTANCE = 15.0;

    public CalibratedHauntedEyeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.NORTH)).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)ctx.m_7820_().m_122424_().m_122424_())).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_, POWER});
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.f_46443_) {
            level.m_186460_(pos, (Block)this, 1);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int currentPower;
        int newPower = this.calculatePowerLevel((Level)level, pos, state);
        if (newPower != (currentPower = ((Integer)state.m_61143_((Property)POWER)).intValue())) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(newPower)), 3);
            this.updateNeighbors((Level)level, pos, state);
        }
        level.m_186460_(pos, (Block)this, 1);
    }

    private int calculatePowerLevel(Level level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)f_52588_);
        Vec3 eyePos = Vec3.m_82512_((Vec3i)pos);
        Vec3 lookDirection = Vec3.m_82528_((Vec3i)facing.m_122436_());
        List entities = level.m_6443_(LivingEntity.class, this.createSearchArea(pos, facing), entity -> !entity.m_5833_());
        if (entities.isEmpty()) {
            return 0;
        }
        double closestDistance = 16.0;
        for (Entity entity2 : entities) {
            double distance;
            Vec3 entityPos = entity2.m_20182_();
            Vec3 toEntity = entityPos.m_82546_(eyePos);
            double dotProduct = toEntity.m_82541_().m_82526_(lookDirection);
            if (!(dotProduct > 0.5) || !((distance = eyePos.m_82554_(entityPos)) < closestDistance)) continue;
            closestDistance = distance;
        }
        if (closestDistance > 15.0) {
            return 0;
        }
        int power = (int)Math.ceil(15.0 - closestDistance / 15.0 * 14.0);
        return Math.max(1, Math.min(15, power));
    }

    private AABB createSearchArea(BlockPos pos, Direction facing) {
        Vec3 center = Vec3.m_82512_((Vec3i)pos);
        double expand = 3.0;
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> new AABB(center.f_82479_ - 3.0, center.f_82480_ - 3.0, center.f_82481_ - 15.0, center.f_82479_ + 3.0, center.f_82480_ + 3.0, center.f_82481_);
            case Direction.SOUTH -> new AABB(center.f_82479_ - 3.0, center.f_82480_ - 3.0, center.f_82481_, center.f_82479_ + 3.0, center.f_82480_ + 3.0, center.f_82481_ + 15.0);
            case Direction.WEST -> new AABB(center.f_82479_ - 15.0, center.f_82480_ - 3.0, center.f_82481_ - 3.0, center.f_82479_, center.f_82480_ + 3.0, center.f_82481_ + 3.0);
            case Direction.EAST -> new AABB(center.f_82479_, center.f_82480_ - 3.0, center.f_82481_ - 3.0, center.f_82479_ + 15.0, center.f_82480_ + 3.0, center.f_82481_ + 3.0);
            case Direction.UP -> new AABB(center.f_82479_ - 3.0, center.f_82480_, center.f_82481_ - 3.0, center.f_82479_ + 3.0, center.f_82480_ + 15.0, center.f_82481_ + 3.0);
            case Direction.DOWN -> new AABB(center.f_82479_ - 3.0, center.f_82480_ - 15.0, center.f_82481_ - 3.0, center.f_82479_ + 3.0, center.f_82480_, center.f_82481_ + 3.0);
        };
    }

    private void updateNeighbors(Level level, BlockPos pos, BlockState state) {
        Direction out = (Direction)state.m_61143_((Property)f_52588_);
        BlockPos target = pos.m_121945_(out);
        level.m_46586_(target, (Block)this, pos);
        level.m_46590_(target, (Block)this, out.m_122424_());
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return side == state.m_61143_((Property)f_52588_) ? (Integer)state.m_61143_((Property)POWER) : 0;
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return this.m_6378_(state, level, pos, side);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new CalibratedHauntedEyeBlockEntity(blockPos, blockState);
    }
}

