/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity;

import dev.xylonity.bonsai.ghosts.util.GhostOwnerTracker;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AbstractGhostEntity
extends TamableAnimal
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> MAIN_INTERACTION = SynchedEntityData.m_135353_(AbstractGhostEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean chunkForced = false;
    private long forcedChunk = Long.MIN_VALUE;
    private boolean isTracked = false;

    public AbstractGhostEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.m_21805_() != null) {
            if (!this.isTracked) {
                GhostOwnerTracker.getInstance().addGhost(this);
                this.isTracked = true;
            }
            this.ensureChunkForced();
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.m_9236_().f_46443_ && this.isTracked) {
            GhostOwnerTracker.getInstance().removeGhost(this);
            this.isTracked = false;
        }
        super.m_142687_(reason);
    }

    private void ensureChunkForced() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ChunkPos chunkPosition = new ChunkPos(this.m_20183_());
            long now = chunkPosition.m_45588_();
            if (this.chunkForced && this.forcedChunk != now) {
                ChunkPos old = new ChunkPos(this.forcedChunk);
                serverLevel.m_8602_(old.f_45578_, old.f_45579_, false);
                this.chunkForced = false;
            }
            if (!this.chunkForced) {
                serverLevel.m_8602_(chunkPosition.f_45578_, chunkPosition.f_45579_, true);
                this.forcedChunk = now;
                this.chunkForced = true;
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MAIN_INTERACTION, (Object)0);
    }

    public void cycleMainInteraction(Player player) {
        int interaction = (this.getMainInteraction() + 1) % 3;
        this.m_21839_(interaction == 0);
        if (player != null) {
            switch (interaction) {
                case 0: {
                    player.m_5661_((Component)Component.m_237110_((String)"entity.ghosts.client_message.interaction_0", (Object[])new Object[]{this.m_7755_()}), true);
                    break;
                }
                case 1: {
                    player.m_5661_((Component)Component.m_237110_((String)"entity.ghosts.client_message.interaction_1", (Object[])new Object[]{this.m_7755_()}), true);
                    break;
                }
                case 2: {
                    player.m_5661_((Component)Component.m_237110_((String)"entity.ghosts.client_message.interaction_2", (Object[])new Object[]{this.m_7755_()}), true);
                }
            }
        }
        this.f_19804_.m_135381_(MAIN_INTERACTION, (Object)interaction);
    }

    protected void rotateBody() {
        Vec3 vel = this.m_20184_();
        if (vel.m_82556_() < 1.0E-4) {
            return;
        }
        float yaw = (float)(Mth.m_14136_((double)vel.f_82481_, (double)vel.f_82479_) * 57.29577951308232) - 90.0f;
        float pitch = (float)(-(Mth.m_14136_((double)vel.f_82480_, (double)Math.sqrt(vel.f_82479_ * vel.f_82479_ + vel.f_82481_ * vel.f_82481_)) * 57.29577951308232));
        this.m_146922_(yaw);
        this.m_5616_(yaw);
        this.f_20883_ = yaw;
        this.f_19859_ = yaw;
        this.f_20884_ = yaw;
        this.m_146926_(pitch);
        this.f_19860_ = pitch;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268612_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void setMainInteraction(int interaction) {
        this.f_19804_.m_135381_(MAIN_INTERACTION, (Object)interaction);
    }

    public int getMainInteraction() {
        return (Integer)this.f_19804_.m_135370_(MAIN_INTERACTION);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setMainInteraction(compound.m_128451_("MainInteraction"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("MainInteraction", this.getMainInteraction());
    }

    public ItemStack getHoldItem() {
        return this.m_6844_(EquipmentSlot.MAINHAND);
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

