/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.generic;

import dev.xylonity.bonsai.ghosts.common.entity.AbstractGhostEntity;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GhostApproachHeldGlowBerriesGoal
extends Goal {
    private final AbstractGhostEntity ghost;
    private final double maxSpeed;
    private final double minDistance;
    private final double startDistance;
    private final float lerpFactor;
    private final int searchRadius;
    private Player target;
    private boolean forcedNoPhysics = false;

    public GhostApproachHeldGlowBerriesGoal(AbstractGhostEntity ghost, double maxSpeed, double minDistance, double startDistance, float lerpFactor, int searchRadius) {
        this.ghost = ghost;
        this.maxSpeed = maxSpeed;
        this.minDistance = minDistance;
        this.startDistance = startDistance;
        this.lerpFactor = lerpFactor;
        this.searchRadius = searchRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.ghost.m_21824_()) {
            return false;
        }
        if (this.ghost.m_20160_() || this.ghost.m_21825_()) {
            return false;
        }
        List players = this.ghost.m_9236_().m_6443_(Player.class, this.ghost.m_20191_().m_82400_((double)this.searchRadius), p -> p.m_6084_() && !p.m_5833_() && (p.m_21205_().m_150930_(Items.f_151079_) || p.m_21206_().m_150930_(Items.f_151079_)));
        if (players.isEmpty()) {
            return false;
        }
        this.target = players.stream().min(Comparator.comparingDouble(p -> p.m_20280_((Entity)this.ghost))).orElse(null);
        return true;
    }

    public boolean m_8045_() {
        if (this.target == null) {
            return false;
        }
        if (this.ghost.m_21824_()) {
            return false;
        }
        if (this.ghost.m_20160_() || this.ghost.m_21825_()) {
            return false;
        }
        if (!this.target.m_6084_()) {
            return false;
        }
        if (this.target.m_20280_((Entity)this.ghost) > (double)(this.searchRadius * this.searchRadius)) {
            return false;
        }
        return this.target.m_21205_().m_150930_(Items.f_151079_) || this.target.m_21206_().m_150930_(Items.f_151079_);
    }

    public void m_8056_() {
        this.forcedNoPhysics = false;
    }

    public void m_8041_() {
        if (this.forcedNoPhysics) {
            this.ghost.f_19794_ = false;
            this.forcedNoPhysics = false;
        }
        this.target = null;
        this.ghost.m_21573_().m_26573_();
    }

    public void m_8037_() {
        boolean blocked;
        double dz;
        double dy;
        if (this.target == null) {
            return;
        }
        Vec3 hover = this.target.m_146892_().m_82520_(0.0, 0.6, 0.0);
        double dx = hover.f_82479_ - this.ghost.m_20185_();
        double distance = Math.sqrt(dx * dx + (dy = hover.f_82480_ - this.ghost.m_20186_()) * dy + (dz = hover.f_82481_ - this.ghost.m_20189_()) * dz);
        if (distance < 1.0E-6) {
            return;
        }
        this.ghost.m_21391_((Entity)this.target, 30.0f, 30.0f);
        Vec3 k = hover.m_82492_(dx / distance * this.minDistance, dy / distance * this.minDistance, dz / distance * this.minDistance);
        Vec3 veloc = k.m_82546_(this.ghost.m_20182_());
        double len = veloc.m_82553_();
        if (len > 1.0E-6) {
            veloc = veloc.m_82490_(1.0 / len).m_82490_(this.maxSpeed * (distance >= this.startDistance ? 1.0 : Mth.m_14008_((double)((distance - this.minDistance) / Math.max(0.1, this.startDistance - this.minDistance)), (double)0.0, (double)1.0)));
        }
        Vec3 current = this.ghost.m_20184_();
        this.ghost.m_20256_(new Vec3(Mth.m_14139_((double)this.lerpFactor, (double)current.f_82479_, (double)veloc.f_82479_), Mth.m_14139_((double)this.lerpFactor, (double)current.f_82480_, (double)veloc.f_82480_), Mth.m_14139_((double)this.lerpFactor, (double)current.f_82481_, (double)veloc.f_82481_)));
        if (distance <= this.minDistance + 0.25) {
            this.ghost.m_20256_(this.ghost.m_20184_().m_82490_(0.85));
        }
        this.ghost.f_19794_ = blocked = this.canGoThrough(this.ghost.m_9236_(), this.ghost.m_146892_(), k);
        this.forcedNoPhysics = blocked;
    }

    private boolean canGoThrough(Level lvl, Vec3 from, Vec3 to) {
        return lvl.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.ghost)).m_6662_() != HitResult.Type.MISS;
    }
}

