/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.generic;

import dev.xylonity.bonsai.ghosts.common.entity.ghost.GhostEntity;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GhostPlaceGoal
extends Goal {
    private final GhostEntity ghost;
    private final Ingredient placeables;
    private final Predicate<BlockState> preference;
    private final int minLight;
    private final int retryCooldown;
    private final double approachSpeed;
    private int nextTryTick;
    private int lastRepathTick;
    private final double maxOwnerDrift = 36.0;
    @Nullable
    private BlockPos targetPlacePos;
    @Nullable
    private BlockPos lastPlacedPos;

    public GhostPlaceGoal(GhostEntity ghost, Ingredient placeables, Predicate<BlockState> pref, int lightThreshold, int retry, double speed) {
        this.ghost = ghost;
        this.placeables = placeables;
        this.preference = pref;
        this.minLight = lightThreshold;
        this.retryCooldown = Math.max(5, retry);
        this.approachSpeed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        int minOwnerDistFromLast;
        int manhattanDistance;
        if (this.ghost.m_9236_().f_46443_) {
            return false;
        }
        if (this.ghost.getMainInteraction() != 1) {
            return false;
        }
        if (this.ghost.m_21825_() || this.ghost.m_20159_()) {
            return false;
        }
        if (this.ghost.f_19797_ < this.nextTryTick) {
            return false;
        }
        LivingEntity owner = this.ghost.m_269323_();
        if (owner == null) {
            return false;
        }
        ItemStack heldStack = this.ghost.getHoldItem();
        if (!this.isPlaceableBlockItem(heldStack)) {
            return false;
        }
        if (this.lastPlacedPos != null && (manhattanDistance = owner.m_20183_().m_123333_((Vec3i)this.lastPlacedPos)) < (minOwnerDistFromLast = 4)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)heldStack.m_41720_();
        BlockPos found = this.findDarkPlacePosNearOwner(this.ghost.m_9236_(), owner, blockItem);
        if (found == null) {
            return false;
        }
        this.targetPlacePos = found.m_7949_();
        return true;
    }

    public boolean m_8045_() {
        if (this.ghost.m_9236_().f_46443_) {
            return false;
        }
        if (this.ghost.getMainInteraction() != 1) {
            return false;
        }
        if (this.targetPlacePos == null) {
            return false;
        }
        LivingEntity owner = this.ghost.m_269323_();
        if (owner == null) {
            return false;
        }
        if (owner.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)this.targetPlacePos)) > 36.0) {
            return false;
        }
        ItemStack heldStack = this.ghost.getHoldItem();
        if (!this.isPlaceableBlockItem(heldStack)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)heldStack.m_41720_();
        return this.isValidPlacement(this.ghost.m_9236_(), this.targetPlacePos, blockItem);
    }

    public void m_8056_() {
        this.lastRepathTick = this.ghost.f_19797_;
        if (this.targetPlacePos == null) {
            return;
        }
        this.moveToTarget();
    }

    public void m_8041_() {
        this.ghost.m_21573_().m_26573_();
        this.targetPlacePos = null;
        int desired = this.ghost.f_19797_ + this.retryCooldown;
        if (this.nextTryTick < desired) {
            this.nextTryTick = desired;
        }
    }

    public void m_8037_() {
        double placeDistanceSquare;
        if (this.targetPlacePos == null) {
            return;
        }
        LivingEntity owner = this.ghost.m_269323_();
        if (owner == null) {
            this.m_8041_();
            return;
        }
        if (!this.ghost.m_9236_().m_8055_(this.targetPlacePos).m_60795_()) {
            this.m_8041_();
            return;
        }
        Vec3 center = Vec3.m_82512_((Vec3i)this.targetPlacePos);
        if (owner.m_20182_().m_82557_(center) > 36.0) {
            this.m_8041_();
            return;
        }
        double distSquare = this.ghost.m_20182_().m_82557_(center);
        if (distSquare <= 9.0) {
            this.ghost.m_21563_().m_24946_(center.f_82479_, center.f_82480_, center.f_82481_);
        }
        if (distSquare <= (placeDistanceSquare = 1.9599999999999997)) {
            this.ghost.m_21573_().m_26573_();
            if (this.canSee(this.targetPlacePos) && this.placeNow(this.targetPlacePos)) {
                this.m_8041_();
            }
            return;
        }
        int ticksPerRepath = 12;
        if (this.ghost.f_19797_ - this.lastRepathTick >= ticksPerRepath) {
            this.lastRepathTick = this.ghost.f_19797_;
            this.moveToTarget();
        }
    }

    public boolean m_183429_() {
        return true;
    }

    private void moveToTarget() {
        if (this.targetPlacePos == null) {
            return;
        }
        Vec3 movePos = Vec3.m_82512_((Vec3i)this.targetPlacePos).m_82520_(0.0, 0.1, 0.0);
        this.ghost.m_21573_().m_26519_(movePos.f_82479_, movePos.f_82480_, movePos.f_82481_, this.approachSpeed);
    }

    private boolean isPlaceableBlockItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (!this.placeables.test(stack)) {
            return false;
        }
        return stack.m_41720_() instanceof BlockItem;
    }

    private boolean isValidPlacement(Level level, BlockPos placePos, BlockItem blockItem) {
        if (!level.m_8055_(placePos).m_60795_()) {
            return false;
        }
        if (this.lastPlacedPos != null) {
            int dx = Math.abs(placePos.m_123341_() - this.lastPlacedPos.m_123341_());
            int dy = Math.abs(placePos.m_123342_() - this.lastPlacedPos.m_123342_());
            int dz = Math.abs(placePos.m_123343_() - this.lastPlacedPos.m_123343_());
            if (dx <= 1 && dy <= 1 && dz <= 1) {
                return false;
            }
        }
        if (level.m_46803_(placePos) > this.minLight) {
            return false;
        }
        BlockPos basePos = placePos.m_7495_();
        BlockState baseState = level.m_8055_(basePos);
        if (baseState.m_60795_()) {
            return false;
        }
        if (!this.preference.test(baseState)) {
            return false;
        }
        return blockItem.m_40614_().m_49966_().m_60710_((LevelReader)level, placePos);
    }

    private boolean placeNow(BlockPos placePos) {
        ItemStack heldStack = this.ghost.getHoldItem();
        if (!this.isPlaceableBlockItem(heldStack)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)heldStack.m_41720_();
        if (!this.isValidPlacement(this.ghost.m_9236_(), placePos, blockItem)) {
            return false;
        }
        this.ghost.triggerAnim("torch_place_controller", "torch_place");
        this.ghost.m_9236_().m_7731_(placePos, blockItem.m_40614_().m_49966_(), 3);
        heldStack.m_41774_(1);
        if (heldStack.m_41619_()) {
            this.ghost.setHoldItem(ItemStack.f_41583_);
        }
        this.lastPlacedPos = placePos.m_7949_();
        this.nextTryTick = this.ghost.f_19797_ + this.retryCooldown;
        return true;
    }

    private boolean canSee(BlockPos placePos) {
        Vec3 targetPosition = Vec3.m_82512_((Vec3i)placePos);
        BlockHitResult hitResult = this.ghost.m_9236_().m_45547_(new ClipContext(this.ghost.m_146892_(), targetPosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.ghost));
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            return true;
        }
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = hitResult;
            return blockHitResult.m_82425_().equals((Object)placePos);
        }
        return false;
    }

    @Nullable
    private BlockPos findDarkPlacePosNearOwner(Level level, LivingEntity owner, BlockItem blockItem) {
        Vec3 forward = owner.m_20184_();
        forward = new Vec3(forward.f_82479_, 0.0, forward.f_82481_);
        if (forward.m_82556_() < 5.0E-4) {
            Vec3 look = owner.m_20154_();
            forward = new Vec3(look.f_82479_, 0.0, look.f_82481_);
        }
        if (forward.m_82556_() > 1.0E-4) {
            forward = forward.m_82541_();
        }
        BlockPos bestPosition = null;
        double bestScore = Double.POSITIVE_INFINITY;
        BlockPos centerPosition = owner.m_20183_();
        int searchRadius = 4;
        for (int dx = -searchRadius; dx <= searchRadius; ++dx) {
            for (int dz = -searchRadius; dz <= searchRadius; ++dz) {
                int searchRadiusDown = 4;
                for (int down = 1; down <= searchRadiusDown; ++down) {
                    double score;
                    int light;
                    BlockPos placePosition;
                    BlockPos basePos = centerPosition.m_7918_(dx, -down, dz);
                    BlockState baseState = level.m_8055_(basePos);
                    if (baseState.m_60795_() || !this.preference.test(baseState) || !level.m_8055_(placePosition = basePos.m_7494_()).m_60795_() || (light = level.m_46803_(placePosition)) > this.minLight || !blockItem.m_40614_().m_49966_().m_60710_((LevelReader)level, placePosition)) continue;
                    Vec3 toPosition = Vec3.m_82512_((Vec3i)placePosition).m_82546_(owner.m_20182_());
                    Vec3 toPositionFlat = new Vec3(toPosition.f_82479_, 0.0, toPosition.f_82481_);
                    double distanceToPosition = toPositionFlat.m_82553_();
                    double behindPenalty = 0.0;
                    if (forward.m_82556_() > 1.0E-4 && toPositionFlat.m_82556_() > 1.0E-4) {
                        double normalized = forward.m_82526_(toPositionFlat.m_82541_());
                        behindPenalty = (1.0 - normalized) * 2.0;
                    }
                    if (!((score = (double)light * 1000.0 + distanceToPosition * 25.0 + behindPenalty * 200.0) < bestScore)) continue;
                    bestScore = score;
                    bestPosition = placePosition;
                }
            }
        }
        return bestPosition;
    }
}

