/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.smallghost;

import dev.xylonity.bonsai.ghosts.common.entity.ghost.SmallGhostEntity;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SmallGhostPickupSaplingGoal
extends Goal {
    private final SmallGhostEntity ghost;
    private final double speed;
    private final float lerp;
    private final int scanRadius;
    private int nextScanTick;
    @Nullable
    private ItemEntity targetItem;

    public SmallGhostPickupSaplingGoal(SmallGhostEntity ghost, double speed, float lerp, int scanRadius) {
        this.ghost = ghost;
        this.speed = speed;
        this.lerp = lerp;
        this.scanRadius = scanRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.ghost.m_9236_().f_46443_) {
            return false;
        }
        if (this.ghost.getIsSleeping()) {
            return false;
        }
        if (!this.ghost.getHoldItem().m_41619_()) {
            return false;
        }
        if (this.ghost.f_19797_ < this.nextScanTick) {
            return false;
        }
        this.nextScanTick = this.ghost.f_19797_ + 20;
        this.targetItem = this.findNearestSaplingItem();
        return this.targetItem != null;
    }

    public boolean m_8045_() {
        if (this.ghost.m_9236_().f_46443_) {
            return false;
        }
        if (this.ghost.getIsSleeping()) {
            return false;
        }
        if (!this.ghost.getHoldItem().m_41619_()) {
            return false;
        }
        if (this.targetItem == null || !this.targetItem.m_6084_()) {
            return false;
        }
        ItemStack itemStack = this.targetItem.m_32055_();
        if (itemStack.m_41619_() || !itemStack.m_204117_(ItemTags.f_13180_)) {
            return false;
        }
        double max = (double)this.scanRadius + 2.0;
        return this.ghost.m_20280_((Entity)this.targetItem) <= max * max;
    }

    public void m_8056_() {
        this.ghost.f_19794_ = false;
        if (this.ghost.getIsSleeping()) {
            this.ghost.setIsSleeping(false);
        }
        if (this.ghost.getCdFullHide() > 0) {
            this.ghost.setCdFullHide(0);
        }
    }

    public void m_8041_() {
        this.targetItem = null;
        this.ghost.m_20256_(this.ghost.m_20184_().m_82490_(0.6));
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        if (this.targetItem == null || !this.targetItem.m_6084_()) {
            this.m_8041_();
            return;
        }
        BlockPos blockPos = this.targetItem.m_20183_();
        Vec3 baseTarget = Vec3.m_82512_((Vec3i)blockPos).m_82520_(0.0, 0.15, 0.0);
        this.ghost.m_21563_().m_24946_(baseTarget.f_82479_, baseTarget.f_82480_, baseTarget.f_82481_);
        double pickDistSqr = 1.5625;
        if (this.ghost.m_20182_().m_82557_(baseTarget) <= pickDistSqr) {
            ItemStack stack = this.targetItem.m_32055_();
            if (!stack.m_41619_() && stack.m_204117_(ItemTags.f_13180_) && this.ghost.getHoldItem().m_41619_()) {
                ItemStack pickup = stack.m_41777_();
                pickup.m_41764_(1);
                if (stack.m_41613_() > 1) {
                    stack.m_41774_(1);
                    this.ghost.m_7938_((Entity)this.targetItem, 1);
                } else {
                    this.targetItem.m_146870_();
                }
                this.ghost.setHoldItem(pickup);
            }
            this.m_8041_();
            return;
        }
        this.steerSmooth(baseTarget);
    }

    private void steerSmooth(Vec3 target) {
        Vec3 delta = target.m_82546_(this.ghost.m_20182_());
        double distance = delta.m_82553_();
        if (distance < 0.001) {
            return;
        }
        double slowRadius = 2.2;
        double speed = this.speed * Mth.m_14008_((double)(distance / slowRadius), (double)0.15, (double)1.0);
        Vec3 velocity = delta.m_82490_(speed / distance);
        Vec3 currentVelocity = this.ghost.m_20184_();
        this.ghost.m_20334_(Mth.m_14139_((double)this.lerp, (double)currentVelocity.f_82479_, (double)velocity.f_82479_), Mth.m_14139_((double)this.lerp, (double)currentVelocity.f_82480_, (double)velocity.f_82480_), Mth.m_14139_((double)this.lerp, (double)currentVelocity.f_82481_, (double)velocity.f_82481_));
    }

    @Nullable
    private ItemEntity findNearestSaplingItem() {
        Vec3 position = this.ghost.m_20182_();
        AABB box = new AABB(position.f_82479_ - (double)this.scanRadius, position.f_82480_ - (double)this.scanRadius, position.f_82481_ - (double)this.scanRadius, position.f_82479_ + (double)this.scanRadius, position.f_82480_ + (double)this.scanRadius, position.f_82481_ + (double)this.scanRadius);
        List items = this.ghost.m_9236_().m_6443_(ItemEntity.class, box, e -> e.m_6084_() && !e.m_32055_().m_41619_() && e.m_32055_().m_204117_(ItemTags.f_13180_));
        if (items.isEmpty()) {
            return null;
        }
        return items.stream().min(Comparator.comparingDouble(arg_0 -> ((SmallGhostEntity)this.ghost).m_20280_(arg_0))).orElse(null);
    }
}

