/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.smallghost;

import dev.xylonity.bonsai.ghosts.common.entity.ghost.SmallGhostEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SmallGhostPlantSaplingGoal
extends Goal {
    private final SmallGhostEntity ghost;
    private final double speed;
    private final float lerp;
    private final int retryCooldown;
    private final int searchRadius;
    private int nextTryTick;
    @Nullable
    private BlockPos targetPlacePos;

    public SmallGhostPlantSaplingGoal(SmallGhostEntity ghost, double speed, float lerp, int retryCooldown, int searchRadius) {
        this.ghost = ghost;
        this.speed = speed;
        this.lerp = lerp;
        this.retryCooldown = Math.max(10, retryCooldown);
        this.searchRadius = Math.max(2, searchRadius);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.ghost.m_9236_().f_46443_) {
            return false;
        }
        if (this.ghost.getIsSleeping()) {
            return false;
        }
        if (this.ghost.f_19797_ < this.nextTryTick) {
            return false;
        }
        ItemStack held = this.ghost.getHoldItem();
        if (!this.isSaplingBlockItem(held)) {
            return false;
        }
        if (this.ghost.m_217043_().m_188503_(40) != 0) {
            return false;
        }
        BlockPos found = this.findPlantPos();
        if (found == null) {
            return false;
        }
        this.targetPlacePos = found.m_7949_();
        return true;
    }

    public boolean m_8045_() {
        if (this.ghost.m_9236_().f_46443_) {
            return false;
        }
        if (this.ghost.getIsSleeping()) {
            return false;
        }
        if (this.targetPlacePos == null) {
            return false;
        }
        ItemStack held = this.ghost.getHoldItem();
        if (!this.isSaplingBlockItem(held)) {
            return false;
        }
        return this.isValidPlacement(this.targetPlacePos, (BlockItem)held.m_41720_());
    }

    public void m_8056_() {
        this.ghost.f_19794_ = false;
        if (this.ghost.getIsSleeping()) {
            this.ghost.setIsSleeping(false);
        }
        if (this.ghost.getCdFullHide() > 0) {
            this.ghost.setCdFullHide(0);
        }
    }

    public void m_8041_() {
        this.targetPlacePos = null;
        int desired = this.ghost.f_19797_ + this.retryCooldown;
        if (this.nextTryTick < desired) {
            this.nextTryTick = desired;
        }
        this.ghost.m_20256_(this.ghost.m_20184_().m_82490_(0.6));
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        if (this.targetPlacePos == null) {
            this.m_8041_();
            return;
        }
        ItemStack held = this.ghost.getHoldItem();
        if (!this.isSaplingBlockItem(held)) {
            this.m_8041_();
            return;
        }
        BlockItem blockItem = (BlockItem)held.m_41720_();
        if (!this.isValidPlacement(this.targetPlacePos, blockItem)) {
            this.m_8041_();
            return;
        }
        Vec3 center = Vec3.m_82512_((Vec3i)this.targetPlacePos).m_82520_(0.0, 0.15, 0.0);
        this.ghost.m_21563_().m_24946_(center.f_82479_, center.f_82480_, center.f_82481_);
        double placeDistSqr = 2.1025;
        if (this.ghost.m_20182_().m_82557_(center) <= placeDistSqr) {
            this.ghost.m_9236_().m_7731_(this.targetPlacePos, blockItem.m_40614_().m_49966_(), 3);
            held.m_41774_(1);
            if (held.m_41619_()) {
                this.ghost.setHoldItem(ItemStack.f_41583_);
            }
            this.m_8041_();
            return;
        }
        this.steerSmooth(center);
    }

    private void steerSmooth(Vec3 target) {
        Vec3 delta = target.m_82546_(this.ghost.m_20182_());
        double distance = delta.m_82553_();
        if (distance < 0.001) {
            return;
        }
        double slowRadius = 2.2;
        double speed = this.speed * Mth.m_14008_((double)(distance / slowRadius), (double)0.15, (double)1.0);
        Vec3 velocity = delta.m_82490_(speed / distance);
        Vec3 currentVelocity = this.ghost.m_20184_();
        this.ghost.m_20334_(Mth.m_14139_((double)this.lerp, (double)currentVelocity.f_82479_, (double)velocity.f_82479_), Mth.m_14139_((double)this.lerp, (double)currentVelocity.f_82480_, (double)velocity.f_82480_), Mth.m_14139_((double)this.lerp, (double)currentVelocity.f_82481_, (double)velocity.f_82481_));
    }

    private boolean isSaplingBlockItem(ItemStack stack) {
        return !stack.m_41619_() && stack.m_204117_(ItemTags.f_13180_) && stack.m_41720_() instanceof BlockItem;
    }

    private boolean isValidPlacement(BlockPos placePos, BlockItem blockItem) {
        if (!this.ghost.m_9236_().m_8055_(placePos).m_60795_()) {
            return false;
        }
        BlockPos basePos = placePos.m_7495_();
        BlockState base = this.ghost.m_9236_().m_8055_(basePos);
        if (!base.m_60713_(Blocks.f_50440_) && !base.m_60713_(Blocks.f_50493_)) {
            return false;
        }
        return blockItem.m_40614_().m_49966_().m_60710_((LevelReader)this.ghost.m_9236_(), placePos);
    }

    @Nullable
    private BlockPos findPlantPos() {
        BlockPos origin = this.ghost.m_20183_();
        for (int i = 0; i < 32; ++i) {
            int dx = this.ghost.m_217043_().m_216339_(-this.searchRadius, this.searchRadius + 1);
            int dz = this.ghost.m_217043_().m_216339_(-this.searchRadius, this.searchRadius + 1);
            for (int down = 0; down <= 5; ++down) {
                BlockItem blockItem;
                ItemStack held;
                Item item;
                BlockPos basePos = origin.m_7918_(dx, -down, dz);
                BlockState base = this.ghost.m_9236_().m_8055_(basePos);
                if (!base.m_60713_(Blocks.f_50440_) && !base.m_60713_(Blocks.f_50493_)) continue;
                BlockPos placePos = basePos.m_7494_();
                if (!this.ghost.m_9236_().m_8055_(placePos).m_60795_() || !((item = (held = this.ghost.getHoldItem()).m_41720_()) instanceof BlockItem) || !(blockItem = (BlockItem)item).m_40614_().m_49966_().m_60710_((LevelReader)this.ghost.m_9236_(), placePos)) continue;
                return placePos;
            }
        }
        return null;
    }
}

